/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.database.sqlite;

import net.anwiba.commons.jdbc.name.IDatabaseNamesConstants;
import net.anwiba.commons.jdbc.name.ValidationResultMessages;
import net.anwiba.commons.nls.NLS;
import net.anwiba.commons.utilities.name.INameValidator;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.commons.utilities.validation.IValidationResult;

public final class SqliteNameValidator
implements INameValidator {
    public IValidationResult validate(String value) {
        if (value == null) {
            return IValidationResult.inValid((String)ValidationResultMessages.null_value);
        }
        if (StringUtilities.isNullOrEmpty((String)value)) {
            return IValidationResult.inValid((String)ValidationResultMessages.empty_string_value);
        }
        if (value.length() > 31) {
            return IValidationResult.inValid((String)NLS.bind((String)ValidationResultMessages.more_than_i0_characters, (Object[])new Object[]{value}));
        }
        if (IDatabaseNamesConstants.RESERVED_NAMES.contains(value.toLowerCase())) {
            return IValidationResult.inValid((String)ValidationResultMessages.reserved_name);
        }
        char[] charArray = value.toCharArray();
        int i = 0;
        while (i < charArray.length) {
            char c = charArray[i];
            if (Character.isWhitespace(c)) {
                return IValidationResult.inValid((String)(String.valueOf(ValidationResultMessages.whitespace_at_character) + "_" + i));
            }
            if (!Character.isLowerCase(c) && i == 0) {
                return IValidationResult.inValid((String)(String.valueOf(ValidationResultMessages.unsupported_character_at_index) + "_" + i));
            }
            if (!(Character.isUpperCase(c) || Character.isLowerCase(c) || Character.isDigit(c) || c == '_')) {
                return IValidationResult.inValid((String)(String.valueOf(ValidationResultMessages.unsupported_character_at_index) + "_" + i));
            }
            ++i;
        }
        return IValidationResult.valid();
    }
}

