/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.database.sqlite;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.anwiba.commons.jdbc.DatabaseUtilities;
import net.anwiba.commons.jdbc.connection.IJdbcConnectionDescription;
import net.anwiba.commons.jdbc.database.DatabaseFacade;
import net.anwiba.commons.jdbc.database.INamedTableFilter;
import net.anwiba.commons.jdbc.database.IRegistrableDatabaseFacade;
import net.anwiba.commons.jdbc.name.DatabaseIndexName;
import net.anwiba.commons.jdbc.name.DatabaseSequenceName;
import net.anwiba.commons.jdbc.name.DatabaseTriggerName;
import net.anwiba.commons.jdbc.name.IDatabaseIndexName;
import net.anwiba.commons.jdbc.name.IDatabaseSequenceName;
import net.anwiba.commons.jdbc.name.IDatabaseTableName;
import net.anwiba.commons.jdbc.name.IDatabaseTriggerName;
import net.anwiba.commons.jdbc.software.FileDatabaseSoftware;

public class SqliteDatabaseFacade
extends DatabaseFacade
implements IRegistrableDatabaseFacade {
    public boolean isTable(IDatabaseTableName table) {
        if (this.isSpatialMetaData(table) || this.isSpatialIndex(table) || Objects.equals(table.getTableName(), "sqlite_sequence")) {
            return false;
        }
        return super.isTable(table);
    }

    public String getTableStatement(Connection connection, IDatabaseTableName tableName) throws SQLException {
        return (String)DatabaseUtilities.result((Connection)connection, (String)"SELECT sql FROM sqlite_master WHERE type = 'table' and name = ?", value -> value.setObject(1, tableName.getTableName()), optional -> (String)optional.convert(v -> v.getString(1)).get());
    }

    public boolean supportsTableStatement() {
        return true;
    }

    private boolean isSpatialMetaData(IDatabaseTableName table) {
        return table.getTableName().startsWith("virts_") || table.getTableName().startsWith("vector_") || table.getTableName().startsWith("geometry_columns") || table.getTableName().startsWith("views_geometry_columns") || table.getTableName().startsWith("gpkg_") || Objects.equals(table.getTableName(), "geo_col_ref_sys") || Objects.equals(table.getTableName(), "spatial_ref_sys") || Objects.equals(table.getTableName(), "SpatialIndex") || Objects.equals(table.getTableName(), "spatialite_history");
    }

    private boolean isSpatialIndex(IDatabaseTableName table) {
        return table.getTableName().startsWith("idx_") || table.getTableName().startsWith("rtree_");
    }

    public Iterable<INamedTableFilter> getTableFilters() {
        return Arrays.asList(new INamedTableFilter(){

            public String getName() {
                return "SpatialMetadata";
            }

            public boolean accept(IDatabaseTableName table) {
                return SqliteDatabaseFacade.this.isSpatialMetaData(table);
            }
        }, new INamedTableFilter(){

            public String getName() {
                return "SpatialIndex";
            }

            public boolean accept(IDatabaseTableName table) {
                return SqliteDatabaseFacade.this.isSpatialIndex(table);
            }
        });
    }

    public List<IDatabaseIndexName> getIndicies(Connection connection, IDatabaseTableName tableName) throws SQLException {
        return DatabaseUtilities.results((Connection)connection, (String)"SELECT null, name FROM sqlite_master WHERE type = 'index' and tbl_name = ?", value -> value.setObject(1, tableName.getTableName()), value -> new DatabaseIndexName(value.getString(1), value.getString(2)));
    }

    public ResultSet getIndexMetadata(Connection connection, IDatabaseIndexName name) throws SQLException {
        ResultSet resultSet = DatabaseUtilities.resultSet((Connection)connection, (String)("PRAGMA index_xinfo('" + name.getIndexName() + "')"), value -> {});
        return resultSet;
    }

    public boolean supportsIndicies() {
        return true;
    }

    public List<IDatabaseTriggerName> getTriggers(Connection connection, IDatabaseTableName tableName) throws SQLException {
        return DatabaseUtilities.results((Connection)connection, (String)"SELECT null, name FROM sqlite_master WHERE type = 'trigger' and tbl_name = ?", value -> value.setObject(1, tableName.getTableName()), value -> new DatabaseTriggerName(value.getString(1), value.getString(2)));
    }

    public String getTriggerStatement(Connection connection, IDatabaseTriggerName triggerName) throws SQLException {
        return (String)DatabaseUtilities.result((Connection)connection, (String)"SELECT sql FROM sqlite_master WHERE type = 'trigger' and name = ?", value -> value.setObject(1, triggerName.getTriggerName()), optional -> (String)optional.convert(v -> v.getString(1)).get());
    }

    public boolean supportsTrigger() {
        return true;
    }

    public List<IDatabaseSequenceName> getSequences(Connection connection, String schema) throws SQLException {
        return DatabaseUtilities.results((Connection)connection, (String)"SELECT null, name FROM sqlite_sequence", value -> {}, value -> new DatabaseSequenceName(value.getString(1), value.getString(2)));
    }

    public ResultSet getSequenceMetadata(Connection connection, IDatabaseSequenceName sequence) throws SQLException {
        return DatabaseUtilities.resultSet((Connection)connection, (String)"SELECT * FROM sqlite_sequence WHERE name = ?", value -> value.setObject(1, sequence.getSequenceName()));
    }

    public boolean supportsSequences() {
        return true;
    }

    public boolean isApplicable(IJdbcConnectionDescription context) {
        return Objects.equals(FileDatabaseSoftware.SQLITE.getDriverName(), context.getDriverName());
    }
}

