/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.database.sqlite.column;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.anwiba.commons.jdbc.DatabaseUtilities;
import net.anwiba.commons.jdbc.metadata.ColumnMetaData;
import net.anwiba.commons.jdbc.metadata.IColumnMetaData;
import net.anwiba.commons.jdbc.result.IResult;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.lang.functional.IProcedure;
import net.anwiba.commons.lang.object.ObjectPair;
import net.anwiba.commons.utilities.regex.tokenizer.RegExpUtilities;

public final class SqliteColumnMetaDataReader {
    public List<IColumnMetaData> read(Connection connection, final String tableName) throws SQLException {
        return DatabaseUtilities.results((Connection)connection, (String)("PRAGMA table_info(\"" + tableName + "\");"), (IProcedure)new IProcedure<PreparedStatement, SQLException>(){

            public void execute(PreparedStatement statement) throws SQLException {
            }
        }, (IConverter)new IConverter<IResult, IColumnMetaData, SQLException>(){

            public IColumnMetaData convert(IResult value) throws SQLException {
                String rawType = value.getString(3);
                String columnName = value.getString(2);
                boolean isKey = value.getInteger(6, -1) == 1;
                boolean isNullable = value.getInteger(4, -1) == 0;
                ObjectPair<String, ObjectPair<Integer, Integer>> pair = this.parse(rawType);
                String type = (String)pair.getFirstObject();
                int length = (Integer)((ObjectPair)pair.getSecondObject()).getFirstObject();
                int scale = (Integer)((ObjectPair)pair.getSecondObject()).getSecondObject();
                return new ColumnMetaData(null, tableName, columnName, this.extractType(type), length, scale, isKey, isNullable);
            }

            private String extractType(String type) {
                int index = -1;
                index = type.indexOf("(");
                if (index > -1) {
                    return type.substring(0, index);
                }
                return type;
            }

            private ObjectPair<String, ObjectPair<Integer, Integer>> parse(String rawType) {
                List<String> names = Arrays.asList("CHARACTER", "VARCHAR", "VARYING CHARACTER", "NCHAR", "NVARCHAR");
                for (String name : names) {
                    Matcher matcher;
                    if (rawType.matches(name + "\\(-?[0-9]+\\)") && (matcher = Pattern.compile(name + "\\((-?[0-9]+)\\)").matcher(rawType)).find(0)) {
                        String[] groups = RegExpUtilities.getGroups((Matcher)matcher);
                        if ("0".equals(groups[1])) {
                            return new ObjectPair((Object)name, (Object)new ObjectPair((Object)-1, (Object)0));
                        }
                        return new ObjectPair((Object)name, (Object)new ObjectPair((Object)Integer.valueOf(groups[1]), (Object)0));
                    }
                    if (!rawType.matches(name)) continue;
                    return new ObjectPair((Object)name, (Object)new ObjectPair((Object)-1, (Object)0));
                }
                List<String> numericNames = Arrays.asList("DECIMAL", "NUMERIC", "NUMBER");
                for (String name : numericNames) {
                    if (rawType.matches(name + "\\([0-9]+\\,-?[0-9]+\\)")) {
                        Matcher matcher = Pattern.compile(name + "\\(([0-9]+)\\,(-?[0-9]+)\\)").matcher(rawType);
                        if (matcher.find(0)) {
                            String[] groups = RegExpUtilities.getGroups((Matcher)matcher);
                            return new ObjectPair((Object)"NUMERIC", (Object)new ObjectPair((Object)Integer.valueOf(groups[1]), (Object)Integer.valueOf(groups[2])));
                        }
                        return new ObjectPair((Object)"NUMERIC", (Object)new ObjectPair((Object)-1, (Object)-1));
                    }
                    if (rawType.matches(name + "\\([0-9]+\\)")) {
                        Matcher matcher = Pattern.compile(name + "\\(([0-9]+)\\)").matcher(rawType);
                        if (matcher.find(0)) {
                            String[] groups = RegExpUtilities.getGroups((Matcher)matcher);
                            return new ObjectPair((Object)"NUMERIC", (Object)new ObjectPair((Object)Integer.valueOf(groups[1]), (Object)0));
                        }
                        return new ObjectPair((Object)"NUMERIC", (Object)new ObjectPair((Object)-1, (Object)0));
                    }
                    if (!rawType.matches(name)) continue;
                    return new ObjectPair((Object)"NUMERIC", (Object)new ObjectPair((Object)-1, (Object)-1));
                }
                return new ObjectPair((Object)rawType, (Object)new ObjectPair((Object)0, (Object)0));
            }
        });
    }
}

