/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.database.sqlite.connection;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.anwiba.commons.jdbc.DatabaseUtilities;
import net.anwiba.commons.jdbc.connection.WrappingConnection;
import net.anwiba.commons.lang.functional.IProcedure;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.database.sqlite.ISqliteConnstants;
import net.anwiba.database.sqlite.connection.ILibrary;
import net.anwiba.database.sqlite.connection.ISqliteCapabilities;
import net.anwiba.database.sqlite.connection.ISqliteCapabilitiesProvider;
import net.anwiba.database.sqlite.connection.ISqliteDatabaseConnector;
import net.anwiba.database.sqlite.connection.ISqliteDatabaseConnectorConfiguration;
import net.anwiba.database.sqlite.connection.SqliteCapabilitiesBuilder;
import org.sqlite.SQLiteConfig;

public final class SqliteDatabaseConnector
implements ISqliteDatabaseConnector {
    private static ILogger logger = Logging.getLogger((String)SqliteDatabaseConnector.class.getName());
    private final ISqliteDatabaseConnectorConfiguration configuration;
    private final Map<String, ISqliteCapabilities> capabilities = Collections.synchronizedMap(new HashMap());
    private static final int TIMEOUT = 10;

    public SqliteDatabaseConnector(ISqliteDatabaseConnectorConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean isApplicable(String context) {
        return context != null && context.startsWith(ISqliteConnstants.PROTOCOL);
    }

    public boolean isConnectable(String url, String userName, String password) {
        boolean bl;
        block8: {
            Connection connection = this.connectReadOnly(url, userName, password, 10);
            try {
                bl = true;
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException exception) {
                    logger.log(ILevel.WARNING, exception.getLocalizedMessage(), (Throwable)exception);
                    return false;
                }
            }
            connection.close();
        }
        return bl;
    }

    public synchronized Connection connectReadOnly(String url, String userName, String password, int timeout) throws SQLException {
        return this.connect(url, userName, password, false, timeout, true);
    }

    public Connection connectWritable(String url, String userName, String password, boolean isAutoCommitEnabled, int timeout) throws SQLException {
        return this.connect(url, userName, password, isAutoCommitEnabled, timeout, false);
    }

    public synchronized Connection connect(String url, String userName, String password, boolean isAutoCommitEnabled, int timeout, boolean isReadOnly) throws SQLException {
        logger.log(ILevel.DEBUG, "connect to '" + url + "' readonly '" + isReadOnly + "'");
        Properties properties = this.getProperties(userName, password, isReadOnly, timeout);
        if (isReadOnly) {
            return this.getConnetion(url, properties, false, timeout);
        }
        return this.getConnetion(url, properties, isAutoCommitEnabled, timeout);
    }

    private Properties getProperties(String userName, String password, boolean isReadOnly, int timeout) {
        SQLiteConfig config = new SQLiteConfig();
        config.setReadOnly(isReadOnly);
        config.setSharedCache(true);
        config.enableLoadExtension(true);
        return config.toProperties();
    }

    private Connection getConnetion(String url, Properties properties, boolean isAutoCommitEnabled, int timeout) throws SQLException {
        Connection connection = this.createConnection(url, properties, timeout);
        connection.setAutoCommit(isAutoCommitEnabled);
        if (!this.capabilities.containsKey(url)) {
            this.capabilities.put(url, this.checkCapabilities(connection));
        }
        return this.wrap(url, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection createConnection(String url, Properties properties, int timeout) throws SQLException {
        if (timeout == -1) {
            return DriverManager.getConnection(url, properties);
        }
        int loginTimeout = DriverManager.getLoginTimeout();
        try {
            DriverManager.setLoginTimeout(timeout);
            Connection connection = DriverManager.getConnection(url, properties);
            return connection;
        }
        finally {
            DriverManager.setLoginTimeout(loginTimeout);
        }
    }

    private ISqliteCapabilities checkCapabilities(Connection connection) throws SQLException {
        SqliteCapabilitiesBuilder builder = new SqliteCapabilitiesBuilder();
        try (Statement statement = connection.createStatement();){
            statement.setQueryTimeout(30);
            String sqliteVersion = this.getSqliteVersion(statement);
            builder.setSqliteVersion(sqliteVersion);
            logger.log(ILevel.DEBUG, "sqlite version '" + sqliteVersion + "'");
            for (ILibrary extension : this.configuration.getExtensions()) {
                try {
                    logger.log(ILevel.DEBUG, "try to load extention '" + extension.getName() + "'");
                    logger.log(ILevel.DEBUG, "extention loaded '" + extension.getResource() + "'");
                }
                catch (Exception exception) {
                    logger.log(ILevel.WARNING, "Couldn't load extention '" + extension.getName() + "'");
                    logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
                }
            }
            String spatiaLiteVersion = this.getSpatiaLiteVersion(statement);
            logger.log(ILevel.DEBUG, "spatialite version '" + spatiaLiteVersion + "'");
            if (spatiaLiteVersion != null) {
                builder.setSpatiaLiteVersion(spatiaLiteVersion);
            } else {
                ILibrary spatialiteLibrary = this.configuration.getSpatialite();
                if (spatialiteLibrary != null) {
                    try {
                        logger.log(ILevel.DEBUG, "try to load extention 'spatialite'");
                        statement.execute("SELECT load_extension('" + spatialiteLibrary.getResource() + "')");
                        logger.log(ILevel.DEBUG, "extention loaded '" + spatialiteLibrary.getResource() + "'");
                        String loadedSpatiaLiteVersion = this.getSpatiaLiteVersion(statement);
                        logger.log(ILevel.DEBUG, "loaded spatialite version '" + loadedSpatiaLiteVersion + "'");
                        builder.setSpatiaLiteVersion(loadedSpatiaLiteVersion);
                    }
                    catch (Exception exception) {
                        logger.log(ILevel.WARNING, "Couldn't load extention '" + spatialiteLibrary.getResource() + "'");
                        logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
                    }
                }
            }
        }
        this.checkSpatiaLiteDatabaseVersion(builder, connection);
        return builder.build();
    }

    private void checkSpatiaLiteDatabaseVersion(SqliteCapabilitiesBuilder builder, Connection connection) throws SQLException {
        if (DatabaseUtilities.count((Connection)connection, (String)"SELECT count(*) FROM sqlite_master WHERE type=? AND name = ?", (Object[])new Object[]{"table", "geometry_columns"}) == 0) {
            logger.log(ILevel.DEBUG, "no spatialite");
            return;
        }
        if (DatabaseUtilities.contains((Connection)connection, (String)"PRAGMA table_info('geometry_columns')", (String)"name", (Object)"type")) {
            logger.log(ILevel.DEBUG, "spatialite 2.0 structur spatialite");
            builder.setSpatiaLiteDatabaseVersion("2.0");
            return;
        }
        logger.log(ILevel.DEBUG, "spatialite 4.0 structur spatialite");
        builder.setSpatiaLiteDatabaseVersion("4.0");
    }

    private WrappingConnection wrap(String url, Connection connection) {
        return new WrappingConnection(connection, (IProcedure)new IProcedure<WrappingConnection, SQLException>(){

            public void execute(WrappingConnection wrappingConnection) throws SQLException {
                try {
                    Connection wrappedConnection = wrappingConnection.getConnection();
                    logger.log(ILevel.DEBUG, "close connection");
                    wrappedConnection.close();
                }
                catch (SQLException exception) {
                    logger.log(ILevel.WARNING, "Couldn't close connection");
                    throw exception;
                }
            }
        });
    }

    private String getSpatiaLiteVersion(Statement statement) {
        return DatabaseUtilities.getAsString((Statement)statement, (String)"SELECT spatialite_version()");
    }

    private String getSqliteVersion(Statement statement) {
        return DatabaseUtilities.getAsString((Statement)statement, (String)"SELECT sqlite_version()");
    }

    @Override
    public ISqliteCapabilitiesProvider getSqliteCapabilitiesProvider() {
        final Map<String, ISqliteCapabilities> capabilities = this.capabilities;
        return new ISqliteCapabilitiesProvider(){

            private ISqliteCapabilities getSqliteCapabilities(String url, String userName, String password) {
                this.check(url, userName, password);
                return (ISqliteCapabilities)capabilities.get(url);
            }

            private void check(String url, String userName, String password) {
                SqliteDatabaseConnector.this.isConnectable(url, userName, password);
            }

            @Override
            public boolean canChange(String url, String userName, String password) {
                ISqliteCapabilities capabilities2 = this.getSqliteCapabilities(url, userName, password);
                if (capabilities2 == null) {
                    return false;
                }
                return capabilities2.canChange();
            }

            @Override
            public boolean isExtended(String url, String userName, String password) {
                ISqliteCapabilities capabilities2 = this.getSqliteCapabilities(url, userName, password);
                if (capabilities2 == null) {
                    return false;
                }
                return capabilities2.isExtended();
            }
        };
    }
}

