/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.database.swing.console;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.TransferHandler;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.reference.utilities.IoUtilities;

public final class PlainTextEditorPaneTransferHandler
extends TransferHandler {
    private static ILogger logger = Logging.getLogger(PlainTextEditorPaneTransferHandler.class);
    private final PlainDocument document;
    private final JEditorPane editorPane;
    private static final long serialVersionUID = 1L;
    final DataFlavor textPlainUnicodeFlavor = DataFlavor.getTextPlainUnicodeFlavor();

    public PlainTextEditorPaneTransferHandler(PlainDocument document, JEditorPane editorPane) {
        this.document = document;
        this.editorPane = editorPane;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        for (DataFlavor flavor : transferFlavors) {
            if (DataFlavor.stringFlavor.equals(flavor)) {
                return true;
            }
            if (!this.textPlainUnicodeFlavor.equals(flavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(JComponent comp, Transferable transferable) {
        int start = this.editorPane.getSelectionStart();
        int end = this.editorPane.getSelectionEnd();
        if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String data = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                this.insertEditorContent(data, start, end);
            }
            catch (UnsupportedFlavorException | IOException exception) {
                return false;
            }
            return true;
        }
        if (transferable.isDataFlavorSupported(this.textPlainUnicodeFlavor)) {
            try (InputStream data = (InputStream)transferable.getTransferData(this.textPlainUnicodeFlavor);){
                String string = IoUtilities.toString((InputStream)data, (String)this.textPlainUnicodeFlavor.getParameter("charset"));
                this.insertEditorContent(string, start, end);
            }
            catch (UnsupportedFlavorException | IOException exception) {
                return false;
            }
            return true;
        }
        return false;
    }

    private void insertEditorContent(String string, int start, int end) {
        try {
            if (start == end) {
                this.document.insertString(start, string, null);
            } else {
                this.document.replace(start, end - start, string, null);
            }
        }
        catch (BadLocationException exception) {
            logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
        }
    }
}

