/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.database.swing.console;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import net.anwiba.commons.jdbc.connection.IDatabaseConnector;
import net.anwiba.commons.jdbc.connection.IJdbcConnectionDescription;
import net.anwiba.commons.jdbc.database.IDatabaseFacade;
import net.anwiba.commons.jdbc.name.IDatabaseConstraintName;
import net.anwiba.commons.jdbc.name.IDatabaseIndexName;
import net.anwiba.commons.jdbc.name.IDatabaseSequenceName;
import net.anwiba.commons.jdbc.name.IDatabaseTableName;
import net.anwiba.commons.jdbc.name.IDatabaseTriggerName;
import net.anwiba.commons.lang.exception.CanceledException;
import net.anwiba.commons.lang.functional.IAggregator;
import net.anwiba.commons.lang.functional.IApplicable;
import net.anwiba.commons.lang.functional.IBlock;
import net.anwiba.commons.lang.functional.IConsumer;
import net.anwiba.commons.lang.object.IObjectToStringConverter;
import net.anwiba.commons.lang.object.ObjectUtilities;
import net.anwiba.commons.lang.stream.Streams;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.model.AndAggregatedBooleanDistributor;
import net.anwiba.commons.model.BooleanModel;
import net.anwiba.commons.model.IBooleanDistributor;
import net.anwiba.commons.model.IBooleanModel;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.model.OrAggregatedBooleanDistributor;
import net.anwiba.commons.preferences.IPreferences;
import net.anwiba.commons.preferences.StringListPreference;
import net.anwiba.commons.reference.utilities.FileUtilities;
import net.anwiba.commons.reference.utilities.IoUtilities;
import net.anwiba.commons.swing.action.ActionProcedurBuilder;
import net.anwiba.commons.swing.action.ConfigurableActionBuilder;
import net.anwiba.commons.swing.dialog.DataState;
import net.anwiba.commons.swing.dialog.pane.AbstractContentPane;
import net.anwiba.commons.swing.dialog.progress.ProgressDialogLauncher;
import net.anwiba.commons.swing.filechooser.FileChoosers;
import net.anwiba.commons.swing.filechooser.IFileChooserResult;
import net.anwiba.commons.swing.filechooser.IOpenFileChooserConfiguration;
import net.anwiba.commons.swing.filechooser.ISaveFileChooserConfiguration;
import net.anwiba.commons.swing.filechooser.OpenFileChooserConfiguration;
import net.anwiba.commons.swing.filechooser.SaveFileChooserConfiguration;
import net.anwiba.commons.swing.icon.IGuiIcon;
import net.anwiba.commons.swing.icons.gnome.contrast.high.ContrastHightIcons;
import net.anwiba.commons.swing.object.IObjectField;
import net.anwiba.commons.swing.object.StringFieldBuilder;
import net.anwiba.commons.swing.table.Table;
import net.anwiba.commons.swing.tree.FilteredDefaultTreeModel;
import net.anwiba.commons.swing.ui.ObjectUiBuilder;
import net.anwiba.commons.swing.ui.ObjectUiListCellRenderer;
import net.anwiba.commons.swing.utilities.GuiUtilities;
import net.anwiba.commons.thread.cancel.ICanceler;
import net.anwiba.commons.thread.process.IProcessManager;
import net.anwiba.commons.thread.process.ProcessBuilder;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.database.swing.console.PlainTextEditorPaneTransferHandler;
import net.anwiba.database.swing.console.SqlConsoleMessages;
import net.anwiba.database.swing.console.StatementExecutor;
import net.anwiba.database.swing.console.converter.IDataBaseTableCellValueToStringConverterProvider;
import net.anwiba.database.swing.console.result.DataBaseTableCellValueRenderFactory;
import net.anwiba.database.swing.console.result.ResultReseter;
import net.anwiba.database.swing.console.result.ResultSetTableModel;
import net.anwiba.database.swing.console.tree.DatabaseNamesTreeRenderer;
import net.anwiba.database.swing.console.tree.SchemaTreeFactory;

public final class SqlConsoleContentPane
extends AbstractContentPane {
    static ILogger logger = Logging.getLogger(SqlConsoleContentPane.class);
    private static final Clipboard CLIPBOARD = Toolkit.getDefaultToolkit().getSystemClipboard();
    private final IJdbcConnectionDescription description;
    private final IObjectModel<Connection> connectionModel;
    private final IBooleanModel isDisconnectedModel;
    private final IBooleanModel isConnectedModel;
    private final IDatabaseConnector databaseConnector;
    private final IPreferences preferences;
    private final IBooleanDistributor createStatementActionsEnabledDistributor;
    private final IBooleanDistributor propertiesActionsEnabledDistributor;
    private final IBooleanDistributor tableActionsEnabledDistributor;
    private final IBooleanDistributor textActionsEnabledDistributor;
    private final StatementExecutor statementExecutor;
    private final ResultReseter resultReseter;
    private final IObjectModel<Statement> statementModel = new ObjectModel();
    private final IObjectModel<ResultSet> resultSetModel = new ObjectModel();
    private final IObjectModel<IDatabaseTableName> selectedTable = new ObjectModel();
    private final IObjectModel<IDatabaseSequenceName> selectedSequence = new ObjectModel();
    private final IObjectModel<IDatabaseTriggerName> selectedTrigger = new ObjectModel();
    private final IObjectModel<IDatabaseIndexName> selectedIndex = new ObjectModel();
    private final IObjectModel<IDatabaseConstraintName> selectedConstraint = new ObjectModel();
    private final IBooleanModel isTextAvailableModel = new BooleanModel(false);
    private final IBooleanModel isTableSelectedModel = new BooleanModel(false);
    private final IBooleanModel isSequenceSelectedModel = new BooleanModel(false);
    private final IBooleanModel isTriggerSelectedModel = new BooleanModel(false);
    private final IBooleanModel isIndexSelectedModel = new BooleanModel(false);
    private final IBooleanModel isConstraintSelectedModel = new BooleanModel(false);
    private final IObjectModel<String> statusModel = new ObjectModel();
    private final DefaultComboBoxModel<String> historyComboBoxModel = new DefaultComboBoxModel();
    private JPanel contentPane;
    private final IDataBaseTableCellValueToStringConverterProvider dataBaseTableCellValueToStringConverterProvider;
    private final DataBaseTableCellValueRenderFactory dataBaseTableCellValueRenderFactory;
    private final IDatabaseFacade databaseFacade;
    private final SchemaTreeFactory schemaTreeFactory;
    private final String schema;

    public SqlConsoleContentPane(IObjectModel<DataState> dataStateModel, IPreferences preferences, final IProcessManager processManager, IDatabaseConnector databaseConnector, IDatabaseFacade databaseFacade, IJdbcConnectionDescription description, String schema, IDataBaseTableCellValueToStringConverterProvider dataBaseTableCellValueToStringConverterProvider, IObjectModel<Connection> connectionModel, IBooleanModel isDisconnectedModel, IBooleanModel isConnectedModel) {
        super(dataStateModel);
        this.databaseFacade = databaseFacade;
        this.schema = schema;
        this.dataBaseTableCellValueRenderFactory = new DataBaseTableCellValueRenderFactory(dataBaseTableCellValueToStringConverterProvider);
        this.historyComboBoxModel.addElement(null);
        final StringListPreference statementListPreference = new StringListPreference(preferences.node(new String[]{description.getProtocol()}).node(new String[]{"statements"}));
        statementListPreference.get().stream().forEach(v -> this.historyComboBoxModel.addElement((String)v));
        this.historyComboBoxModel.setSelectedItem(null);
        this.historyComboBoxModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                int size = SqlConsoleContentPane.this.historyComboBoxModel.getSize();
                List values = Streams.until((int)size).convert(p -> SqlConsoleContentPane.this.historyComboBoxModel.getElementAt((int)p)).asList();
                processManager.execute(new ProcessBuilder().setExecutable((m, c, i) -> statementListPreference.set(values)).build());
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
            }
        });
        this.databaseConnector = databaseConnector;
        this.preferences = preferences;
        this.description = description;
        this.dataBaseTableCellValueToStringConverterProvider = dataBaseTableCellValueToStringConverterProvider;
        this.connectionModel = connectionModel;
        this.isDisconnectedModel = isDisconnectedModel;
        this.isConnectedModel = isConnectedModel;
        this.tableActionsEnabledDistributor = new AndAggregatedBooleanDistributor(Arrays.asList(isConnectedModel, this.isTableSelectedModel));
        this.textActionsEnabledDistributor = new AndAggregatedBooleanDistributor(Arrays.asList(isConnectedModel, this.isTextAvailableModel));
        this.propertiesActionsEnabledDistributor = new AndAggregatedBooleanDistributor(Arrays.asList(isConnectedModel, new OrAggregatedBooleanDistributor(Arrays.asList(this.isTableSelectedModel, this.isSequenceSelectedModel, this.isIndexSelectedModel, this.isConstraintSelectedModel, this.isTriggerSelectedModel))));
        this.createStatementActionsEnabledDistributor = new AndAggregatedBooleanDistributor(Arrays.asList(isConnectedModel, new OrAggregatedBooleanDistributor(Arrays.asList(this.isTriggerSelectedModel, new AndAggregatedBooleanDistributor(Arrays.asList(this.isTableSelectedModel, new BooleanModel(databaseFacade.supportsTableStatement())))))));
        this.resultReseter = new ResultReseter(this.statementModel, this.resultSetModel);
        this.schemaTreeFactory = new SchemaTreeFactory(databaseFacade, connectionModel, this.statusModel, isDisconnectedModel, isConnectedModel);
        this.statementExecutor = new StatementExecutor(connectionModel, this.resultReseter, this.statementModel, this.resultSetModel, this.statusModel, this.historyComboBoxModel, isDisconnectedModel, isConnectedModel);
    }

    public JComponent getComponent() {
        if (this.contentPane == null) {
            DefaultMutableTreeNode root = this.schemaTreeFactory.create(ICanceler.DummyCanceler, this.description, this.schema);
            FilteredDefaultTreeModel schemaTreeModel = new FilteredDefaultTreeModel((TreeNode)root);
            final JEditorPane editorPane = new JEditorPane("text/plain", "");
            final PlainDocument document = (PlainDocument)editorPane.getDocument();
            final JTree treePane = new JTree((TreeModel)schemaTreeModel);
            treePane.setCellRenderer(new DatabaseNamesTreeRenderer());
            JToolBar treeToolBar = new JToolBar();
            treeToolBar.setFloatable(false);
            treeToolBar.add(new ConfigurableActionBuilder().setName(SqlConsoleMessages.connect).setTooltip(SqlConsoleMessages.connect).setIcon((IGuiIcon)ContrastHightIcons.GTK_CONNECT).setEnabledDistributor((IBooleanDistributor)this.isDisconnectedModel).setProcedure(c -> this.connect(c)).build());
            treeToolBar.add(new ConfigurableActionBuilder().setName(SqlConsoleMessages.disconnect).setTooltip(SqlConsoleMessages.disconnect).setIcon((IGuiIcon)ContrastHightIcons.GTK_DISCONNECT).setEnabledDistributor((IBooleanDistributor)this.isConnectedModel).setProcedure(c -> this.disconnect(c)).build());
            treeToolBar.add(new ConfigurableActionBuilder().setName(SqlConsoleMessages.reload).setTooltip(SqlConsoleMessages.reloadDatabaseSchema).setIcon((IGuiIcon)ContrastHightIcons.VIEW_REFRESH).setEnabledDistributor((IBooleanDistributor)this.isConnectedModel).setTask((monitor, canceler, value) -> {
                DefaultMutableTreeNode node = this.schemaTreeFactory.create(canceler, this.description, this.schema);
                if (node == null) {
                    return null;
                }
                schemaTreeModel.setRoot((TreeNode)node);
                return null;
            }).build());
            treeToolBar.add(new ConfigurableActionBuilder().setName(SqlConsoleMessages.properties).setTooltip(SqlConsoleMessages.properties).setIcon((IGuiIcon)ContrastHightIcons.DIALOG_INFORMATION).setEnabledDistributor(this.propertiesActionsEnabledDistributor).setTask(() -> {
                if (this.isTableSelectedModel.isTrue()) {
                    this.getMetadataResult((IAggregator<DatabaseMetaData, IDatabaseTableName, ResultSet, SQLException>)((IAggregator)(metaData, tableName) -> {
                        if (this.databaseFacade.supportsTables()) {
                            return this.databaseFacade.getTableMetadata((Connection)this.connectionModel.get(), tableName);
                        }
                        return metaData.getColumns(this.getCatalog(), tableName.getSchemaName(), tableName.getTableName(), null);
                    }));
                }
                if (this.isSequenceSelectedModel.isTrue()) {
                    this.querySequenceMetadata((IDatabaseSequenceName)this.selectedSequence.get());
                }
                if (this.isTriggerSelectedModel.isTrue()) {
                    this.queryTriggerMetadata((IDatabaseTriggerName)this.selectedTrigger.get());
                }
                if (this.isIndexSelectedModel.isTrue()) {
                    this.queryIndexMetadata((IDatabaseIndexName)this.selectedIndex.get());
                }
                if (this.isConstraintSelectedModel.isTrue()) {
                    this.queryConstraintMetadata((IDatabaseConstraintName)this.selectedConstraint.get());
                }
            }).build());
            treeToolBar.add(new ConfigurableActionBuilder().setName(SqlConsoleMessages.tablePrivileges).setTooltip(SqlConsoleMessages.tablePrivileges).setEnabledDistributor(this.tableActionsEnabledDistributor).setIcon((IGuiIcon)ContrastHightIcons.SECURITY_MEDIUM).setTask(() -> this.getMetadataResult((IAggregator<DatabaseMetaData, IDatabaseTableName, ResultSet, SQLException>)((IAggregator)(metaData, tableName) -> metaData.getTablePrivileges(this.getCatalog(), tableName.getSchemaName(), tableName.getTableName())))).build());
            treeToolBar.add(new ConfigurableActionBuilder().setName(SqlConsoleMessages.columnPrivileges).setTooltip(SqlConsoleMessages.columnPrivileges).setEnabledDistributor(this.tableActionsEnabledDistributor).setIcon((IGuiIcon)ContrastHightIcons.SECURITY_HIGH).setTask(() -> this.getMetadataResult((IAggregator<DatabaseMetaData, IDatabaseTableName, ResultSet, SQLException>)((IAggregator)(metaData, tableName) -> metaData.getColumnPrivileges(this.getCatalog(), tableName.getSchemaName(), tableName.getTableName(), null)))).build());
            treeToolBar.add(new ConfigurableActionBuilder().setName(SqlConsoleMessages.content).setTooltip(SqlConsoleMessages.content).setEnabledDistributor(this.tableActionsEnabledDistributor).setIcon((IGuiIcon)ContrastHightIcons.VIEW_LIST_TEXT).setTask(() -> this.statementExecutor.executeStatement(ICanceler.DummyCanceler, this.createTableSelectStatement((IDatabaseTableName)this.selectedTable.get()))).build());
            treeToolBar.add(new ConfigurableActionBuilder().setName(SqlConsoleMessages.createStatement).setTooltip(SqlConsoleMessages.createStatement).setEnabledDistributor(this.createStatementActionsEnabledDistributor).setIcon((IGuiIcon)ContrastHightIcons.FORMAT_JUSTIFY_LEFT).setTask(() -> {
                try {
                    this.statusModel.set((Object)SqlConsoleMessages.working);
                    String statement = null;
                    if (this.isTriggerSelectedModel.isTrue()) {
                        statement = this.databaseFacade.getTriggerStatement((Connection)this.connectionModel.get(), (IDatabaseTriggerName)this.selectedTrigger.get());
                    }
                    if (this.isTableSelectedModel.isTrue()) {
                        statement = this.databaseFacade.getTableStatement((Connection)this.connectionModel.get(), (IDatabaseTableName)this.selectedTable.get());
                    }
                    if (statement == null) {
                        this.statusModel.set((Object)SqlConsoleMessages.emptyResult);
                        return;
                    }
                    this.setEditorContent(document, statement);
                    this.statusModel.set((Object)SqlConsoleMessages.done);
                }
                catch (SQLException exception) {
                    logger.log(ILevel.DEBUG, "Couldn't close connection", (Throwable)exception);
                    this.statusModel.set((Object)exception.getMessage());
                }
            }).build());
            TreeSelectionModel schemaTreeSelectionModel = treePane.getSelectionModel();
            schemaTreeSelectionModel.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    TreePath treePath = e.getNewLeadSelectionPath();
                    SqlConsoleContentPane.this.consumeObject(treePath, (IApplicable<Object>)((IApplicable)o -> true), (IConsumer<Object, RuntimeException>)((IConsumer)input -> {
                        SqlConsoleContentPane.this.selectedTable.set(null);
                        SqlConsoleContentPane.this.selectedSequence.set(null);
                        SqlConsoleContentPane.this.selectedTrigger.set(null);
                        SqlConsoleContentPane.this.selectedIndex.set(null);
                        SqlConsoleContentPane.this.selectedConstraint.set(null);
                        if (input instanceof IDatabaseTableName) {
                            SqlConsoleContentPane.this.selectedTable.set((Object)((IDatabaseTableName)input));
                        } else if (input instanceof IDatabaseSequenceName) {
                            SqlConsoleContentPane.this.selectedSequence.set((Object)((IDatabaseSequenceName)input));
                        } else if (input instanceof IDatabaseTriggerName) {
                            SqlConsoleContentPane.this.selectedTrigger.set((Object)((IDatabaseTriggerName)input));
                        } else if (input instanceof IDatabaseIndexName) {
                            SqlConsoleContentPane.this.selectedIndex.set((Object)((IDatabaseIndexName)input));
                        } else if (input instanceof IDatabaseConstraintName) {
                            SqlConsoleContentPane.this.selectedConstraint.set((Object)((IDatabaseConstraintName)input));
                        }
                        SqlConsoleContentPane.this.isTableSelectedModel.set(input instanceof IDatabaseTableName);
                        SqlConsoleContentPane.this.isSequenceSelectedModel.set(input instanceof IDatabaseSequenceName);
                        SqlConsoleContentPane.this.isTriggerSelectedModel.set(input instanceof IDatabaseTriggerName);
                        SqlConsoleContentPane.this.isIndexSelectedModel.set(input instanceof IDatabaseIndexName);
                        SqlConsoleContentPane.this.isConstraintSelectedModel.set(input instanceof IDatabaseConstraintName);
                    }));
                }
            });
            treePane.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() != 2) {
                        return;
                    }
                    SqlConsoleContentPane.this.consumeObject(treePane.getSelectionPath(), (IApplicable<Object>)((IApplicable)o -> o instanceof IDatabaseTableName || o instanceof IDatabaseIndexName || o instanceof IDatabaseConstraintName || o instanceof IDatabaseSequenceName || o instanceof IDatabaseTriggerName), (IConsumer<Object, RuntimeException>)((IConsumer)t -> Optional.ofNullable(t).ifPresent(o -> SqlConsoleContentPane.this.run(e.getComponent(), SqlConsoleMessages.SQLConsole, SqlConsoleMessages.loadTableContent, (IBlock<RuntimeException>)((IBlock)() -> {
                        if (o instanceof IDatabaseTableName) {
                            SqlConsoleContentPane.this.statementExecutor.executeStatement(ICanceler.DummyCanceler, SqlConsoleContentPane.this.createTableSelectStatement((IDatabaseTableName)o));
                        }
                        if (o instanceof IDatabaseSequenceName) {
                            SqlConsoleContentPane.this.querySequenceMetadata((IDatabaseSequenceName)o);
                        }
                        if (o instanceof IDatabaseTriggerName) {
                            SqlConsoleContentPane.this.queryTriggerMetadata((IDatabaseTriggerName)o);
                        }
                        if (o instanceof IDatabaseIndexName) {
                            SqlConsoleContentPane.this.queryIndexMetadata((IDatabaseIndexName)o);
                        }
                        if (o instanceof IDatabaseConstraintName) {
                            SqlConsoleContentPane.this.queryConstraintMetadata((IDatabaseConstraintName)o);
                        }
                    })))));
                }
            });
            JScrollPane treeScrollPane = new JScrollPane(treePane);
            treeScrollPane.setMinimumSize(new Dimension(220, 300));
            JPanel treeHeadComponent = new JPanel(new BorderLayout());
            treeHeadComponent.add((Component)treeToolBar, "North");
            JPanel treeContainerPane = new JPanel(new BorderLayout());
            treeContainerPane.setMinimumSize(new Dimension(240, 320));
            treeContainerPane.add((Component)treeHeadComponent, "North");
            treeContainerPane.add((Component)treeScrollPane, "Center");
            final JComboBox<String> historyComboBox = new JComboBox<String>(this.historyComboBoxModel);
            historyComboBox.setRenderer((ListCellRenderer<String>)new ObjectUiListCellRenderer(new ObjectUiBuilder().tooltip(t -> this.toHtml((String)t)).build()));
            historyComboBox.addActionListener(e -> {
                if (this.historyComboBoxModel.getSelectedItem() != null) {
                    this.setEditorContent(document, (String)this.historyComboBoxModel.getSelectedItem());
                }
            });
            document.addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.check(document, historyComboBox);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.check(document, historyComboBox);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.check(document, historyComboBox);
                }

                private void check(PlainDocument document2, JComboBox<String> historyComboBox2) {
                    try {
                        SqlConsoleContentPane.this.isTextAvailableModel.set(document2.getLength() > 0);
                        String string = document2.getText(0, document2.getLength());
                        if (StringUtilities.isNullOrTrimmedEmpty((String)string) || ObjectUtilities.equals((Object)string, (Object)SqlConsoleContentPane.this.historyComboBoxModel.getSelectedItem())) {
                            return;
                        }
                        historyComboBox2.setSelectedItem(null);
                    }
                    catch (BadLocationException exception) {
                        logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
                    }
                }
            });
            JToolBar editorToolBar = new JToolBar();
            editorToolBar.setFloatable(false);
            editorToolBar.add(new ConfigurableActionBuilder().setName(SqlConsoleMessages.open).setTooltip(SqlConsoleMessages.open).setIcon((IGuiIcon)ContrastHightIcons.DOCUMENT_OPEN).setProcedure(component -> this.setEditorContent(document, this.open(component, this.getEditiorContent(document)))).build());
            editorToolBar.add(new ConfigurableActionBuilder().setName(SqlConsoleMessages.save).setTooltip(SqlConsoleMessages.save).setIcon((IGuiIcon)ContrastHightIcons.DOCUMENT_SAVE).setEnabledDistributor((IBooleanDistributor)this.isTextAvailableModel).setProcedure(component -> this.save(component, this.getEditiorContent(document))).build());
            editorToolBar.add(new ConfigurableActionBuilder().setName(SqlConsoleMessages.execute).setTooltip(SqlConsoleMessages.execute).setEnabledDistributor(this.textActionsEnabledDistributor).setIcon((IGuiIcon)ContrastHightIcons.MEDIA_PLAYBACK_START).setProcedure(new ActionProcedurBuilder().setInitializer(parentComponent -> this.getEditiorContent(document)).setTask((monitor, canceler, statementString) -> {
                if (statementString == null || statementString.isBlank()) {
                    return null;
                }
                this.statementExecutor.executeStatement(canceler, (String)statementString);
                return null;
            }).build()).build());
            editorPane.setTransferHandler(new PlainTextEditorPaneTransferHandler(document, editorPane));
            editorPane.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent event) {
                    if (event.isControlDown()) {
                        if (event.getKeyCode() == 67) {
                            int end;
                            int start = editorPane.getSelectionStart();
                            String editorContent = SqlConsoleContentPane.this.getEditorContent(document, start, end = editorPane.getSelectionEnd());
                            if (editorContent == null) {
                                return;
                            }
                            StringSelection selection = new StringSelection(editorContent);
                            CLIPBOARD.setContents(selection, selection);
                            return;
                        }
                        if (event.getKeyCode() == 88) {
                            int end;
                            int start = editorPane.getSelectionStart();
                            String editorContent = SqlConsoleContentPane.this.getEditorContent(document, start, end = editorPane.getSelectionEnd());
                            if (editorContent == null) {
                                return;
                            }
                            SqlConsoleContentPane.this.insertEditorContent(document, "", start, end);
                            StringSelection selection = new StringSelection(editorContent);
                            CLIPBOARD.setContents(selection, selection);
                            return;
                        }
                    }
                }
            });
            JScrollPane editorScrollPane = new JScrollPane(editorPane);
            editorScrollPane.setMinimumSize(new Dimension(400, 300));
            JPanel editorHeadPane = new JPanel(new BorderLayout());
            editorHeadPane.add((Component)editorToolBar, "North");
            editorHeadPane.add(historyComboBox, "Center");
            JPanel editorContainerPane = new JPanel(new BorderLayout());
            editorContainerPane.setMinimumSize(new Dimension(400, 320));
            editorContainerPane.add((Component)editorHeadPane, "North");
            editorContainerPane.add((Component)editorScrollPane, "Center");
            final ResultSetTableModel tableModel = new ResultSetTableModel(this.statusModel, this.resultSetModel);
            Table resultTable = new Table((TableModel)tableModel, s -> StringUtilities.reduce((String)s, (int)8, (int)120));
            DragSource source = DragSource.getDefaultDragSource();
            resultTable.addKeyListener(new KeyAdapter((JTable)resultTable){
                final /* synthetic */ JTable val$resultTable;
                {
                    this.val$resultTable = jTable;
                }

                @Override
                public void keyReleased(KeyEvent event) {
                    if (event.isControlDown() && event.getKeyCode() == 67) {
                        StringSelection selection = new StringSelection(SqlConsoleContentPane.this.getSelectedRowsAsString(tableModel, this.val$resultTable));
                        CLIPBOARD.setContents(selection, selection);
                    }
                }
            });
            source.createDefaultDragGestureRecognizer((Component)resultTable, 1, new DragGestureListener((JTable)resultTable){
                final /* synthetic */ JTable val$resultTable;
                {
                    this.val$resultTable = jTable;
                }

                @Override
                public void dragGestureRecognized(DragGestureEvent dge) {
                    ResultSet result = (ResultSet)SqlConsoleContentPane.this.resultSetModel.get();
                    if (result == null) {
                        return;
                    }
                    Transferable transferable = new Transferable(){
                        final DataFlavor textPlainUnicodeFlavor = DataFlavor.getTextPlainUnicodeFlavor();

                        @Override
                        public boolean isDataFlavorSupported(DataFlavor flavor) {
                            return DataFlavor.stringFlavor.equals(flavor) || this.textPlainUnicodeFlavor.equals(flavor);
                        }

                        @Override
                        public DataFlavor[] getTransferDataFlavors() {
                            return new DataFlavor[]{DataFlavor.stringFlavor, this.textPlainUnicodeFlavor};
                        }

                        @Override
                        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                            String string = SqlConsoleContentPane.this.getSelectedRowsAsString(tableModel, val$resultTable);
                            if (this.textPlainUnicodeFlavor.equals(flavor)) {
                                return new ByteArrayInputStream(string.getBytes(this.textPlainUnicodeFlavor.getParameter("charset")));
                            }
                            return string;
                        }
                    };
                    dge.startDrag(null, transferable);
                }
            });
            resultTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

                @Override
                public void columnSelectionChanged(ListSelectionEvent e) {
                }

                @Override
                public void columnRemoved(TableColumnModelEvent e) {
                }

                @Override
                public void columnMoved(TableColumnModelEvent e) {
                }

                @Override
                public void columnMarginChanged(ChangeEvent e) {
                }

                @Override
                public void columnAdded(TableColumnModelEvent e) {
                    GuiUtilities.invokeLater(() -> {
                        int index;
                        TableColumnModel source = (TableColumnModel)e.getSource();
                        TableColumn column = source.getColumn(index = e.getToIndex());
                        Object headerValue = column.getHeaderValue();
                        if (headerValue == null || SqlConsoleMessages.empty.equals(headerValue)) {
                            return;
                        }
                        column.setCellRenderer(SqlConsoleContentPane.this.dataBaseTableCellValueRenderFactory.create(SqlConsoleContentPane.this.description, tableModel.getColumnTypeName(index)));
                    });
                }
            });
            resultTable.setAutoResizeMode(0);
            JScrollPane resultTableScrollPane = new JScrollPane((Component)resultTable);
            resultTableScrollPane.setVerticalScrollBarPolicy(20);
            resultTableScrollPane.setHorizontalScrollBarPolicy(30);
            JPanel resultPane = new JPanel(new GridLayout(1, 1, 2, 2));
            resultPane.add(resultTableScrollPane);
            JPanel panel = new JPanel(new BorderLayout(2, 2));
            IObjectField statusField = ((StringFieldBuilder)((StringFieldBuilder)((StringFieldBuilder)new StringFieldBuilder().setEditable(false)).setBackgroundColor(panel.getBackground())).setModel(this.statusModel)).build();
            JSplitPane verticalSplitPane = new JSplitPane(0, editorContainerPane, resultPane);
            verticalSplitPane.setDividerLocation(0.4);
            JSplitPane horizontalSplitPane = new JSplitPane(1, treeContainerPane, verticalSplitPane);
            horizontalSplitPane.setDividerLocation(0.6);
            panel.add((Component)horizontalSplitPane, "Center");
            panel.add((Component)statusField.getComponent(), "South");
            this.contentPane = panel;
        }
        return this.contentPane;
    }

    private String toHtml(String string) {
        if (StringUtilities.isNullOrTrimmedEmpty((String)string)) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<html><body>");
        builder.append(string.replaceAll("\\n", "<br>"));
        builder.append("</html></body>");
        return builder.toString();
    }

    private String createTableSelectStatement(IDatabaseTableName tableName) {
        return tableName.getSchemaName() == null ? String.format("select * from \"%1$s\"", tableName.getTableName()) : String.format("select * from \"%1$s\".\"%2$s\"", tableName.getSchemaName(), tableName.getTableName());
    }

    private void consumeObject(TreePath treePath, IApplicable<Object> applicable, IConsumer<Object, RuntimeException> consumer) {
        if (treePath == null) {
            consumer.consume(null);
            return;
        }
        Object lastPathComponent = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
        if (applicable.isApplicable(lastPathComponent)) {
            consumer.consume(lastPathComponent);
        }
    }

    private void disconnect(Component parentComponent) {
        try {
            boolean isClosed;
            this.statusModel.set((Object)SqlConsoleMessages.working);
            if (!((Connection)this.connectionModel.get()).isClosed()) {
                ((Connection)this.connectionModel.get()).close();
            }
            this.isConnectedModel.set(!(isClosed = ((Connection)this.connectionModel.get()).isClosed()));
            this.isDisconnectedModel.set(isClosed);
            this.statusModel.set((Object)SqlConsoleMessages.done);
        }
        catch (SQLException exception) {
            logger.log(ILevel.DEBUG, "Couldn't close connection", (Throwable)exception);
            this.statusModel.set((Object)exception.getMessage());
        }
    }

    private void connect(Component parentComponent) {
        try {
            this.statusModel.set((Object)SqlConsoleMessages.working);
            if (!((Connection)this.connectionModel.get()).isClosed()) {
                ((Connection)this.connectionModel.get()).close();
            }
            this.connectionModel.set((Object)this.databaseConnector.connectWritable(this.description, true));
            boolean isClosed = ((Connection)this.connectionModel.get()).isClosed();
            this.isConnectedModel.set(!isClosed);
            this.isDisconnectedModel.set(isClosed);
            this.statusModel.set((Object)SqlConsoleMessages.done);
        }
        catch (SQLException exception) {
            logger.log(ILevel.DEBUG, "Couldn't close connection", (Throwable)exception);
            this.statusModel.set((Object)exception.getMessage());
        }
    }

    private void setEditorContent(PlainDocument document, String string) {
        GuiUtilities.invokeLater(() -> {
            try {
                document.replace(0, document.getLength(), string, null);
            }
            catch (BadLocationException exception) {
                logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
            }
        });
    }

    private void insertEditorContent(PlainDocument document, String string, int start, int end) {
        GuiUtilities.invokeLater(() -> {
            try {
                if (start == end) {
                    document.insertString(start, string, null);
                } else {
                    document.replace(start, end - start, string, null);
                }
            }
            catch (BadLocationException exception) {
                logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
            }
        });
    }

    private String getEditorContent(PlainDocument document, int start, int end) {
        try {
            if (start == end) {
                return null;
            }
            return document.getText(start, end - start);
        }
        catch (BadLocationException exception) {
            logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    private String getEditiorContent(PlainDocument document) {
        try {
            return document.getText(0, document.getLength());
        }
        catch (BadLocationException exception) {
            logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
            this.statusModel.set((Object)exception.getMessage());
            return null;
        }
    }

    private String open(Component component, String string) {
        List<FileFilter> filters = Arrays.asList(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return FileUtilities.hasExtension((File)pathname, (String[])new String[]{"sql"});
            }

            @Override
            public String getDescription() {
                return "SQL File (*.sql)";
            }
        });
        IFileChooserResult result = FileChoosers.show((Component)GuiUtilities.getParentWindow((Component)component), (IPreferences)this.preferences.node(new String[]{"filechooser"}), (IOpenFileChooserConfiguration)new OpenFileChooserConfiguration(filters, 0, false));
        if (result.getReturnState() == 0) {
            String string2;
            this.statusModel.set((Object)SqlConsoleMessages.working);
            File file = result.getSelectedFile();
            FileInputStream stream = new FileInputStream(file);
            try {
                String content = IoUtilities.toString((InputStream)stream, (String)Charset.defaultCharset().name());
                this.statusModel.set((Object)SqlConsoleMessages.done);
                string2 = content;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
                    this.statusModel.set((Object)exception.getMessage());
                    return string;
                }
            }
            ((InputStream)stream).close();
            return string2;
        }
        return string;
    }

    private void save(Component component, String string) {
        if (string == null) {
            return;
        }
        List<FileFilter> filters = Arrays.asList(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return FileUtilities.hasExtension((File)pathname, (String[])new String[]{"sql"});
            }

            @Override
            public String getDescription() {
                return "SQL File (*.sql)";
            }
        });
        IFileChooserResult result = FileChoosers.show((Component)GuiUtilities.getParentWindow((Component)component), (IPreferences)this.preferences.node(new String[]{"filechooser"}), (ISaveFileChooserConfiguration)new SaveFileChooserConfiguration(filters, 0, false, false));
        if (result.getReturnState() == 0) {
            this.statusModel.set((Object)SqlConsoleMessages.working);
            File file = result.getSelectedFile();
            try (FileOutputStream stream = new FileOutputStream(file);){
                IoUtilities.pipe((InputStream)new ByteArrayInputStream(string.getBytes(Charset.defaultCharset())), (OutputStream)stream);
                this.statusModel.set((Object)SqlConsoleMessages.done);
            }
            catch (IOException exception) {
                logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
                this.statusModel.set((Object)exception.getMessage());
            }
        }
    }

    private void getMetadataResult(IAggregator<DatabaseMetaData, IDatabaseTableName, ResultSet, SQLException> metadataProvider) {
        try {
            this.statusModel.set((Object)SqlConsoleMessages.working);
            DatabaseMetaData metaData = ((Connection)this.connectionModel.get()).getMetaData();
            IDatabaseTableName tableName = (IDatabaseTableName)this.selectedTable.get();
            ResultSet result = (ResultSet)metadataProvider.aggregate((Object)metaData, (Object)tableName);
            if (result == null) {
                this.statusModel.set((Object)SqlConsoleMessages.noResult);
                return;
            }
            this.resultReseter.reset();
            this.statementModel.set((Object)result.getStatement());
            this.resultSetModel.set((Object)result);
            this.statusModel.set((Object)SqlConsoleMessages.done);
        }
        catch (SQLException exception) {
            logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
            this.statusModel.set((Object)exception.getMessage());
        }
    }

    private void querySequenceMetadata(IDatabaseSequenceName name) {
        try {
            this.statusModel.set((Object)SqlConsoleMessages.working);
            ResultSet result = this.databaseFacade.getSequenceMetadata((Connection)this.connectionModel.get(), name);
            if (result == null) {
                this.statusModel.set((Object)SqlConsoleMessages.noResult);
                return;
            }
            this.resultReseter.reset();
            this.statementModel.set((Object)result.getStatement());
            this.resultSetModel.set((Object)result);
            this.statusModel.set((Object)SqlConsoleMessages.done);
        }
        catch (SQLException exception) {
            logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
            this.statusModel.set((Object)exception.getMessage());
        }
    }

    private void queryTriggerMetadata(IDatabaseTriggerName name) {
        try {
            this.statusModel.set((Object)SqlConsoleMessages.working);
            ResultSet result = this.databaseFacade.getTriggerMetadata((Connection)this.connectionModel.get(), name);
            if (result == null) {
                this.statusModel.set((Object)SqlConsoleMessages.noResult);
                return;
            }
            this.resultReseter.reset();
            this.statementModel.set((Object)result.getStatement());
            this.resultSetModel.set((Object)result);
            this.statusModel.set((Object)SqlConsoleMessages.done);
        }
        catch (SQLException exception) {
            logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
            this.statusModel.set((Object)exception.getMessage());
        }
    }

    private void queryIndexMetadata(IDatabaseIndexName name) {
        try {
            this.statusModel.set((Object)SqlConsoleMessages.working);
            ResultSet result = this.databaseFacade.getIndexMetadata((Connection)this.connectionModel.get(), name);
            if (result == null) {
                this.statusModel.set((Object)SqlConsoleMessages.noResult);
                return;
            }
            this.resultReseter.reset();
            this.statementModel.set((Object)result.getStatement());
            this.resultSetModel.set((Object)result);
            this.statusModel.set((Object)SqlConsoleMessages.done);
        }
        catch (SQLException exception) {
            logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
            this.statusModel.set((Object)exception.getMessage());
        }
    }

    private void queryConstraintMetadata(IDatabaseConstraintName name) {
        try {
            this.statusModel.set((Object)SqlConsoleMessages.working);
            ResultSet result = this.databaseFacade.getConstraintMetadata((Connection)this.connectionModel.get(), name);
            if (result == null) {
                this.statusModel.set((Object)SqlConsoleMessages.noResult);
                return;
            }
            this.resultReseter.reset();
            this.statementModel.set((Object)result.getStatement());
            this.resultSetModel.set((Object)result);
            this.statusModel.set((Object)SqlConsoleMessages.done);
        }
        catch (SQLException exception) {
            logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
            this.statusModel.set((Object)exception.getMessage());
        }
    }

    private String getCatalog() {
        try {
            return ((Connection)this.connectionModel.get()).getCatalog();
        }
        catch (AbstractMethodError | Exception exception) {
            return null;
        }
    }

    private <I> void run(Component component, String title, String text, IBlock<RuntimeException> block) {
        try {
            new ProgressDialogLauncher((progressMonitor, canceler) -> {
                block.execute();
                return null;
            }).setTitle(title).setText(text).setDescription("").launch(component);
        }
        catch (CanceledException canceledException) {
            // empty catch block
        }
    }

    private String getSelectedRowsAsString(ResultSetTableModel tableModel, JTable resultTable) {
        StringBuilder builder = new StringBuilder();
        boolean rowFlag = false;
        boolean columnFlag = false;
        for (int column = 0; column < tableModel.getColumnCount(); ++column) {
            if (columnFlag) {
                builder.append(", ");
            }
            builder.append("'");
            builder.append(tableModel.getColumnName(column));
            builder.append("'");
            columnFlag = true;
        }
        builder.append("\n");
        columnFlag = false;
        for (int row : resultTable.getSelectedRows()) {
            if (rowFlag) {
                builder.append("\n");
            }
            for (int column = 0; column < tableModel.getColumnCount(); ++column) {
                if (columnFlag) {
                    builder.append(", ");
                }
                columnFlag = true;
                Object value = tableModel.getValueAt(row, column);
                if (value == null) {
                    builder.append("null");
                    continue;
                }
                IObjectToStringConverter<Object> toStringConverter = this.dataBaseTableCellValueToStringConverterProvider.get(this.description, tableModel.getColumnTypeName(column));
                if (value instanceof Number) {
                    builder.append(value.toString());
                    continue;
                }
                builder.append("'");
                if (toStringConverter != null) {
                    builder.append(toStringConverter.toString(value));
                } else {
                    builder.append(value.toString());
                }
                builder.append("'");
            }
            rowFlag = true;
            columnFlag = false;
        }
        return builder.toString();
    }
}

