/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.database.swing.console;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import javax.swing.DefaultComboBoxModel;
import net.anwiba.commons.lang.functional.IWatcher;
import net.anwiba.commons.lang.object.ObjectUtilities;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.model.IBooleanModel;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.swing.utilities.GuiUtilities;
import net.anwiba.commons.thread.cancel.ICanceler;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.database.swing.console.SqlConsoleMessages;
import net.anwiba.database.swing.console.result.ResultReseter;

public class StatementExecutor {
    private static ILogger logger = Logging.getLogger(StatementExecutor.class);
    private final IObjectModel<Connection> connectionModel;
    private final IObjectModel<Statement> statementModel;
    private final IObjectModel<ResultSet> resultSetModel;
    private final IObjectModel<String> statusModel;
    private final DefaultComboBoxModel<String> historyComboBoxModel;
    private final IBooleanModel isDisconnectedModel;
    private final IBooleanModel isConnectedModel;
    private final ResultReseter resultReseter;

    public StatementExecutor(IObjectModel<Connection> connectionModel, ResultReseter resultReseter, IObjectModel<Statement> statementModel, IObjectModel<ResultSet> resultSetModel, IObjectModel<String> statusModel, DefaultComboBoxModel<String> historyComboBoxModel, IBooleanModel isDisconnectedModel, IBooleanModel isConnectedModel) {
        this.connectionModel = connectionModel;
        this.resultReseter = resultReseter;
        this.statementModel = statementModel;
        this.resultSetModel = resultSetModel;
        this.statusModel = statusModel;
        this.historyComboBoxModel = historyComboBoxModel;
        this.isDisconnectedModel = isDisconnectedModel;
        this.isConnectedModel = isConnectedModel;
    }

    public void executeStatement(ICanceler canceler, String string) {
        try {
            this.statusModel.set((Object)SqlConsoleMessages.working);
            if (StringUtilities.isNullOrTrimmedEmpty((String)string)) {
                this.statusModel.set((Object)SqlConsoleMessages.done);
                return;
            }
            logger.log(ILevel.DEBUG, SqlConsoleMessages.executeStatement + string);
            boolean isClosed = ((Connection)this.connectionModel.get()).isClosed();
            if (isClosed) {
                this.isConnectedModel.set(!isClosed);
                this.isDisconnectedModel.set(isClosed);
                this.statusModel.set((Object)SqlConsoleMessages.connectionIsClosed);
                return;
            }
            Statement statement = this.createStatement();
            try (IWatcher watcher = (IWatcher)canceler.watcherFactory().create(() -> {
                try {
                    statement.cancel();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            });){
                if (!statement.execute(this.clean(string))) {
                    this.updateHistoryComboBoyModel(string);
                    this.statusModel.set((Object)SqlConsoleMessages.done);
                    statement.close();
                    return;
                }
            }
            this.resultReseter.reset();
            this.statementModel.set((Object)statement);
            ResultSet resultSet = statement.getResultSet();
            this.resultSetModel.set((Object)resultSet);
            this.updateHistoryComboBoyModel(string);
            this.statusModel.set((Object)SqlConsoleMessages.done);
        }
        catch (SQLException exception) {
            logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
            this.statusModel.set((Object)exception.getMessage());
        }
    }

    private void updateHistoryComboBoyModel(String string) {
        for (int i = this.historyComboBoxModel.getSize() - 1; i > -1; --i) {
            if (!ObjectUtilities.equals((Object)this.historyComboBoxModel.getElementAt(i), (Object)string)) continue;
            return;
        }
        GuiUtilities.invokeLater(() -> {
            if (this.historyComboBoxModel.getSize() > 30) {
                this.historyComboBoxModel.removeElementAt(0);
            }
            this.historyComboBoxModel.addElement(string);
        });
    }

    private String clean(String string) {
        return Optional.ofNullable(string).map(s -> s.trim()).map(t -> t.endsWith(";") ? t.substring(0, t.length() - 1) : t).orElse(string);
    }

    private Statement createStatement() throws SQLException {
        if (((Connection)this.connectionModel.get()).getMetaData().supportsResultSetConcurrency(1004, 1007)) {
            return ((Connection)this.connectionModel.get()).createStatement(1004, 1007);
        }
        if (((Connection)this.connectionModel.get()).getMetaData().supportsResultSetConcurrency(1005, 1007)) {
            return ((Connection)this.connectionModel.get()).createStatement(1005, 1007);
        }
        return ((Connection)this.connectionModel.get()).createStatement();
    }
}

