/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.database.swing.console.tree;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import net.anwiba.commons.jdbc.connection.IJdbcConnectionDescription;
import net.anwiba.commons.jdbc.database.IDatabaseFacade;
import net.anwiba.commons.jdbc.database.INamedTableFilter;
import net.anwiba.commons.jdbc.name.DatabaseTableName;
import net.anwiba.commons.jdbc.name.IDatabaseConstraintName;
import net.anwiba.commons.jdbc.name.IDatabaseIndexName;
import net.anwiba.commons.jdbc.name.IDatabaseSequenceName;
import net.anwiba.commons.jdbc.name.IDatabaseTableName;
import net.anwiba.commons.jdbc.name.IDatabaseTriggerName;
import net.anwiba.commons.lang.functional.IFactory;
import net.anwiba.commons.lang.functional.IWatcher;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.model.IBooleanModel;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.swing.tree.LazyFolderTreeNode;
import net.anwiba.commons.thread.cancel.ICanceler;
import net.anwiba.database.swing.console.SqlConsoleMessages;

public final class SchemaTreeFactory {
    private static ILogger logger = Logging.getLogger(SchemaTreeFactory.class);
    private final IDatabaseFacade databaseFacade;
    private final IObjectModel<Connection> connectionModel;
    private final IObjectModel<String> statusModel;
    private final IBooleanModel isDisconnectedModel;
    private final IBooleanModel isConnectedModel;

    public SchemaTreeFactory(IDatabaseFacade databaseFacade, IObjectModel<Connection> connectionModel, IObjectModel<String> statusModel, IBooleanModel isDisconnectedModel, IBooleanModel isConnectedModel) {
        this.databaseFacade = databaseFacade;
        this.connectionModel = connectionModel;
        this.statusModel = statusModel;
        this.isDisconnectedModel = isDisconnectedModel;
        this.isConnectedModel = isConnectedModel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DefaultMutableTreeNode create(ICanceler canceler, IJdbcConnectionDescription description, String schema) {
        this.statusModel.set((Object)SqlConsoleMessages.working);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(description.getUrl());
        try {
            Connection connection = (Connection)this.connectionModel.get();
            boolean isClosed = connection.isClosed();
            if (isClosed) {
                this.isConnectedModel.set(!isClosed);
                this.isDisconnectedModel.set(isClosed);
                this.statusModel.set((Object)SqlConsoleMessages.connectionIsClosed);
                return root;
            }
            String catalog = this.getCatalog();
            HashSet schemaNames = new HashSet(this.databaseFacade.getSchemaNames(connection, catalog));
            DatabaseMetaData metaData = connection.getMetaData();
            LinkedHashMap<String, DefaultMutableTreeNode> schemas = new LinkedHashMap<String, DefaultMutableTreeNode>();
            if (schema != null) {
                this.addSchema(connection, metaData, root, catalog, schema, schemas);
            } else {
                if (canceler.isCanceled()) {
                    return null;
                }
                try (ResultSet resultSet = metaData.getSchemas();
                     IWatcher watcher = (IWatcher)canceler.watcherFactory().create(() -> {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                });){
                    while (resultSet.next()) {
                        if (canceler.isCanceled()) {
                            DefaultMutableTreeNode defaultMutableTreeNode = null;
                            return defaultMutableTreeNode;
                        }
                        String schemaName = resultSet.getString(1);
                        if (!schemaNames.contains(schemaName)) continue;
                        this.addSchema(connection, metaData, root, catalog, schemaName, schemas);
                    }
                }
            }
            if (schemas.isEmpty()) {
                this.addSchema(connection, metaData, root, catalog, schema, schemas);
            }
            this.statusModel.set((Object)SqlConsoleMessages.done);
            return root;
        }
        catch (SQLException exception) {
            logger.debug(exception.getMessage(), (Throwable)exception);
            this.statusModel.set((Object)exception.getMessage());
            return root;
        }
    }

    private void addSchema(Connection connection, DatabaseMetaData metaData, DefaultMutableTreeNode root, String catalog, String schemaName, Map<String, DefaultMutableTreeNode> schemas) {
        DefaultMutableTreeNode schemaNode = schemaName == null ? root : new DefaultMutableTreeNode(schemaName);
        schemaNode.add((MutableTreeNode)this.createTablesNode(connection, metaData, catalog, schemaName));
        schemaNode.add((MutableTreeNode)this.createViewsNode(metaData, catalog, schemaName));
        if (this.databaseFacade.supportsSequences()) {
            schemaNode.add((MutableTreeNode)this.createSequencesNode(connection, schemaName));
        }
        for (INamedTableFilter filter : this.databaseFacade.getTableFilters()) {
            schemaNode.add((MutableTreeNode)this.createOtherNodes(connection, metaData, catalog, schemaName, filter));
        }
        if (schemaName != null) {
            root.add(schemaNode);
        }
        schemas.put(schemaName, schemaNode);
    }

    private LazyFolderTreeNode<String> createSequencesNode(final Connection connection, final String schemaName) {
        return new LazyFolderTreeNode((IFactory)new IFactory<String, List<DefaultMutableTreeNode>, RuntimeException>(){

            public List<DefaultMutableTreeNode> create(String value) throws RuntimeException {
                try {
                    List sequences = SchemaTreeFactory.this.databaseFacade.getSequences(connection, schemaName);
                    ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
                    for (IDatabaseSequenceName sequence : sequences) {
                        nodes.add(new DefaultMutableTreeNode(sequence));
                    }
                    return nodes;
                }
                catch (Exception exception) {
                    logger.debug(exception.getMessage(), (Throwable)exception);
                    return Collections.emptyList();
                }
            }
        }, (Object)SqlConsoleMessages.sequences);
    }

    private LazyFolderTreeNode<String> createViewsNode(final DatabaseMetaData metaData, final String catalog, final String schemaName) {
        return new LazyFolderTreeNode((IFactory)new IFactory<String, List<DefaultMutableTreeNode>, RuntimeException>(){

            public List<DefaultMutableTreeNode> create(String value) throws RuntimeException {
                ArrayList<DefaultMutableTreeNode> arrayList;
                block9: {
                    ResultSet tablesResultSet = metaData.getTables(catalog, schemaName, null, new String[]{"VIEW"});
                    try {
                        ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
                        while (tablesResultSet.next()) {
                            String schema = tablesResultSet.getString(2);
                            String name = tablesResultSet.getString(3);
                            DatabaseTableName table = new DatabaseTableName(schema, name);
                            nodes.add(new DefaultMutableTreeNode(table));
                        }
                        arrayList = nodes;
                        if (tablesResultSet == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (tablesResultSet != null) {
                                try {
                                    tablesResultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception exception) {
                            logger.debug(exception.getMessage(), (Throwable)exception);
                            return Collections.emptyList();
                        }
                    }
                    tablesResultSet.close();
                }
                return arrayList;
            }
        }, (Object)SqlConsoleMessages.views);
    }

    private LazyFolderTreeNode<String> createTablesNode(final Connection connection, final DatabaseMetaData metaData, final String catalog, final String schemaName) {
        return new LazyFolderTreeNode((IFactory)new IFactory<String, List<DefaultMutableTreeNode>, RuntimeException>(){

            public List<DefaultMutableTreeNode> create(String value) throws RuntimeException {
                List<IDatabaseTableName> tableNames = this.getTableNames(connection, catalog, schemaName);
                ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
                for (IDatabaseTableName table : tableNames) {
                    if (!SchemaTreeFactory.this.databaseFacade.isTable(table)) continue;
                    DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode(table);
                    if (SchemaTreeFactory.this.databaseFacade.supportsConstaints()) {
                        tableNode.add(SchemaTreeFactory.this.createConstraintsNode(connection, table));
                    }
                    if (SchemaTreeFactory.this.databaseFacade.supportsIndicies()) {
                        tableNode.add(SchemaTreeFactory.this.createIndiciesNode(connection, table));
                    }
                    if (SchemaTreeFactory.this.databaseFacade.supportsTrigger()) {
                        tableNode.add(SchemaTreeFactory.this.createTriggersNode(connection, table));
                    }
                    nodes.add(tableNode);
                }
                return nodes;
            }

            private List<IDatabaseTableName> getTableNames(Connection connection2, String catalog2, String schemaName2) {
                ArrayList<IDatabaseTableName> arrayList;
                block12: {
                    try {
                        if (SchemaTreeFactory.this.databaseFacade.supportsTables()) {
                            return SchemaTreeFactory.this.databaseFacade.getTables(connection2, schemaName2);
                        }
                    }
                    catch (SQLException exception) {
                        exception.printStackTrace();
                    }
                    ResultSet tablesResultSet = metaData.getTables(catalog2, schemaName2, null, new String[]{"TABLE"});
                    try {
                        ArrayList<IDatabaseTableName> names = new ArrayList<IDatabaseTableName>();
                        ArrayList nodes = new ArrayList();
                        while (tablesResultSet.next()) {
                            String schema = tablesResultSet.getString(2);
                            String name = tablesResultSet.getString(3);
                            names.add((IDatabaseTableName)new DatabaseTableName(schema, name));
                        }
                        arrayList = names;
                        if (tablesResultSet == null) break block12;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (tablesResultSet != null) {
                                try {
                                    tablesResultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException exception) {
                            logger.debug(exception.getMessage(), (Throwable)exception);
                            return List.of();
                        }
                    }
                    tablesResultSet.close();
                }
                return arrayList;
            }
        }, (Object)SqlConsoleMessages.tables);
    }

    private LazyFolderTreeNode<String> createOtherNodes(final Connection connection, final DatabaseMetaData metaData, final String catalog, final String schemaName, final INamedTableFilter filter) {
        return new LazyFolderTreeNode((IFactory)new IFactory<String, List<DefaultMutableTreeNode>, RuntimeException>(){

            public List<DefaultMutableTreeNode> create(String value) throws RuntimeException {
                ArrayList<DefaultMutableTreeNode> arrayList;
                block12: {
                    ResultSet tablesResultSet = metaData.getTables(catalog, schemaName, null, new String[]{"TABLE"});
                    try {
                        ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
                        while (tablesResultSet.next()) {
                            String name;
                            String schema = tablesResultSet.getString(2);
                            DatabaseTableName table = new DatabaseTableName(schema, name = tablesResultSet.getString(3));
                            if (!filter.accept((IDatabaseTableName)table)) continue;
                            DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode(table);
                            if (SchemaTreeFactory.this.databaseFacade.supportsConstaints()) {
                                tableNode.add(SchemaTreeFactory.this.createConstraintsNode(connection, (IDatabaseTableName)table));
                            }
                            if (SchemaTreeFactory.this.databaseFacade.supportsIndicies()) {
                                tableNode.add(SchemaTreeFactory.this.createIndiciesNode(connection, (IDatabaseTableName)table));
                            }
                            if (SchemaTreeFactory.this.databaseFacade.supportsTrigger()) {
                                tableNode.add(SchemaTreeFactory.this.createTriggersNode(connection, (IDatabaseTableName)table));
                            }
                            nodes.add(tableNode);
                        }
                        arrayList = nodes;
                        if (tablesResultSet == null) break block12;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (tablesResultSet != null) {
                                try {
                                    tablesResultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception exception) {
                            logger.debug(exception.getMessage(), (Throwable)exception);
                            return Collections.emptyList();
                        }
                    }
                    tablesResultSet.close();
                }
                return arrayList;
            }
        }, (Object)filter.getName());
    }

    private MutableTreeNode createIndiciesNode(final Connection connection, final IDatabaseTableName table) {
        return new LazyFolderTreeNode((IFactory)new IFactory<String, List<DefaultMutableTreeNode>, RuntimeException>(){

            public List<DefaultMutableTreeNode> create(String value) throws RuntimeException {
                try {
                    List names = SchemaTreeFactory.this.databaseFacade.getIndicies(connection, table);
                    ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
                    for (IDatabaseIndexName name : names) {
                        nodes.add(new DefaultMutableTreeNode(name));
                    }
                    return nodes;
                }
                catch (Exception exception) {
                    logger.debug(exception.getMessage(), (Throwable)exception);
                    return Collections.emptyList();
                }
            }
        }, (Object)SqlConsoleMessages.indicies);
    }

    private MutableTreeNode createTriggersNode(final Connection connection, final IDatabaseTableName table) {
        return new LazyFolderTreeNode((IFactory)new IFactory<String, List<DefaultMutableTreeNode>, RuntimeException>(){

            public List<DefaultMutableTreeNode> create(String value) throws RuntimeException {
                try {
                    List names = SchemaTreeFactory.this.databaseFacade.getTriggers(connection, table);
                    ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
                    for (IDatabaseTriggerName name : names) {
                        nodes.add(new DefaultMutableTreeNode(name));
                    }
                    return nodes;
                }
                catch (Exception exception) {
                    logger.debug(exception.getMessage(), (Throwable)exception);
                    return Collections.emptyList();
                }
            }
        }, (Object)SqlConsoleMessages.triggers);
    }

    private MutableTreeNode createConstraintsNode(final Connection connection, final IDatabaseTableName tableName) {
        return new LazyFolderTreeNode((IFactory)new IFactory<String, List<DefaultMutableTreeNode>, RuntimeException>(){

            public List<DefaultMutableTreeNode> create(String value) throws RuntimeException {
                try {
                    List names = SchemaTreeFactory.this.databaseFacade.getConstraints(connection, tableName);
                    ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
                    for (IDatabaseConstraintName name : names) {
                        nodes.add(new DefaultMutableTreeNode(name));
                    }
                    return nodes;
                }
                catch (Exception exception) {
                    logger.debug(exception.getMessage(), (Throwable)exception);
                    return Collections.emptyList();
                }
            }
        }, (Object)SqlConsoleMessages.constraints);
    }

    private String getCatalog() {
        try {
            return ((Connection)this.connectionModel.get()).getCatalog();
        }
        catch (AbstractMethodError | Exception exception) {
            logger.debug(exception.getMessage(), exception);
            return null;
        }
    }
}

