/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.database.swing.console;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import net.anwiba.commons.jdbc.connection.IDatabaseConnector;
import net.anwiba.commons.jdbc.connection.IJdbcConnectionDescription;
import net.anwiba.commons.jdbc.database.IDatabaseFacade;
import net.anwiba.commons.jdbc.metadata.Property;
import net.anwiba.commons.jdbc.name.IDatabaseColumnName;
import net.anwiba.commons.jdbc.name.IDatabaseConstraintName;
import net.anwiba.commons.jdbc.name.IDatabaseIndexName;
import net.anwiba.commons.jdbc.name.IDatabaseSchemaName;
import net.anwiba.commons.jdbc.name.IDatabaseSequenceName;
import net.anwiba.commons.jdbc.name.IDatabaseTableName;
import net.anwiba.commons.jdbc.name.IDatabaseTriggerName;
import net.anwiba.commons.lang.exception.CanceledException;
import net.anwiba.commons.lang.exception.UnreachableCodeReachedException;
import net.anwiba.commons.lang.functional.IAggregator;
import net.anwiba.commons.lang.functional.IApplicable;
import net.anwiba.commons.lang.functional.IBiConsumer;
import net.anwiba.commons.lang.functional.IFunction;
import net.anwiba.commons.lang.object.IObjectToStringConverter;
import net.anwiba.commons.lang.object.ObjectUtilities;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.lang.registry.HierarchicalClassKeyRegistry;
import net.anwiba.commons.lang.stream.Streams;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.model.AndAggregatedBooleanDistributor;
import net.anwiba.commons.model.BooleanModel;
import net.anwiba.commons.model.IBooleanDistributor;
import net.anwiba.commons.model.IBooleanModel;
import net.anwiba.commons.model.IChangeableListListener;
import net.anwiba.commons.model.IObjectListModel;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ObjectListModel;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.model.OrAggregatedBooleanDistributor;
import net.anwiba.commons.preferences.IPreferences;
import net.anwiba.commons.preferences.StringListPreference;
import net.anwiba.commons.reference.utilities.FileUtilities;
import net.anwiba.commons.reference.utilities.IoUtilities;
import net.anwiba.commons.swing.action.ActionProcedurBuilder;
import net.anwiba.commons.swing.action.ConfigurableActionBuilder;
import net.anwiba.commons.swing.dialog.DataState;
import net.anwiba.commons.swing.dialog.pane.AbstractContentPane;
import net.anwiba.commons.swing.dialog.progress.ProgressDialogLauncher;
import net.anwiba.commons.swing.filechooser.FileChoosers;
import net.anwiba.commons.swing.filechooser.IFileChooserResult;
import net.anwiba.commons.swing.filechooser.IOpenFileChooserConfiguration;
import net.anwiba.commons.swing.filechooser.ISaveFileChooserConfiguration;
import net.anwiba.commons.swing.filechooser.OpenFileChooserConfiguration;
import net.anwiba.commons.swing.filechooser.SaveFileChooserConfiguration;
import net.anwiba.commons.swing.icon.IGuiIcon;
import net.anwiba.commons.swing.icons.GuiIcons;
import net.anwiba.commons.swing.icons.gnome.contrast.high.ContrastHightIcons;
import net.anwiba.commons.swing.object.IObjectField;
import net.anwiba.commons.swing.object.StringFieldBuilder;
import net.anwiba.commons.swing.table.ObjectTable;
import net.anwiba.commons.swing.table.ObjectTableBuilder;
import net.anwiba.commons.swing.table.Table;
import net.anwiba.commons.swing.table.WrappedTableModel;
import net.anwiba.commons.swing.table.renderer.ObjectTableCellRenderer;
import net.anwiba.commons.swing.tree.FilteredDefaultTreeModel;
import net.anwiba.commons.swing.tree.ReloadableFolderTreeNode;
import net.anwiba.commons.swing.ui.ObjectUiBuilder;
import net.anwiba.commons.swing.ui.ObjectUiListCellRenderer;
import net.anwiba.commons.swing.utilities.GuiUtilities;
import net.anwiba.commons.swing.utilities.TableUtilities;
import net.anwiba.commons.thread.cancel.ICanceler;
import net.anwiba.commons.thread.process.IProcessManager;
import net.anwiba.commons.thread.process.ProcessBuilder;
import net.anwiba.commons.thread.progress.IProgressTask;
import net.anwiba.commons.utilities.property.IProperties;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.database.swing.console.PlainTextEditorPaneTransferHandler;
import net.anwiba.database.swing.console.SqlConsoleMessages;
import net.anwiba.database.swing.console.StatementExecutor;
import net.anwiba.database.swing.console.converter.IDataBaseTableCellValueToStringConverterProvider;
import net.anwiba.database.swing.console.result.DataBaseTableCellValueRenderFactory;
import net.anwiba.database.swing.console.result.PropertyTableModel;
import net.anwiba.database.swing.console.result.ResultReseter;
import net.anwiba.database.swing.console.result.ResultSetTableModel;
import net.anwiba.database.swing.console.tree.DatabaseNamesTreeRenderer;
import net.anwiba.database.swing.console.tree.SchemaTreeFactory;

public final class SqlConsoleContentPane
extends AbstractContentPane {
    static ILogger logger = Logging.getLogger(SqlConsoleContentPane.class);
    private static final Clipboard CLIPBOARD = Toolkit.getDefaultToolkit().getSystemClipboard();
    private final IJdbcConnectionDescription description;
    private final IObjectModel<Connection> connectionModel;
    private final IBooleanModel isDisconnectedModel;
    private final IBooleanModel isConnectedModel;
    private final IDatabaseConnector databaseConnector;
    private final IPreferences preferences;
    private final IBooleanDistributor createStatementActionsEnabledDistributor;
    private final IBooleanDistributor propertiesActionsEnabledDistributor;
    private final IBooleanDistributor tableActionsEnabledDistributor;
    private final IBooleanDistributor textActionsEnabledDistributor;
    private final StatementExecutor statementExecutor;
    private final ResultReseter resultReseter;
    private final IObjectModel<Statement> statementModel = new ObjectModel();
    private final IObjectListModel<String> statementValuesModel = new ObjectListModel();
    private final IObjectModel<ResultSet> resultSetModel = new ObjectModel();
    private final IObjectModel<IDatabaseTableName> selectedTable = new ObjectModel();
    private final IObjectModel<IDatabaseColumnName> selectedColumn = new ObjectModel();
    private final IObjectModel<IDatabaseSequenceName> selectedSequence = new ObjectModel();
    private final IObjectModel<IDatabaseTriggerName> selectedTrigger = new ObjectModel();
    private final IObjectModel<IDatabaseIndexName> selectedIndex = new ObjectModel();
    private final IObjectModel<IDatabaseConstraintName> selectedConstraint = new ObjectModel();
    private final IBooleanModel isConnectionDescriptionSelectedModel = new BooleanModel(false);
    private final IBooleanModel isTextAvailableModel = new BooleanModel(false);
    private final IBooleanModel isTableSelectedModel = new BooleanModel(false);
    private final IBooleanModel isColumnsSelectedModel = new BooleanModel(false);
    private final IBooleanModel isSequenceSelectedModel = new BooleanModel(false);
    private final IBooleanModel isTriggerSelectedModel = new BooleanModel(false);
    private final IBooleanModel isIndexSelectedModel = new BooleanModel(false);
    private final IBooleanModel isConstraintSelectedModel = new BooleanModel(false);
    private final IObjectModel<String> statusModel = new ObjectModel();
    private final DefaultComboBoxModel<String> historyComboBoxModel = new DefaultComboBoxModel();
    private JPanel contentPane;
    private final IDataBaseTableCellValueToStringConverterProvider dataBaseTableCellValueToStringConverterProvider;
    private final DataBaseTableCellValueRenderFactory dataBaseTableCellValueRenderFactory;
    private final IDatabaseFacade databaseFacade;
    private final SchemaTreeFactory schemaTreeFactory;
    private final String schema;
    private final ResultSetTableModel resultSetTableModel = new ResultSetTableModel(this.statusModel, this.resultSetModel);
    private final WrappedTableModel resultDataTableModel = new WrappedTableModel((TableModel)this.resultSetTableModel);
    private final WrappedTableModel resultMetaDataTableModel = new WrappedTableModel(this.resultSetTableModel.getResultSetMetaDataTableModel());

    public SqlConsoleContentPane(IObjectModel<DataState> dataStateModel, IPreferences preferences, IProcessManager processManager, IDatabaseConnector databaseConnector, IDatabaseFacade databaseFacade, IJdbcConnectionDescription description, String schema, IDataBaseTableCellValueToStringConverterProvider dataBaseTableCellValueToStringConverterProvider, IObjectModel<Connection> connectionModel, IBooleanModel isDisconnectedModel, IBooleanModel isConnectedModel) {
        super(dataStateModel);
        this.databaseFacade = databaseFacade;
        this.schema = schema;
        this.dataBaseTableCellValueRenderFactory = new DataBaseTableCellValueRenderFactory(dataBaseTableCellValueToStringConverterProvider);
        this.historyComboBoxModel.addElement(null);
        StringListPreference statementListPreference = new StringListPreference(preferences.node(new String[]{description.getProtocol()}).node(new String[]{"statements"}));
        statementListPreference.get().stream().forEach(v -> this.historyComboBoxModel.addElement((String)v));
        this.historyComboBoxModel.setSelectedItem(null);
        this.historyComboBoxModel.addListDataListener(this.createStatementHistoryPreferenceSynchroniceListener(processManager, statementListPreference));
        this.databaseConnector = databaseConnector;
        this.preferences = preferences;
        this.description = description;
        this.dataBaseTableCellValueToStringConverterProvider = dataBaseTableCellValueToStringConverterProvider;
        this.connectionModel = connectionModel;
        this.isDisconnectedModel = isDisconnectedModel;
        this.isConnectedModel = isConnectedModel;
        this.tableActionsEnabledDistributor = new AndAggregatedBooleanDistributor(Arrays.asList(isConnectedModel, this.isTableSelectedModel));
        this.textActionsEnabledDistributor = new AndAggregatedBooleanDistributor(Arrays.asList(isConnectedModel, this.isTextAvailableModel));
        this.propertiesActionsEnabledDistributor = new AndAggregatedBooleanDistributor(Arrays.asList(isConnectedModel, new OrAggregatedBooleanDistributor(Arrays.asList(this.isConnectionDescriptionSelectedModel, this.isTableSelectedModel, this.isColumnsSelectedModel, this.isSequenceSelectedModel, this.isIndexSelectedModel, this.isConstraintSelectedModel, this.isTriggerSelectedModel))));
        this.createStatementActionsEnabledDistributor = new AndAggregatedBooleanDistributor(Arrays.asList(isConnectedModel, new OrAggregatedBooleanDistributor(Arrays.asList(this.isTriggerSelectedModel, new AndAggregatedBooleanDistributor(Arrays.asList(this.isTableSelectedModel, new BooleanModel(databaseFacade.supportsTableStatement())))))));
        this.resultReseter = new ResultReseter(this.statementModel, this.resultSetModel);
        this.schemaTreeFactory = new SchemaTreeFactory(new InternalDatabaseConnector(connectionModel, databaseConnector, description), databaseFacade, this.statusModel);
        this.statementExecutor = new StatementExecutor(connectionModel, this.resultReseter, this.statementModel, this.statementValuesModel, this.resultSetModel, this.statusModel, statement -> {
            for (int i = this.historyComboBoxModel.getSize() - 1; i > -1; --i) {
                if (!ObjectUtilities.equals((Object)this.historyComboBoxModel.getElementAt(i), (Object)statement)) continue;
                this.historyComboBoxModel.setSelectedItem(statement);
                return;
            }
            GuiUtilities.invokeLater(() -> {
                this.historyComboBoxModel.setSelectedItem(null);
                if (this.historyComboBoxModel.getSize() > 30) {
                    this.historyComboBoxModel.removeElementAt(0);
                }
                this.historyComboBoxModel.addElement((String)statement);
                this.historyComboBoxModel.setSelectedItem(statement);
            });
        }, isDisconnectedModel, isConnectedModel);
        this.resultSetModel.addChangeListener(() -> this.resultDataTableModel.wrap((TableModel)this.resultSetTableModel));
    }

    public JComponent getComponent() {
        if (this.contentPane == null) {
            JEditorPane editorPane = new JEditorPane("text/plain", "");
            Font font = editorPane.getFont();
            editorPane.setFont(new Font("Monospaced", 0, font.getSize()));
            PlainDocument document = (PlainDocument)editorPane.getDocument();
            editorPane.setTransferHandler(new PlainTextEditorPaneTransferHandler(document, editorPane));
            editorPane.addKeyListener(this.createStatementEditorShortCutListener(editorPane, document));
            DefaultMutableTreeNode root = this.createSchemaTree();
            FilteredDefaultTreeModel schemaTreeModel = new FilteredDefaultTreeModel((TreeNode)root);
            JTree schemaTreePane = new JTree((TreeModel)schemaTreeModel);
            schemaTreePane.setDragEnabled(true);
            Optional.of((Object)this.createTransferableHandler()).consume(h -> schemaTreePane.setTransferHandler((TransferHandler)h));
            schemaTreePane.setCellRenderer(new DatabaseNamesTreeRenderer());
            schemaTreePane.addTreeWillExpandListener(this.createTreeNodeExpandeListener(schemaTreeModel));
            schemaTreePane.addMouseListener(this.createDoubleClickSchemaTreeListener(schemaTreePane));
            TreeSelectionModel schemaTreeSelectionModel = schemaTreePane.getSelectionModel();
            schemaTreeSelectionModel.addTreeSelectionListener(this.createTreeNodeSelectionListener());
            JToolBar treeToolBar = new JToolBar();
            treeToolBar.setFloatable(false);
            treeToolBar.add(this.createReconnectAction());
            treeToolBar.add(this.createDisconnectAction());
            treeToolBar.add(this.createReloadSchemaAction(schemaTreeModel));
            treeToolBar.add(this.createShowPropertiesAction());
            treeToolBar.add(this.createShowCapabilitiesAction());
            treeToolBar.add(this.createShowTypesAction());
            treeToolBar.add(this.createShowTablePrivilegsAction());
            treeToolBar.add(this.createShwoColumnPrivilegesAction());
            treeToolBar.add(this.createShowTableContentAction());
            treeToolBar.add(this.createCreateStatementAction(document));
            JComboBox<String> historyComboBox = new JComboBox<String>(this.historyComboBoxModel);
            historyComboBox.setRenderer((ListCellRenderer<String>)new ObjectUiListCellRenderer(new ObjectUiBuilder().tooltip(t -> this.toHtml((String)t)).build()));
            historyComboBox.addActionListener(e -> {
                if (this.historyComboBoxModel.getSelectedItem() != null) {
                    this.setEditorContent(document, (String)this.historyComboBoxModel.getSelectedItem());
                }
            });
            document.addDocumentListener(this.createStatementHistoryComboBoxSynchroniceListener(document, historyComboBox));
            JToolBar editorToolBar = new JToolBar();
            editorToolBar.setFloatable(false);
            editorToolBar.add(this.createOpenSqlStatementFromFileAction(document));
            editorToolBar.add(this.createSaveSqlStatementToFileAction(document));
            editorToolBar.add(this.createExecuteSqlStatementAction(document));
            JScrollPane editorScrollPane = new JScrollPane(editorPane);
            editorScrollPane.setMinimumSize(new Dimension(400, 300));
            JPanel editorHeadPane = new JPanel(new BorderLayout());
            editorHeadPane.add((Component)editorToolBar, "North");
            editorHeadPane.add(historyComboBox, "Center");
            JPanel editorContainerPane = new JPanel(new BorderLayout());
            editorContainerPane.setMinimumSize(new Dimension(400, 320));
            editorContainerPane.setPreferredSize(new Dimension(400, 320));
            editorContainerPane.add((Component)editorHeadPane, "North");
            editorContainerPane.add((Component)editorScrollPane, "Center");
            DragSource source = DragSource.getDefaultDragSource();
            Table resultTable = new Table((TableModel)this.resultDataTableModel, s -> StringUtilities.reduce((String)s, (int)8, (int)120));
            resultTable.addKeyListener(this.createResultTableShortCutListener(this.resultDataTableModel, (JTable)resultTable));
            resultTable.getColumnModel().addColumnModelListener(this.createTableColumnAdjustmentListener(this.resultDataTableModel));
            resultTable.setAutoResizeMode(0);
            source.createDefaultDragGestureRecognizer((Component)resultTable, 1, this.createResultTableGestureListener(this.resultDataTableModel, (JTable)resultTable));
            JScrollPane resultTableScrollPane = new JScrollPane((Component)resultTable);
            resultTableScrollPane.setVerticalScrollBarPolicy(20);
            resultTableScrollPane.setHorizontalScrollBarPolicy(30);
            JPanel resultPane = new JPanel(new GridLayout(1, 1, 2, 2));
            resultPane.add(resultTableScrollPane);
            Table resultMetaDataTable = new Table((TableModel)this.resultMetaDataTableModel, s -> StringUtilities.reduce((String)s, (int)8, (int)120));
            resultMetaDataTable.addKeyListener(this.createResultTableShortCutListener(this.resultMetaDataTableModel, (JTable)resultTable));
            resultMetaDataTable.getColumnModel().addColumnModelListener(this.createTableColumnAdjustmentListener(this.resultMetaDataTableModel));
            resultMetaDataTable.setAutoResizeMode(0);
            source.createDefaultDragGestureRecognizer((Component)resultMetaDataTable, 1, this.createResultTableGestureListener(this.resultMetaDataTableModel, (JTable)resultMetaDataTable));
            JScrollPane resultMetaDataScrollPane = new JScrollPane((Component)resultMetaDataTable);
            resultMetaDataScrollPane.setVerticalScrollBarPolicy(20);
            resultMetaDataScrollPane.setHorizontalScrollBarPolicy(30);
            JPanel resultMetaDataPane = new JPanel(new GridLayout(1, 1, 2, 2));
            resultMetaDataPane.add(resultMetaDataScrollPane);
            JPanel panel = new JPanel(new BorderLayout(2, 2));
            IObjectField statusField = ((StringFieldBuilder)((StringFieldBuilder)((StringFieldBuilder)new StringFieldBuilder().setEditable(false)).setBackgroundColor(panel.getBackground())).setModel(this.statusModel)).build();
            JScrollPane treeScrollPane = new JScrollPane(schemaTreePane);
            treeScrollPane.setMinimumSize(new Dimension(220, 300));
            JPanel treeHeadComponent = new JPanel(new BorderLayout());
            treeHeadComponent.add((Component)treeToolBar, "North");
            JPanel treeContainerPane = new JPanel(new BorderLayout());
            treeContainerPane.setMinimumSize(new Dimension(240, 380));
            treeContainerPane.add((Component)treeHeadComponent, "North");
            treeContainerPane.add((Component)treeScrollPane, "Center");
            JTabbedPane resultTabbedPane = new JTabbedPane();
            resultTabbedPane.add("data", resultPane);
            resultTabbedPane.add("metadata", resultMetaDataPane);
            ObjectTable<String> preparedStatementValueTable = this.createPreparedStatementValueTable();
            JComponent preparedStatementValueTableComponent = preparedStatementValueTable.getComponent();
            preparedStatementValueTable.getTableModel().addListModelListener((IChangeableListListener)new IChangeableListListener<String>(){

                public void objectsChanged(Iterable<String> objects) {
                    SqlConsoleContentPane.this.statementValuesModel.set(objects);
                }
            });
            JSplitPane editorSplitPane = new JSplitPane(1, editorContainerPane, preparedStatementValueTableComponent);
            editorSplitPane.setDividerLocation(0.7);
            editorSplitPane.setResizeWeight(0.7);
            JSplitPane verticalSplitPane = new JSplitPane(0, editorSplitPane, resultTabbedPane);
            verticalSplitPane.setDividerLocation(0.6);
            verticalSplitPane.setResizeWeight(0.6);
            JSplitPane horizontalSplitPane = new JSplitPane(1, treeContainerPane, verticalSplitPane);
            horizontalSplitPane.setDividerLocation(284);
            panel.add((Component)horizontalSplitPane, "Center");
            panel.add((Component)statusField.getComponent(), "South");
            this.contentPane = panel;
            this.queryDataBaseProperties(ICanceler.DummyCanceler);
        }
        return this.contentPane;
    }

    private ObjectTable<String> createPreparedStatementValueTable() {
        return new ObjectTableBuilder().setSingleSelectionMode().addEditableStringColumn("Statement value", s -> s, (o, n) -> n, 50).addAddObjectAction((parent, value) -> "").addRemoveObjectsAction().addClearTableAction().addMoveObjectUpAction().addMoveObjectDownAction().build();
    }

    private DragGestureListener createResultTableGestureListener(final WrappedTableModel tableModel, final JTable resultTable) {
        return new DragGestureListener(){

            @Override
            public void dragGestureRecognized(DragGestureEvent dge) {
                if (tableModel.getRowCount() == 0 || resultTable.getSelectionModel().isSelectionEmpty()) {
                    return;
                }
                Transferable transferable = new Transferable(){
                    final DataFlavor textPlainUnicodeFlavor = DataFlavor.getTextPlainUnicodeFlavor();

                    @Override
                    public boolean isDataFlavorSupported(DataFlavor flavor) {
                        return DataFlavor.stringFlavor.equals(flavor) || this.textPlainUnicodeFlavor.equals(flavor);
                    }

                    @Override
                    public DataFlavor[] getTransferDataFlavors() {
                        return new DataFlavor[]{DataFlavor.stringFlavor, this.textPlainUnicodeFlavor};
                    }

                    @Override
                    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                        String string = SqlConsoleContentPane.this.getSelectedRowsAsString(tableModel, resultTable);
                        if (this.textPlainUnicodeFlavor.equals(flavor)) {
                            return new ByteArrayInputStream(string.getBytes(this.textPlainUnicodeFlavor.getParameter("charset")));
                        }
                        return string;
                    }
                };
                dge.startDrag(null, transferable);
            }
        };
    }

    private KeyAdapter createResultTableShortCutListener(final WrappedTableModel tableModel, final JTable resultTable) {
        return new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent event) {
                if (event.isControlDown() && event.getKeyCode() == 67) {
                    StringSelection selection = new StringSelection(SqlConsoleContentPane.this.getSelectedRowsAsString(tableModel, resultTable));
                    CLIPBOARD.setContents(selection, selection);
                }
            }
        };
    }

    private KeyAdapter createStatementEditorShortCutListener(final JEditorPane editorPane, final PlainDocument document) {
        return new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent event) {
                if (event.isControlDown()) {
                    if (event.getKeyCode() == 67) {
                        int end;
                        int start = editorPane.getSelectionStart();
                        String editorContent = SqlConsoleContentPane.this.getEditorContent(document, start, end = editorPane.getSelectionEnd());
                        if (editorContent == null) {
                            return;
                        }
                        StringSelection selection = new StringSelection(editorContent);
                        CLIPBOARD.setContents(selection, selection);
                        return;
                    }
                    if (event.getKeyCode() == 88) {
                        int end;
                        int start = editorPane.getSelectionStart();
                        String editorContent = SqlConsoleContentPane.this.getEditorContent(document, start, end = editorPane.getSelectionEnd());
                        if (editorContent == null) {
                            return;
                        }
                        SqlConsoleContentPane.this.insertEditorContent(document, "", start, end);
                        StringSelection selection = new StringSelection(editorContent);
                        CLIPBOARD.setContents(selection, selection);
                        return;
                    }
                }
            }
        };
    }

    private MouseAdapter createDoubleClickSchemaTreeListener(final JTree schemaTreePane) {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                SqlConsoleContentPane.this.consumeObject(schemaTreePane.getSelectionPath(), (IApplicable<Object>)((IApplicable)o -> o instanceof IDatabaseTableName || o instanceof IDatabaseIndexName || o instanceof IDatabaseConstraintName || o instanceof IDatabaseSequenceName || o instanceof IDatabaseTriggerName || o instanceof IDatabaseColumnName), (IBiConsumer<TreePath, Object, RuntimeException>)((IBiConsumer)(p, t) -> Optional.of((Object)t).consume(o -> SqlConsoleContentPane.this.run(e.getComponent(), SqlConsoleMessages.SQLConsole, SqlConsoleMessages.loadTableContent, (IProgressTask<Void, RuntimeException>)((IProgressTask)(progressMonitor, canceler) -> {
                    if (o instanceof IJdbcConnectionDescription) {
                        SqlConsoleContentPane.this.queryDataBaseProperties(canceler);
                        return null;
                    }
                    if (o instanceof IDatabaseTableName) {
                        IDatabaseTableName name = (IDatabaseTableName)o;
                        SqlConsoleContentPane.this.statementExecutor.executeStatement(canceler, SqlConsoleContentPane.this.createTableSelectStatement(name));
                        return null;
                    }
                    if (o instanceof IDatabaseSequenceName) {
                        IDatabaseSequenceName name = (IDatabaseSequenceName)o;
                        SqlConsoleContentPane.this.querySequenceMetadata(canceler, name);
                        return null;
                    }
                    if (o instanceof IDatabaseTriggerName) {
                        IDatabaseTriggerName name = (IDatabaseTriggerName)o;
                        SqlConsoleContentPane.this.queryTriggerMetadata(canceler, name);
                        return null;
                    }
                    if (o instanceof IDatabaseIndexName) {
                        IDatabaseIndexName name = (IDatabaseIndexName)o;
                        SqlConsoleContentPane.this.queryIndexMetadata(canceler, name);
                        return null;
                    }
                    if (o instanceof IDatabaseConstraintName) {
                        IDatabaseConstraintName name = (IDatabaseConstraintName)o;
                        IDatabaseTableName table = SqlConsoleContentPane.this.select((TreePath)p, IDatabaseTableName.class);
                        SqlConsoleContentPane.this.queryConstraintMetadata(canceler, table, name);
                        return null;
                    }
                    if (o instanceof IDatabaseColumnName) {
                        IDatabaseColumnName name = (IDatabaseColumnName)o;
                        SqlConsoleContentPane.this.queryColumnMetadata(canceler, name);
                        return null;
                    }
                    return null;
                })))));
            }
        };
    }

    private TreeSelectionListener createTreeNodeSelectionListener() {
        return e -> {
            TreePath treePath = e.getNewLeadSelectionPath();
            this.consumeObject(treePath, (IApplicable<Object>)((IApplicable)o -> true), (IBiConsumer<TreePath, Object, RuntimeException>)((IBiConsumer)(path, input) -> {
                this.selectedTable.set(null);
                this.selectedColumn.set(null);
                this.selectedSequence.set(null);
                this.selectedTrigger.set(null);
                this.selectedIndex.set(null);
                this.selectedConstraint.set(null);
                if (input instanceof IDatabaseTableName) {
                    IDatabaseTableName name = (IDatabaseTableName)input;
                    this.selectedTable.set((Object)name);
                } else if (input instanceof IDatabaseColumnName) {
                    IDatabaseColumnName name = (IDatabaseColumnName)input;
                    this.selectedColumn.set((Object)name);
                } else if (input instanceof IDatabaseSequenceName) {
                    IDatabaseSequenceName name = (IDatabaseSequenceName)input;
                    this.selectedSequence.set((Object)name);
                } else if (input instanceof IDatabaseTriggerName) {
                    IDatabaseTriggerName name = (IDatabaseTriggerName)input;
                    this.selectedTrigger.set((Object)name);
                } else if (input instanceof IDatabaseIndexName) {
                    IDatabaseIndexName name = (IDatabaseIndexName)input;
                    this.selectedIndex.set((Object)name);
                } else if (input instanceof IDatabaseConstraintName) {
                    IDatabaseConstraintName name = (IDatabaseConstraintName)input;
                    this.selectedConstraint.set((Object)name);
                }
                this.isConnectionDescriptionSelectedModel.set(input instanceof IJdbcConnectionDescription);
                this.isTableSelectedModel.set(input instanceof IDatabaseTableName);
                this.isColumnsSelectedModel.set(input instanceof IDatabaseColumnName);
                this.isSequenceSelectedModel.set(input instanceof IDatabaseSequenceName);
                this.isTriggerSelectedModel.set(input instanceof IDatabaseTriggerName);
                this.isIndexSelectedModel.set(input instanceof IDatabaseIndexName);
                this.isConstraintSelectedModel.set(input instanceof IDatabaseConstraintName);
            }));
        };
    }

    private TreeWillExpandListener createTreeNodeExpandeListener(final FilteredDefaultTreeModel schemaTreeModel) {
        return new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                TreePath path = event.getPath();
                Object object = path.getLastPathComponent();
                if (object instanceof ReloadableFolderTreeNode) {
                    ReloadableFolderTreeNode node = (ReloadableFolderTreeNode)object;
                    node.load((DefaultTreeModel)schemaTreeModel);
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }
        };
    }

    private TableColumnModelListener createTableColumnAdjustmentListener(final WrappedTableModel tableModel) {
        return new TableColumnModelListener(){

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnAdded(TableColumnModelEvent e) {
                GuiUtilities.invokeLater(() -> {
                    int index;
                    TableColumnModel source = (TableColumnModel)e.getSource();
                    TableColumn column = source.getColumn(index = e.getToIndex());
                    Object headerValue = column.getHeaderValue();
                    if (headerValue == null || SqlConsoleMessages.empty.equals(headerValue)) {
                        return;
                    }
                    Class columnClass = tableModel.getColumnCount() > index ? tableModel.getColumnClass(index) : Object.class;
                    int columnWithFor = TableUtilities.getColumnWithFor((Class)columnClass);
                    column.setPreferredWidth(columnWithFor);
                    column.setWidth(columnWithFor);
                    ObjectTableCellRenderer renderer = tableModel.isWrapperFor(ResultSetTableModel.class) ? SqlConsoleContentPane.this.dataBaseTableCellValueRenderFactory.create(SqlConsoleContentPane.this.description, ((ResultSetTableModel)tableModel.unwrap(ResultSetTableModel.class)).getColumnTypeName(index)) : new ObjectTableCellRenderer();
                    column.setCellRenderer((TableCellRenderer)renderer);
                });
            }
        };
    }

    private ListDataListener createStatementHistoryPreferenceSynchroniceListener(final IProcessManager processManager, final StringListPreference statementListPreference) {
        return new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                int size = SqlConsoleContentPane.this.historyComboBoxModel.getSize();
                List values = Streams.until((int)size).convert(p -> SqlConsoleContentPane.this.historyComboBoxModel.getElementAt((int)p)).asList();
                processManager.execute(new ProcessBuilder().setExecutable((m, c, i) -> statementListPreference.set(values)).build());
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
            }
        };
    }

    private DocumentListener createStatementHistoryComboBoxSynchroniceListener(final PlainDocument document, final JComboBox<String> historyComboBox) {
        return new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.check(document, historyComboBox);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.check(document, historyComboBox);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.check(document, historyComboBox);
            }

            private void check(PlainDocument document2, JComboBox<String> historyComboBox2) {
                try {
                    SqlConsoleContentPane.this.isTextAvailableModel.set(document2.getLength() > 0);
                    String string = document2.getText(0, document2.getLength());
                    if (StringUtilities.isNullOrTrimmedEmpty((String)string) || ObjectUtilities.equals((Object)string, (Object)SqlConsoleContentPane.this.historyComboBoxModel.getSelectedItem())) {
                        return;
                    }
                    historyComboBox2.setSelectedItem(null);
                }
                catch (BadLocationException exception) {
                    logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
                }
            }
        };
    }

    private AbstractAction createExecuteSqlStatementAction(PlainDocument document) {
        return new ConfigurableActionBuilder().setName(SqlConsoleMessages.execute).setTooltip(SqlConsoleMessages.execute).setEnabledDistributor(this.textActionsEnabledDistributor).setIcon((IGuiIcon)ContrastHightIcons.MEDIA_PLAYBACK_START).setProcedure(new ActionProcedurBuilder().setInitializer(parentComponent -> this.getEditiorContent(document)).setTask((monitor, canceler, statementString) -> {
            if (statementString == null || statementString.isBlank()) {
                return null;
            }
            this.statementExecutor.executeStatement(canceler, (String)statementString);
            return null;
        }).build()).build();
    }

    private AbstractAction createSaveSqlStatementToFileAction(PlainDocument document) {
        return new ConfigurableActionBuilder().setName(SqlConsoleMessages.save).setTooltip(SqlConsoleMessages.save).setIcon((IGuiIcon)ContrastHightIcons.DOCUMENT_SAVE).setEnabledDistributor((IBooleanDistributor)this.isTextAvailableModel).setProcedure(component -> this.save(component, this.getEditiorContent(document))).build();
    }

    private AbstractAction createOpenSqlStatementFromFileAction(PlainDocument document) {
        return new ConfigurableActionBuilder().setName(SqlConsoleMessages.open).setTooltip(SqlConsoleMessages.open).setIcon((IGuiIcon)ContrastHightIcons.DOCUMENT_OPEN).setProcedure(component -> this.setEditorContent(document, this.open(component, this.getEditiorContent(document)))).build();
    }

    private AbstractAction createReconnectAction() {
        return new ConfigurableActionBuilder().setName(SqlConsoleMessages.connect).setTooltip(SqlConsoleMessages.connect).setIcon((IGuiIcon)ContrastHightIcons.GTK_CONNECT).setEnabledDistributor((IBooleanDistributor)this.isDisconnectedModel).setProcedure(c -> this.connect(c)).build();
    }

    private AbstractAction createDisconnectAction() {
        return new ConfigurableActionBuilder().setName(SqlConsoleMessages.disconnect).setTooltip(SqlConsoleMessages.disconnect).setIcon((IGuiIcon)ContrastHightIcons.GTK_DISCONNECT).setEnabledDistributor((IBooleanDistributor)this.isConnectedModel).setProcedure(c -> this.disconnect(c)).build();
    }

    private AbstractAction createReloadSchemaAction(FilteredDefaultTreeModel schemaTreeModel) {
        return new ConfigurableActionBuilder().setName(SqlConsoleMessages.reload).setTooltip(SqlConsoleMessages.reloadDatabaseSchema).setIcon((IGuiIcon)ContrastHightIcons.VIEW_REFRESH).setEnabledDistributor((IBooleanDistributor)this.isConnectedModel).setTask((monitor, canceler, value) -> {
            DefaultMutableTreeNode node = this.schemaTreeFactory.create(canceler, this.description, this.schema);
            if (node == null) {
                return null;
            }
            schemaTreeModel.setRoot((TreeNode)node);
            return null;
        }).build();
    }

    private AbstractAction createShowPropertiesAction() {
        return new ConfigurableActionBuilder().setName(SqlConsoleMessages.properties).setTooltip(SqlConsoleMessages.properties).setIcon((IGuiIcon)ContrastHightIcons.DIALOG_INFORMATION).setEnabledDistributor(this.propertiesActionsEnabledDistributor).setTask((monitor, canceler, value) -> {
            if (this.isConnectionDescriptionSelectedModel.isTrue()) {
                this.queryDataBaseProperties(canceler);
            }
            if (this.isTableSelectedModel.isTrue()) {
                this.queryTableMetadata(canceler, (IDatabaseTableName)this.selectedTable.get());
            }
            if (this.isColumnsSelectedModel.isTrue()) {
                this.queryColumnMetadata(canceler, (IDatabaseColumnName)this.selectedColumn.get());
            }
            if (this.isSequenceSelectedModel.isTrue()) {
                this.querySequenceMetadata(canceler, (IDatabaseSequenceName)this.selectedSequence.get());
            }
            if (this.isTriggerSelectedModel.isTrue()) {
                this.queryTriggerMetadata(canceler, (IDatabaseTriggerName)this.selectedTrigger.get());
            }
            if (this.isIndexSelectedModel.isTrue()) {
                this.queryIndexMetadata(canceler, (IDatabaseIndexName)this.selectedIndex.get());
            }
            if (this.isConstraintSelectedModel.isTrue()) {
                this.queryConstraintMetadata(canceler, null, (IDatabaseConstraintName)this.selectedConstraint.get());
            }
            return null;
        }).build();
    }

    private Action createShowCapabilitiesAction() {
        return new ConfigurableActionBuilder().setName("Capabilities").setTooltip("Capabilities").setIcon((IGuiIcon)GuiIcons.QUERY_ICON).setEnabledDistributor((IBooleanDistributor)this.isConnectionDescriptionSelectedModel).setTask((monitor, canceler, value) -> {
            if (this.isConnectionDescriptionSelectedModel.isTrue()) {
                this.queryDataBaseCapabilities(canceler);
            }
            return null;
        }).build();
    }

    private Action createShowTypesAction() {
        return new ConfigurableActionBuilder().setName("Datatypes").setTooltip("Datatypes").setIcon((IGuiIcon)GuiIcons.ZOOM_IN_ICON).setEnabledDistributor((IBooleanDistributor)this.isConnectionDescriptionSelectedModel).setTask((monitor, canceler, value) -> {
            if (this.isConnectionDescriptionSelectedModel.isTrue()) {
                this.queryDataBaseDatatypes(canceler);
            }
            return null;
        }).build();
    }

    private AbstractAction createShowTablePrivilegsAction() {
        return new ConfigurableActionBuilder().setName(SqlConsoleMessages.tablePrivileges).setTooltip(SqlConsoleMessages.tablePrivileges).setEnabledDistributor(this.tableActionsEnabledDistributor).setIcon((IGuiIcon)ContrastHightIcons.SECURITY_MEDIUM).setTask(() -> this.getResultSet((IAggregator<Connection, IDatabaseTableName, ResultSet, SQLException>)((IAggregator)(connection, tableName) -> this.databaseFacade.getTablePrivileges(connection, tableName)))).build();
    }

    private AbstractAction createShwoColumnPrivilegesAction() {
        return new ConfigurableActionBuilder().setName(SqlConsoleMessages.columnPrivileges).setTooltip(SqlConsoleMessages.columnPrivileges).setEnabledDistributor(this.tableActionsEnabledDistributor).setIcon((IGuiIcon)ContrastHightIcons.SECURITY_HIGH).setTask(() -> this.getResultSet((IAggregator<Connection, IDatabaseTableName, ResultSet, SQLException>)((IAggregator)(connection, tableName) -> this.databaseFacade.getColumnPrivileges(connection, tableName, null)))).build();
    }

    private AbstractAction createShowTableContentAction() {
        return new ConfigurableActionBuilder().setName(SqlConsoleMessages.content).setTooltip(SqlConsoleMessages.content).setEnabledDistributor(this.tableActionsEnabledDistributor).setIcon((IGuiIcon)ContrastHightIcons.VIEW_LIST_TEXT).setTask(() -> this.statementExecutor.executeStatement(ICanceler.DummyCanceler, this.createTableSelectStatement((IDatabaseTableName)this.selectedTable.get()))).build();
    }

    private AbstractAction createCreateStatementAction(PlainDocument document) {
        return new ConfigurableActionBuilder().setName(SqlConsoleMessages.createStatement).setTooltip(SqlConsoleMessages.createStatement).setEnabledDistributor(this.createStatementActionsEnabledDistributor).setIcon((IGuiIcon)ContrastHightIcons.FORMAT_JUSTIFY_LEFT).setTask((monitor, canceler, value) -> {
            try {
                this.statusModel.set((Object)SqlConsoleMessages.working);
                String statement = null;
                if (this.isTriggerSelectedModel.isTrue()) {
                    statement = this.databaseFacade.getTriggerStatement(canceler, (Connection)this.connectionModel.get(), (IDatabaseTriggerName)this.selectedTrigger.get());
                }
                if (this.isTableSelectedModel.isTrue()) {
                    statement = this.databaseFacade.getTableStatement(canceler, (Connection)this.connectionModel.get(), (IDatabaseTableName)this.selectedTable.get());
                }
                if (statement == null) {
                    this.statusModel.set((Object)SqlConsoleMessages.emptyResult);
                    return null;
                }
                this.setEditorContent(document, statement);
                this.statusModel.set((Object)SqlConsoleMessages.done);
                return null;
            }
            catch (SQLException exception) {
                logger.log(ILevel.DEBUG, "Couldn't close connection", (Throwable)exception);
                this.statusModel.set((Object)exception.getMessage());
                return null;
            }
        }).build();
    }

    private DefaultMutableTreeNode createSchemaTree() {
        try {
            return this.schemaTreeFactory.create(ICanceler.DummyCanceler, this.description, this.schema);
        }
        catch (CanceledException exception) {
            throw new UnreachableCodeReachedException((Throwable)exception);
        }
    }

    private TransferHandler createTransferableHandler() {
        final HierarchicalClassKeyRegistry registry = new HierarchicalClassKeyRegistry();
        SqlConsoleContentPane.register((HierarchicalClassKeyRegistry<Function<Object, Transferable>>)registry, IDatabaseSchemaName.class, o -> (String)Optional.of((Object)o).instanceOf(IDatabaseSchemaName.class).convert(n -> n.getName()).get());
        SqlConsoleContentPane.register((HierarchicalClassKeyRegistry<Function<Object, Transferable>>)registry, IDatabaseTableName.class, o -> (String)Optional.of((Object)o).instanceOf(IDatabaseTableName.class).convert(n -> n.getName()).get());
        SqlConsoleContentPane.register((HierarchicalClassKeyRegistry<Function<Object, Transferable>>)registry, IDatabaseColumnName.class, o -> (String)Optional.of((Object)o).instanceOf(IDatabaseColumnName.class).convert(n -> n.getName()).get());
        SqlConsoleContentPane.register((HierarchicalClassKeyRegistry<Function<Object, Transferable>>)registry, IDatabaseTriggerName.class, o -> (String)Optional.of((Object)o).instanceOf(IDatabaseTriggerName.class).convert(n -> n.getName()).get());
        SqlConsoleContentPane.register((HierarchicalClassKeyRegistry<Function<Object, Transferable>>)registry, IDatabaseIndexName.class, o -> (String)Optional.of((Object)o).instanceOf(IDatabaseIndexName.class).convert(n -> n.getName()).get());
        SqlConsoleContentPane.register((HierarchicalClassKeyRegistry<Function<Object, Transferable>>)registry, IDatabaseSequenceName.class, o -> (String)Optional.of((Object)o).instanceOf(IDatabaseSequenceName.class).convert(n -> n.getName()).get());
        SqlConsoleContentPane.register((HierarchicalClassKeyRegistry<Function<Object, Transferable>>)registry, IDatabaseConstraintName.class, o -> (String)Optional.of((Object)o).instanceOf(IDatabaseConstraintName.class).convert(n -> n.getName()).get());
        return new TransferHandler(){

            @Override
            public int getSourceActions(JComponent c) {
                return 1;
            }

            @Override
            protected Transferable createTransferable(JComponent c) {
                JTree tree;
                TreePath[] paths;
                if (c instanceof JTree && (paths = (tree = (JTree)c).getSelectionPaths()).length == 1) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[0].getLastPathComponent();
                    Object userObject = node.getUserObject();
                    return (Transferable)Optional.of((Object)((Function)registry.get(userObject.getClass()))).convert(f -> (Transferable)f.apply(userObject)).getOr(() -> super.createTransferable(c));
                }
                return super.createTransferable(c);
            }
        };
    }

    private static <T> void register(HierarchicalClassKeyRegistry<Function<Object, Transferable>> registry, Class<T> clazz, final Function<Object, String> converter) {
        final String mimeType = MessageFormat.format("{0};class=\"{1}\"", "application/x-java-jvm-local-objectref", clazz.getName());
        final List<DataFlavor> dataFlavors = SqlConsoleContentPane.createSupportedDataFlavors(clazz, mimeType);
        registry.add(clazz, o -> (Transferable)Optional.of((Object)o).instanceOf(clazz).convert(c -> new Transferable(){

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return (DataFlavor[])dataFlavors.toArray(DataFlavor[]::new);
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return dataFlavors.contains(flavor);
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                if (Objects.equals(DataFlavor.stringFlavor, flavor)) {
                    return Optional.of((Object)((String)converter.apply(c))).get();
                }
                if (Objects.equals(DataFlavor.plainTextFlavor, flavor)) {
                    return Optional.of((Object)((String)converter.apply(c))).get();
                }
                if (Objects.equals(DataFlavor.getTextPlainUnicodeFlavor(), flavor)) {
                    return Optional.of((Object)((String)converter.apply(c))).convert(string -> new ByteArrayInputStream(string.getBytes(Charset.forName("UTF-8")))).get();
                }
                if (flavor.isMimeTypeEqual(mimeType)) {
                    return c;
                }
                return null;
            }
        }).get());
    }

    protected static <T> List<DataFlavor> createSupportedDataFlavors(Class<T> clazz, String mimeType) {
        try {
            if (Serializable.class.isAssignableFrom(clazz)) {
                return List.of(new DataFlavor(mimeType), DataFlavor.stringFlavor, DataFlavor.getTextPlainUnicodeFlavor(), DataFlavor.plainTextFlavor);
            }
            return List.of(DataFlavor.stringFlavor, DataFlavor.getTextPlainUnicodeFlavor(), DataFlavor.plainTextFlavor);
        }
        catch (ClassNotFoundException exception) {
            return List.of(DataFlavor.stringFlavor, DataFlavor.getTextPlainUnicodeFlavor(), DataFlavor.plainTextFlavor);
        }
    }

    private String toHtml(String string) {
        if (StringUtilities.isNullOrTrimmedEmpty((String)string)) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<html><body>");
        builder.append(string.replaceAll("\\n", "<br>"));
        builder.append("</html></body>");
        return builder.toString();
    }

    private String createTableSelectStatement(IDatabaseTableName tableName) {
        return String.format("select * from %1$s", this.databaseFacade.quoted(tableName));
    }

    private void consumeObject(TreePath treePath, IApplicable<Object> applicable, IBiConsumer<TreePath, Object, RuntimeException> consumer) {
        if (treePath == null) {
            consumer.consume((Object)treePath, null);
            return;
        }
        Object lastPathComponent = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
        if (applicable.isApplicable(lastPathComponent)) {
            consumer.consume((Object)treePath, lastPathComponent);
        }
    }

    private IDatabaseTableName select(TreePath path, Class<IDatabaseTableName> clazz) {
        Object[] objects = path.getPath();
        return (IDatabaseTableName)Streams.of((Object[])objects).instanceOf(DefaultMutableTreeNode.class).convert(node -> node.getUserObject()).instanceOf(clazz).first().get();
    }

    private void disconnect(Component parentComponent) {
        try {
            boolean isClosed;
            this.statusModel.set((Object)SqlConsoleMessages.working);
            if (!((Connection)this.connectionModel.get()).isClosed()) {
                ((Connection)this.connectionModel.get()).close();
            }
            this.isConnectedModel.set(!(isClosed = ((Connection)this.connectionModel.get()).isClosed()));
            this.isDisconnectedModel.set(isClosed);
            this.statusModel.set((Object)SqlConsoleMessages.done);
        }
        catch (SQLException exception) {
            logger.log(ILevel.DEBUG, "Couldn't close connection", (Throwable)exception);
            this.statusModel.set((Object)exception.getMessage());
        }
    }

    private void connect(Component parentComponent) {
        try {
            this.statusModel.set((Object)SqlConsoleMessages.working);
            if (!((Connection)this.connectionModel.get()).isClosed()) {
                ((Connection)this.connectionModel.get()).close();
            }
            this.connectionModel.set((Object)this.databaseConnector.connectWritable(this.description, true));
            boolean isClosed = ((Connection)this.connectionModel.get()).isClosed();
            this.isConnectedModel.set(!isClosed);
            this.isDisconnectedModel.set(isClosed);
            this.statusModel.set((Object)SqlConsoleMessages.done);
        }
        catch (SQLException exception) {
            logger.log(ILevel.DEBUG, "Couldn't close connection", (Throwable)exception);
            this.statusModel.set((Object)exception.getMessage());
        }
    }

    private void setEditorContent(PlainDocument document, String string) {
        GuiUtilities.invokeLater(() -> {
            try {
                document.replace(0, document.getLength(), string, null);
            }
            catch (BadLocationException exception) {
                logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
            }
        });
    }

    private void insertEditorContent(PlainDocument document, String string, int start, int end) {
        GuiUtilities.invokeLater(() -> {
            try {
                if (start == end) {
                    document.insertString(start, string, null);
                } else {
                    document.replace(start, end - start, string, null);
                }
            }
            catch (BadLocationException exception) {
                logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
            }
        });
    }

    private String getEditorContent(PlainDocument document, int start, int end) {
        try {
            if (start == end) {
                return null;
            }
            return document.getText(start, end - start);
        }
        catch (BadLocationException exception) {
            logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    private String getEditiorContent(PlainDocument document) {
        try {
            return document.getText(0, document.getLength());
        }
        catch (BadLocationException exception) {
            logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
            this.statusModel.set((Object)exception.getMessage());
            return null;
        }
    }

    private String open(Component component, String string) {
        List<FileFilter> filters = Arrays.asList(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return FileUtilities.hasExtension((File)pathname, (String[])new String[]{"sql"});
            }

            @Override
            public String getDescription() {
                return "SQL File (*.sql)";
            }
        });
        IFileChooserResult result = FileChoosers.show((Component)GuiUtilities.getParentWindow((Component)component), (IPreferences)this.preferences.node(new String[]{"filechooser"}), (IOpenFileChooserConfiguration)new OpenFileChooserConfiguration(filters, 0, false));
        if (result.getReturnState() == 0) {
            String string2;
            this.statusModel.set((Object)SqlConsoleMessages.working);
            File file = result.getSelectedFile();
            FileInputStream stream = new FileInputStream(file);
            try {
                String content = IoUtilities.toString((InputStream)stream, (String)Charset.defaultCharset().name());
                this.statusModel.set((Object)SqlConsoleMessages.done);
                string2 = content;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
                    this.statusModel.set((Object)exception.getMessage());
                    return string;
                }
            }
            ((InputStream)stream).close();
            return string2;
        }
        return string;
    }

    private void save(Component component, String string) {
        if (string == null) {
            return;
        }
        List<FileFilter> filters = Arrays.asList(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return FileUtilities.hasExtension((File)pathname, (String[])new String[]{"sql"});
            }

            @Override
            public String getDescription() {
                return "SQL File (*.sql)";
            }
        });
        IFileChooserResult result = FileChoosers.show((Component)GuiUtilities.getParentWindow((Component)component), (IPreferences)this.preferences.node(new String[]{"filechooser"}), (ISaveFileChooserConfiguration)new SaveFileChooserConfiguration(filters, 0, false, false));
        if (result.getReturnState() == 0) {
            this.statusModel.set((Object)SqlConsoleMessages.working);
            File file = result.getSelectedFile();
            try (FileOutputStream stream = new FileOutputStream(file);){
                IoUtilities.pipe((InputStream)new ByteArrayInputStream(string.getBytes(Charset.defaultCharset())), (OutputStream)stream);
                this.statusModel.set((Object)SqlConsoleMessages.done);
            }
            catch (IOException exception) {
                logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
                this.statusModel.set((Object)exception.getMessage());
            }
        }
    }

    private void getMetadataResult(IAggregator<DatabaseMetaData, IDatabaseTableName, ResultSet, SQLException> metadataProvider) {
        try {
            this.statusModel.set((Object)SqlConsoleMessages.working);
            DatabaseMetaData metaData = this.databaseFacade.getMetaData((Connection)this.connectionModel.get());
            IDatabaseTableName tableName = (IDatabaseTableName)this.selectedTable.get();
            this.resultReseter.reset();
            ResultSet result = (ResultSet)metadataProvider.aggregate((Object)metaData, (Object)tableName);
            if (result == null) {
                this.statusModel.set((Object)SqlConsoleMessages.noResult);
                return;
            }
            this.statementModel.set((Object)result.getStatement());
            this.resultSetModel.set((Object)result);
            this.statusModel.set((Object)SqlConsoleMessages.done);
        }
        catch (SQLException exception) {
            logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
            this.resultReseter.reset();
            this.statusModel.set((Object)exception.getMessage());
        }
    }

    private void getResultSet(IAggregator<Connection, IDatabaseTableName, ResultSet, SQLException> resultSetProvider) {
        try {
            this.statusModel.set((Object)SqlConsoleMessages.working);
            this.resultReseter.reset();
            ResultSet result = (ResultSet)resultSetProvider.aggregate((Object)((Connection)this.connectionModel.get()), (Object)((IDatabaseTableName)this.selectedTable.get()));
            if (result == null) {
                this.statusModel.set((Object)SqlConsoleMessages.noResult);
                return;
            }
            this.statementModel.set((Object)result.getStatement());
            this.resultSetModel.set((Object)result);
            this.statusModel.set((Object)SqlConsoleMessages.done);
        }
        catch (SQLException exception) {
            logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
            this.resultReseter.reset();
            this.statusModel.set((Object)exception.getMessage());
        }
    }

    private <T> void queryMetadata(IFunction<Connection, ResultSet, SQLException> function) {
        try {
            this.statusModel.set((Object)SqlConsoleMessages.working);
            ResultSet result = (ResultSet)function.execute((Object)((Connection)this.connectionModel.get()));
            if (result == null) {
                this.resultReseter.reset();
                this.statusModel.set((Object)SqlConsoleMessages.noResult);
                return;
            }
            this.resultReseter.reset();
            this.statementModel.set((Object)result.getStatement());
            this.resultSetModel.set((Object)result);
            this.statusModel.set((Object)SqlConsoleMessages.done);
        }
        catch (SQLException exception) {
            logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
            this.resultReseter.reset();
            this.statusModel.set((Object)exception.getMessage());
        }
    }

    private void queryProperties(IFunction<Connection, List<Property>, SQLException> function) {
        try {
            this.statusModel.set((Object)SqlConsoleMessages.working);
            List properties = (List)function.execute((Object)((Connection)this.connectionModel.get()));
            if (properties == null) {
                this.resultReseter.reset();
                this.statusModel.set((Object)SqlConsoleMessages.noResult);
                return;
            }
            this.resultReseter.reset();
            this.resultDataTableModel.wrap((TableModel)new PropertyTableModel(properties));
            this.statusModel.set((Object)SqlConsoleMessages.done);
        }
        catch (SQLException exception) {
            logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
            this.resultReseter.reset();
            this.statusModel.set((Object)exception.getMessage());
        }
    }

    private void queryDataBaseProperties(ICanceler canceler) {
        this.queryProperties((IFunction<Connection, List<Property>, SQLException>)((IFunction)connection -> {
            try {
                return this.databaseFacade.getClientProperties(canceler, connection);
            }
            catch (CanceledException exception) {
                return null;
            }
        }));
    }

    private void queryDataBaseCapabilities(ICanceler canceler) {
        this.queryProperties((IFunction<Connection, List<Property>, SQLException>)((IFunction)connection -> {
            try {
                return this.databaseFacade.getCapabilities(canceler, connection);
            }
            catch (CanceledException exception) {
                return null;
            }
        }));
    }

    private void queryDataBaseDatatypes(ICanceler canceler) {
        this.queryMetadata((IFunction<Connection, ResultSet, SQLException>)((IFunction)connection -> {
            try {
                return this.databaseFacade.getDataTypes(canceler, connection);
            }
            catch (CanceledException exception) {
                return null;
            }
        }));
    }

    private void queryTableMetadata(ICanceler canceler, IDatabaseTableName name) {
        this.queryMetadata((IFunction<Connection, ResultSet, SQLException>)((IFunction)connection -> {
            try {
                return this.databaseFacade.getTableMetadata(canceler, connection, name);
            }
            catch (CanceledException exception) {
                return null;
            }
        }));
    }

    private void queryColumnMetadata(ICanceler canceler, IDatabaseColumnName name) {
        this.queryMetadata((IFunction<Connection, ResultSet, SQLException>)((IFunction)connection -> {
            try {
                return this.databaseFacade.getTableColumnMetadata(canceler, connection, name);
            }
            catch (CanceledException exception) {
                return null;
            }
        }));
    }

    private void querySequenceMetadata(ICanceler canceler, IDatabaseSequenceName name) {
        this.queryMetadata((IFunction<Connection, ResultSet, SQLException>)((IFunction)connection -> {
            try {
                return this.databaseFacade.getSequenceMetadata(canceler, connection, name);
            }
            catch (CanceledException exception) {
                return null;
            }
        }));
    }

    private void queryTriggerMetadata(ICanceler canceler, IDatabaseTriggerName name) {
        this.queryMetadata((IFunction<Connection, ResultSet, SQLException>)((IFunction)connection -> {
            try {
                return this.databaseFacade.getTriggerMetadata(canceler, connection, name);
            }
            catch (CanceledException exception) {
                return null;
            }
        }));
    }

    private void queryIndexMetadata(ICanceler canceler, IDatabaseIndexName name) {
        this.queryMetadata((IFunction<Connection, ResultSet, SQLException>)((IFunction)connection -> {
            try {
                return this.databaseFacade.getIndexMetadata(canceler, connection, name);
            }
            catch (CanceledException exception) {
                return null;
            }
        }));
    }

    private void queryConstraintMetadata(ICanceler canceler, IDatabaseTableName table, IDatabaseConstraintName constraint) {
        this.queryMetadata((IFunction<Connection, ResultSet, SQLException>)((IFunction)connection -> {
            try {
                return this.databaseFacade.getConstraintMetadata(canceler, connection, table, constraint);
            }
            catch (CanceledException exception) {
                return null;
            }
        }));
    }

    private String getCatalog() {
        try {
            return ((Connection)this.connectionModel.get()).getCatalog();
        }
        catch (AbstractMethodError | Exception exception) {
            logger.log(ILevel.DEBUG, exception.getMessage(), exception);
            return null;
        }
    }

    private <I> void run(Component component, String title, String text, IProgressTask<Void, RuntimeException> task) {
        try {
            new ProgressDialogLauncher(task).setTitle(title).setText(text).setDescription("").launch(component);
        }
        catch (CanceledException canceledException) {
            // empty catch block
        }
    }

    private String getSelectedRowsAsString(WrappedTableModel tableModel, JTable resultTable) {
        StringBuilder builder = new StringBuilder();
        boolean rowFlag = false;
        boolean columnFlag = false;
        for (int column = 0; column < tableModel.getColumnCount(); ++column) {
            if (columnFlag) {
                builder.append(", ");
            }
            builder.append("\"");
            builder.append(tableModel.getColumnName(column));
            builder.append("\"");
            columnFlag = true;
        }
        builder.append("\n");
        columnFlag = false;
        for (int row : resultTable.getSelectedRows()) {
            if (rowFlag) {
                builder.append("\n");
            }
            for (int column = 0; column < tableModel.getColumnCount(); ++column) {
                IObjectToStringConverter<Object> toStringConverter;
                if (columnFlag) {
                    builder.append(", ");
                }
                columnFlag = true;
                Object value = tableModel.getValueAt(row, column);
                if (value == null) {
                    builder.append("");
                    continue;
                }
                IObjectToStringConverter<Object> iObjectToStringConverter = toStringConverter = tableModel.isWrapperFor(ResultSetTableModel.class) ? this.dataBaseTableCellValueToStringConverterProvider.get(this.description, ((ResultSetTableModel)tableModel.unwrap(ResultSetTableModel.class)).getColumnTypeName(column)) : o -> (String)Optional.of((Object)o).convert(v -> v.toString()).get();
                if (value instanceof Number) {
                    builder.append(value.toString());
                    continue;
                }
                builder.append("\"");
                if (toStringConverter != null) {
                    builder.append(toStringConverter.toString(value));
                } else {
                    builder.append(value.toString());
                }
                builder.append("\"");
            }
            rowFlag = true;
            columnFlag = false;
        }
        return builder.toString();
    }

    public static final class InternalDatabaseConnector
    implements IDatabaseConnector {
        private final IObjectModel<Connection> connectionModel;
        private final IDatabaseConnector databaseConnector;
        private final IJdbcConnectionDescription description;

        public InternalDatabaseConnector(IObjectModel<Connection> connectionModel, IDatabaseConnector databaseConnector, IJdbcConnectionDescription description) {
            this.connectionModel = connectionModel;
            this.databaseConnector = databaseConnector;
            this.description = description;
        }

        public boolean isConnectable(String url, String userName, String password, IProperties properties) {
            return this.equals(this.description, url, userName, password, properties) ? this.connectionModel.get() != null : this.databaseConnector.isConnectable(url, userName, password, properties);
        }

        private boolean equals(IJdbcConnectionDescription description, String url, String userName, String password, IProperties properties) {
            return Objects.equals(url, description.getUrl()) && Objects.equals(userName, description.getUserName()) && Objects.equals(password, description.getPassword()) && Objects.equals(properties, description.getProperties());
        }

        public Connection connectWritable(String url, String userName, String password, boolean isAutoCommitEnabled, int timeout, IProperties properties) throws SQLException {
            Connection connection;
            if (this.equals(this.description, url, userName, password, properties) && (connection = (Connection)this.connectionModel.get()) == null) {
                throw new SQLException("databese isn't connected");
            }
            return this.databaseConnector.connectWritable(url, userName, password, isAutoCommitEnabled, timeout, properties);
        }

        public Connection connectReadOnly(String url, String userName, String password, int timeout, IProperties properties) throws SQLException {
            return this.equals(this.description, url, userName, password, properties) ? this.connectWritable(url, userName, password, false, timeout, properties) : this.databaseConnector.connectReadOnly(url, userName, password, timeout, properties);
        }
    }
}

