/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.database.swing.console;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.anwiba.commons.jdbc.DatabaseUtilities;
import net.anwiba.commons.lang.functional.IObserver;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.model.IBooleanModel;
import net.anwiba.commons.model.IObjectListModel;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.thread.cancel.ICanceler;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.database.swing.console.SqlConsoleMessages;
import net.anwiba.database.swing.console.result.ResultReseter;

public class StatementExecutor {
    private static ILogger logger = Logging.getLogger(StatementExecutor.class);
    private final IObjectModel<Connection> connectionModel;
    private final IObjectModel<Statement> statementModel;
    private final IObjectModel<ResultSet> resultSetModel;
    private final IObjectModel<String> statusModel;
    private final Consumer<String> statementHistoryConsumer;
    private final IBooleanModel isDisconnectedModel;
    private final IBooleanModel isConnectedModel;
    private final ResultReseter resultReseter;
    private final IObjectListModel<String> statementValuesModel;

    public StatementExecutor(IObjectModel<Connection> connectionModel, ResultReseter resultReseter, IObjectModel<Statement> statementModel, IObjectListModel<String> statementValuesModel, IObjectModel<ResultSet> resultSetModel, IObjectModel<String> statusModel, Consumer<String> statementHistoryConsumer, IBooleanModel isDisconnectedModel, IBooleanModel isConnectedModel) {
        this.connectionModel = connectionModel;
        this.resultReseter = resultReseter;
        this.statementModel = statementModel;
        this.statementValuesModel = statementValuesModel;
        this.resultSetModel = resultSetModel;
        this.statusModel = statusModel;
        this.statementHistoryConsumer = statementHistoryConsumer;
        this.isDisconnectedModel = isDisconnectedModel;
        this.isConnectedModel = isConnectedModel;
    }

    public void executeStatement(ICanceler canceler, String string) {
        try {
            this.statusModel.set((Object)SqlConsoleMessages.working);
            if (StringUtilities.isNullOrTrimmedEmpty((String)string)) {
                this.statusModel.set((Object)SqlConsoleMessages.done);
                return;
            }
            logger.log(ILevel.DEBUG, SqlConsoleMessages.executeStatement + string);
            Connection connection = (Connection)this.connectionModel.get();
            boolean isClosed = connection.isClosed();
            if (isClosed) {
                this.isConnectedModel.set(!isClosed);
                this.isDisconnectedModel.set(isClosed);
                this.statusModel.set((Object)SqlConsoleMessages.connectionIsClosed);
                return;
            }
            PreparedStatement statement = this.createStatement(connection, this.clean(string));
            this.addStatementValuesIfPossible(statement, this.statementValuesModel.toList());
            statement.setFetchSize(100);
            statement.setFetchDirection(1002);
            try (IObserver observer = canceler.observer(DatabaseUtilities.silent(() -> statement.cancel()));){
                this.resultReseter.reset();
                if (!statement.execute()) {
                    this.statementHistoryConsumer.accept(string);
                    this.statusModel.set((Object)SqlConsoleMessages.done);
                    statement.close();
                    return;
                }
            }
            this.statementModel.set((Object)statement);
            ResultSet resultSet = statement.getResultSet();
            this.resultSetModel.set((Object)resultSet);
            this.statementHistoryConsumer.accept(string);
            this.statusModel.set((Object)SqlConsoleMessages.done);
        }
        catch (SQLException exception) {
            this.resultReseter.reset();
            logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
            this.statusModel.set((Object)exception.getMessage());
        }
    }

    private void addStatementValuesIfPossible(PreparedStatement statement, List<String> values) throws SQLException {
        ParameterMetaData parameterMetaData = statement.getParameterMetaData();
        if (parameterMetaData.getParameterCount() == 0 || values.size() < parameterMetaData.getParameterCount()) {
            return;
        }
        for (int i = 0; i < values.size(); ++i) {
            statement.setObject(i + 1, this.convertTo(values.get(i), this.getClassName(parameterMetaData, i)));
        }
    }

    private String getClassName(ParameterMetaData parameterMetaData, int i) throws SQLException {
        try {
            return parameterMetaData.getParameterClassName(i + 1);
        }
        catch (SQLException exception) {
            logger.warning(exception.getMessage());
            return "java.lang.String";
        }
    }

    private Object convertTo(String string, String parameterClassName) throws SQLException {
        if (string == null || string.isEmpty()) {
            return null;
        }
        try {
            return switch (parameterClassName) {
                case "java.lang.Short" -> Short.valueOf(string);
                case "java.lang.Integer" -> Integer.valueOf(string);
                case "java.lang.Long" -> Long.valueOf(string);
                case "java.lang.Float" -> Float.valueOf(string);
                case "java.lang.Double" -> Double.valueOf(string);
                case "java.lang.BigDecimal" -> new BigDecimal(string);
                case "java.lang.Boolean" -> Boolean.valueOf(string);
                case "java.sql.Time" -> Time.valueOf(string);
                case "java.sql.Date" -> Date.valueOf(string);
                case "java.sql.Timestamp" -> Timestamp.valueOf(string);
                default -> string;
            };
        }
        catch (IllegalArgumentException exception) {
            throw new SQLException("converting value '" + string + "' failed, " + exception.getMessage(), exception);
        }
    }

    private String clean(String string) {
        return Optional.ofNullable(string).map(s -> s.trim()).map(t -> t.endsWith(";") ? t.substring(0, t.length() - 1) : t).orElse(string);
    }

    private PreparedStatement createStatement(Connection connection, String string) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        if (metaData.supportsResultSetConcurrency(1004, 1007)) {
            return connection.prepareStatement(string, 1004, 1007);
        }
        if (metaData.supportsResultSetConcurrency(1005, 1007)) {
            return connection.prepareStatement(string, 1005, 1007);
        }
        return connection.prepareStatement(string);
    }
}

