/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.database.swing.console.result;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import net.anwiba.commons.jdbc.connection.IJdbcConnectionDescription;
import net.anwiba.commons.lang.object.IObjectToStringConverter;
import net.anwiba.database.swing.console.converter.IDataBaseTableCellValueToStringConverterProvider;
import net.anwiba.database.swing.console.result.IDataBaseTableCellValueRenderFactory;

public class DataBaseTableCellValueRenderFactory
implements IDataBaseTableCellValueRenderFactory {
    private final IDataBaseTableCellValueToStringConverterProvider provider;

    public DataBaseTableCellValueRenderFactory(IDataBaseTableCellValueToStringConverterProvider provider) {
        this.provider = provider;
    }

    @Override
    public TableCellRenderer create(IJdbcConnectionDescription description, String columnTypeName) {
        final IObjectToStringConverter<Object> objectToStringConverter = this.provider.get(description, columnTypeName);
        if (objectToStringConverter == null) {
            return null;
        }
        return new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value == null) {
                    super.getTableCellRendererComponent(table, "", isSelected, hasFocus, row, column);
                    return this;
                }
                super.getTableCellRendererComponent(table, objectToStringConverter.toString(value), isSelected, hasFocus, row, column);
                return this;
            }
        };
    }
}

