/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.database.swing.console.result;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import net.anwiba.commons.jdbc.metadata.Property;
import net.anwiba.commons.lang.optional.Optional;

public class PropertyTableModel
extends AbstractTableModel
implements TableModel {
    private final List<Property> properties = new ArrayList<Property>();

    public PropertyTableModel(List<Property> properties) {
        this.properties.addAll(properties);
    }

    @Override
    public int getRowCount() {
        return this.properties.size();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || this.properties.size() < rowIndex + 1) {
            return null;
        }
        return Optional.of((Object)this.properties.get(rowIndex)).convert(p -> switch (columnIndex) {
            case 0 -> p.name();
            case 1 -> p.value();
            case 2 -> p.description();
            case 3 -> p.maximumLength();
            case 4 -> p.defaultValue();
            default -> null;
        }).get();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return switch (columnIndex) {
            case 0 -> "name";
            case 1 -> "value";
            case 2 -> "description";
            case 3 -> "maximum length";
            case 4 -> "default value";
            default -> super.getColumnName(columnIndex);
        };
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return switch (columnIndex) {
            case 0 -> String.class;
            case 1 -> Object.class;
            case 2 -> String.class;
            case 4 -> Integer.class;
            case 5 -> Object.class;
            default -> super.getColumnClass(columnIndex);
        };
    }
}

