/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.database.swing.console.result;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.database.swing.console.result.ResultSetToRowConverter;

public class ResultSetAdapter {
    static ResultSetAdapter empty = new ResultSetAdapter(0, 1, Arrays.asList("empty"), Arrays.asList(Object.class), Arrays.asList("object"), Collections.emptyList(), null, Collections.emptyList());
    private final int rowCount;
    private final int columnCount;
    private final List<String> columnNames;
    private final List<Class> columnClasses;
    private final List<String> columnTypeNames;
    private final ResultSet resultSet;
    private final List<List<Object>> resultList;
    private final List<Integer> columnTypes;

    public static ResultSetAdapter create(IObjectModel<String> statusModel, ResultSet set) {
        if (set == null) {
            return empty;
        }
        try {
            int rowCount = 0;
            ArrayList<String> columnNames = new ArrayList<String>();
            ArrayList<Class> columnClasses = new ArrayList<Class>();
            ArrayList<Integer> columnTypes = new ArrayList<Integer>();
            ArrayList<String> columnTypeNames = new ArrayList<String>();
            ResultSet resultSet = null;
            List<List<Object>> resultList = null;
            ResultSetMetaData metaData = set.getMetaData();
            int columnCount = metaData.getColumnCount();
            for (int i = 1; i < columnCount + 1; ++i) {
                columnNames.add(metaData.getColumnName(i));
                columnClasses.add(ResultSetAdapter.getColumnClassForName(metaData.getColumnClassName(i)));
                columnTypes.add(metaData.getColumnType(i));
                columnTypeNames.add(ResultSetAdapter.getColumnTypeName(metaData, i));
            }
            int scrollType = set.getType();
            int concurrency = set.getConcurrency();
            if (!(scrollType != 1004 && scrollType != 1005 || concurrency != 1007 && concurrency != 1008)) {
                set.beforeFirst();
                int start = set.getRow();
                set.last();
                rowCount = set.getRow();
                resultSet = set;
                if (set.absolute(start) && start == set.getRow()) {
                    resultSet = set;
                } else {
                    set.beforeFirst();
                    if (start == set.getRow()) {
                        resultSet = set;
                    } else {
                        resultList = ResultSetAdapter.getRows(columnTypes, columnTypeNames, columnCount, set);
                        rowCount = resultList.size();
                    }
                }
            } else {
                resultList = ResultSetAdapter.getRows(columnTypes, columnTypeNames, columnCount, set);
                rowCount = resultList.size();
            }
            return new ResultSetAdapter(rowCount, columnCount, columnNames, columnClasses, columnTypeNames, columnTypes, resultSet, resultList);
        }
        catch (Exception exception) {
            statusModel.set((Object)exception.getMessage());
            return empty;
        }
    }

    private static String getColumnTypeName(ResultSetMetaData metaData, int i) throws SQLException {
        long precision = metaData.getPrecision(i);
        long scale = metaData.getScale(i);
        String columnTypeName = metaData.getColumnTypeName(i);
        return columnTypeName + ResultSetAdapter.typeNameConstaints(precision, scale);
    }

    private static String typeNameConstaints(long precision, long scale) {
        if (precision == 0L) {
            return "";
        }
        if (scale == 0L) {
            return "(" + precision + ")";
        }
        return "(" + precision + "," + scale + ")";
    }

    protected static List<List<Object>> getRows(List<Integer> columnTypes, List<String> columnTypeNames, int columnCount, ResultSet set) throws SQLException {
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
        ResultSetToRowConverter converter = new ResultSetToRowConverter(columnTypes, columnTypeNames, columnCount);
        while (set.next()) {
            rows.add(converter.convert(set));
        }
        return rows;
    }

    private static Class<?> getColumnClassForName(String columnClassName) {
        try {
            return Class.forName(columnClassName);
        }
        catch (ClassNotFoundException exception) {
            return Object.class;
        }
    }

    public ResultSetAdapter(int rowCount, int columnCount, List<String> columnNames, List<Class> columnClasses, List<String> columnTypeNames, List<Integer> columnTypes, ResultSet resultSet, List<List<Object>> resultList) {
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        this.columnNames = columnNames;
        this.columnClasses = columnClasses;
        this.columnTypeNames = columnTypeNames;
        this.columnTypes = columnTypes;
        this.resultSet = resultSet;
        this.resultList = resultList;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public List<String> getColumnTypeNames() {
        return this.columnTypeNames;
    }

    public List<Integer> getColumnTypes() {
        return this.columnTypes;
    }

    public List<Class> getColumnClasses() {
        return this.columnClasses;
    }

    public String getColumnName(int columnIndex) {
        return columnIndex < 0 || columnIndex >= this.columnNames.size() ? null : this.columnNames.get(columnIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getColumnClass(int columnIndex) {
        ResultSetAdapter resultSetAdapter = this;
        synchronized (resultSetAdapter) {
            return columnIndex < 0 || columnIndex >= this.columnClasses.size() ? Object.class : this.columnClasses.get(columnIndex);
        }
    }

    public String getColumnTypeName(int columnIndex) {
        return columnIndex < 0 || columnIndex >= this.columnTypeNames.size() ? null : this.columnTypeNames.get(columnIndex);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.resultList != null) {
            if (rowIndex >= this.resultList.size()) {
                return null;
            }
            List<Object> row = this.resultList.get(rowIndex);
            if (columnIndex >= row.size()) {
                return null;
            }
            return row.get(columnIndex);
        }
        if (this.resultSet == null) {
            return null;
        }
        try {
            if (this.resultSet.absolute(rowIndex + 1)) {
                return this.resultSet.getObject(columnIndex + 1);
            }
            this.resultSet.beforeFirst();
            this.resultSet.relative(rowIndex + 1);
            return this.resultSet.getObject(columnIndex + 1);
        }
        catch (SQLException exception) {
            return null;
        }
    }
}

