/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.database.swing.console.result;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.database.swing.console.result.ResultSetAdapter;
import net.anwiba.database.swing.console.result.ResultSetToRowConverter;

public class ResultSetMetaDataAdapter {
    private final int rowCount;
    private final int columnCount;
    private final List<String> columnNames;
    private final List<Class> columnClasses;
    private final List<String> columnTypeNames;
    private final List<Integer> columnTypes;

    public static ResultSetMetaDataAdapter create(ResultSetAdapter resultSetAdapter) {
        if (resultSetAdapter == null || resultSetAdapter == ResultSetAdapter.empty) {
            return new ResultSetMetaDataAdapter(0, List.of(), List.of(), List.of(), List.of());
        }
        return new ResultSetMetaDataAdapter(resultSetAdapter.getColumnCount(), resultSetAdapter.getColumnNames(), resultSetAdapter.getColumnClasses(), resultSetAdapter.getColumnTypeNames(), resultSetAdapter.getColumnTypes());
    }

    public static ResultSetMetaDataAdapter create(IObjectModel<String> statusModel, ResultSetMetaData metaData) {
        if (metaData == null) {
            return new ResultSetMetaDataAdapter(0, List.of(), List.of(), List.of(), List.of());
        }
        try {
            ArrayList<String> columnNames = new ArrayList<String>();
            ArrayList<Class> columnClasses = new ArrayList<Class>();
            ArrayList<Integer> columnTypes = new ArrayList<Integer>();
            ArrayList<String> columnTypeNames = new ArrayList<String>();
            int columnCount = metaData.getColumnCount();
            for (int i = 1; i < columnCount + 1; ++i) {
                columnNames.add(metaData.getColumnName(i));
                columnClasses.add(ResultSetMetaDataAdapter.getColumnClassForName(metaData.getColumnClassName(i)));
                columnTypes.add(metaData.getColumnType(i));
                columnTypeNames.add(metaData.getColumnTypeName(i));
            }
            return new ResultSetMetaDataAdapter(columnCount, columnNames, columnClasses, columnTypeNames, columnTypes);
        }
        catch (Exception exception) {
            statusModel.set((Object)exception.getMessage());
            return new ResultSetMetaDataAdapter(0, List.of(), List.of(), List.of(), List.of());
        }
    }

    protected static List<List<Object>> getRows(List<Integer> columnTypes, List<String> columnTypeNames, int columnCount, ResultSet set) throws SQLException {
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
        ResultSetToRowConverter converter = new ResultSetToRowConverter(columnTypes, columnTypeNames, columnCount);
        while (set.next()) {
            rows.add(converter.convert(set));
        }
        return rows;
    }

    private static Class<?> getColumnClassForName(String columnClassName) {
        try {
            return Class.forName(columnClassName);
        }
        catch (ClassNotFoundException exception) {
            return Object.class;
        }
    }

    public ResultSetMetaDataAdapter(int rowCount, List<String> columnNames, List<Class> columnClasses, List<String> columnTypeNames, List<Integer> columnTypes) {
        this.rowCount = rowCount;
        this.columnCount = 4;
        this.columnTypes = columnTypes;
        this.columnNames = columnNames;
        this.columnClasses = columnClasses;
        this.columnTypeNames = columnTypeNames;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public String getColumnName(int columnIndex) {
        return switch (columnIndex) {
            case 0 -> "column name";
            case 1 -> "type";
            case 2 -> "type name";
            case 3 -> "class";
            default -> null;
        };
    }

    public Class<?> getColumnClass(int columnIndex) {
        return switch (columnIndex) {
            case 0 -> String.class;
            case 1 -> Integer.class;
            case 2 -> String.class;
            case 3 -> Class.class;
            default -> Object.class;
        };
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return switch (columnIndex) {
            case 0 -> {
                if (rowIndex >= this.columnNames.size()) {
                    yield null;
                }
                yield this.columnNames.get(rowIndex);
            }
            case 1 -> {
                if (rowIndex >= this.columnTypes.size()) {
                    yield null;
                }
                yield this.columnTypes.get(rowIndex);
            }
            case 2 -> {
                if (rowIndex >= this.columnTypeNames.size()) {
                    yield null;
                }
                yield this.columnTypeNames.get(rowIndex);
            }
            case 3 -> {
                if (rowIndex >= this.columnClasses.size()) {
                    yield null;
                }
                yield this.columnClasses.get(rowIndex);
            }
            default -> null;
        };
    }
}

