/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.database.swing.console.result;

import java.io.IOException;
import java.io.Reader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.reference.utilities.IoUtilities;

public class ResultSetToRowConverter {
    private static ILogger logger = Logging.getLogger(ResultSetToRowConverter.class);
    private final List<Integer> readOrder = new ArrayList<Integer>();
    private final int count;
    private final List<Integer> types;
    private final List<String> typeNames;

    public ResultSetToRowConverter(List<Integer> types, List<String> typeNames, int count) {
        this.types = types;
        this.typeNames = typeNames;
        this.count = count;
        for (int i = 0; i < this.count; ++i) {
            if (types.get(i) == -1 && (Objects.equals(typeNames.get(i), "LONG") || Objects.equals(typeNames.get(i), "LONG RAW"))) {
                this.readOrder.add(0, i);
                continue;
            }
            this.readOrder.add(i);
        }
    }

    public List<Object> convert(ResultSet result) throws SQLException {
        int i;
        ArrayList<Object> row = new ArrayList<Object>(this.count);
        for (i = 0; i < this.count; ++i) {
            row.add(null);
        }
        for (i = 0; i < this.count; ++i) {
            String string;
            Reader reader;
            int index = this.readOrder.get(i);
            Integer typeCode = this.types.get(index);
            if (typeCode == -1) {
                if (Objects.equals(this.typeNames.get(index), "LONG RAW")) {
                    row.set(index, "Large binary object");
                    continue;
                }
                if (!Objects.equals(this.typeNames.get(index), "LONG")) continue;
                try {
                    reader = result.getCharacterStream(index + 1);
                    try {
                        if (reader == null) {
                            row.set(index, null);
                            continue;
                        }
                        string = IoUtilities.toString((Reader)reader, (int)1024);
                        row.set(index, string.length() == 1024 ? string + "..." : string);
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                }
                catch (IOException | SQLException exception) {
                    logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
                    row.set(index, null);
                }
                continue;
            }
            if (typeCode == 1111 && Objects.equals(this.typeNames.get(index), "raster")) {
                try {
                    reader = result.getCharacterStream(index + 1);
                    try {
                        if (reader == null) {
                            row.set(index, null);
                            continue;
                        }
                        string = IoUtilities.toString((Reader)reader, (int)1024);
                        row.set(index, string.length() == 1024 ? string + "..." : string);
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                }
                catch (IOException | SQLException exception) {
                    logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
                    row.set(index, null);
                }
                continue;
            }
            row.set(index, result.getObject(index + 1));
        }
        return row;
    }
}

