/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.database.swing.console.tree;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import net.anwiba.commons.jdbc.connection.IJdbcConnectionDescription;
import net.anwiba.commons.jdbc.name.IDatabaseColumnName;
import net.anwiba.commons.jdbc.name.IDatabaseConstraintName;
import net.anwiba.commons.jdbc.name.IDatabaseIndexName;
import net.anwiba.commons.jdbc.name.IDatabaseSchemaName;
import net.anwiba.commons.jdbc.name.IDatabaseSequenceName;
import net.anwiba.commons.jdbc.name.IDatabaseTableName;
import net.anwiba.commons.jdbc.name.IDatabaseTriggerName;
import net.anwiba.commons.swing.icons.gnome.contrast.high.ContrastHightIcons;
import net.anwiba.commons.swing.tree.ReloadableFolderTreeNode;

public final class DatabaseNamesTreeRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1L;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, this.getText(value, isLeaf, isExpanded), isSelected, isExpanded, isLeaf, row, hasFocus);
        this.setIcon(this.getIcon(value, isLeaf, isExpanded));
        this.setToolTipText(this.getToolTipText(value, isLeaf, isExpanded));
        return this;
    }

    private String getText(Object value, boolean isLeaf, boolean isExpanded) {
        if (value instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object userObject = node.getUserObject();
            if (userObject instanceof IJdbcConnectionDescription) {
                IJdbcConnectionDescription description = (IJdbcConnectionDescription)userObject;
                return description.getUrl();
            }
            if (userObject instanceof IDatabaseSchemaName) {
                IDatabaseSchemaName description = (IDatabaseSchemaName)userObject;
                return description.getSchemaName();
            }
            if (userObject instanceof IDatabaseTableName) {
                IDatabaseTableName description = (IDatabaseTableName)userObject;
                return description.getTableName();
            }
            if (userObject instanceof IDatabaseColumnName) {
                IDatabaseColumnName description = (IDatabaseColumnName)userObject;
                return description.getColumnName();
            }
            if (userObject instanceof IDatabaseSequenceName) {
                IDatabaseSequenceName description = (IDatabaseSequenceName)userObject;
                return description.getSequenceName();
            }
            if (userObject instanceof IDatabaseTriggerName) {
                IDatabaseTriggerName description = (IDatabaseTriggerName)userObject;
                return description.getTriggerName();
            }
            if (userObject instanceof IDatabaseIndexName) {
                IDatabaseIndexName description = (IDatabaseIndexName)userObject;
                return description.getIndexName();
            }
            if (userObject instanceof IDatabaseConstraintName) {
                IDatabaseConstraintName description = (IDatabaseConstraintName)userObject;
                return description.getConstraintName();
            }
            if (userObject != null) {
                return userObject.toString();
            }
            return "---";
        }
        return value.toString();
    }

    private String getToolTipText(Object value, boolean isLeaf, boolean isExpanded) {
        if (value instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object userObject = node.getUserObject();
            if (userObject instanceof IJdbcConnectionDescription) {
                IJdbcConnectionDescription description = (IJdbcConnectionDescription)userObject;
                return description.getUrl();
            }
            if (userObject instanceof IDatabaseTableName) {
                IDatabaseTableName description = (IDatabaseTableName)userObject;
                return description.getName();
            }
            if (userObject instanceof IDatabaseColumnName) {
                IDatabaseColumnName description = (IDatabaseColumnName)userObject;
                return description.getName();
            }
            if (userObject instanceof IDatabaseSequenceName) {
                IDatabaseSequenceName description = (IDatabaseSequenceName)userObject;
                return description.getName();
            }
            if (userObject instanceof IDatabaseTriggerName) {
                IDatabaseTriggerName description = (IDatabaseTriggerName)userObject;
                return description.getName();
            }
            if (userObject instanceof IDatabaseIndexName) {
                IDatabaseIndexName description = (IDatabaseIndexName)userObject;
                return description.getName();
            }
            if (userObject instanceof IDatabaseConstraintName) {
                IDatabaseConstraintName description = (IDatabaseConstraintName)userObject;
                return description.getName();
            }
            if (userObject != null) {
                return userObject.toString();
            }
            return "---";
        }
        return value.toString();
    }

    private Icon getIcon(Object value, boolean isLeaf, boolean isExpanded) {
        Object node;
        if (value instanceof ReloadableFolderTreeNode) {
            node = (ReloadableFolderTreeNode)value;
            if (node.isLoading()) {
                return ContrastHightIcons.EMBLEM_SYNCHRONIZING.getSmallIcon();
            }
            if (!node.isInitialized()) {
                return ContrastHightIcons.FOLDER_VISITING.getSmallIcon();
            }
        }
        if (value instanceof DefaultMutableTreeNode) {
            node = (DefaultMutableTreeNode)value;
            Object userObject = ((DefaultMutableTreeNode)node).getUserObject();
            if (userObject instanceof IJdbcConnectionDescription) {
                IJdbcConnectionDescription description = (IJdbcConnectionDescription)userObject;
                return ContrastHightIcons.DATABASE.getSmallIcon();
            }
            if (userObject instanceof IDatabaseTableName) {
                return ContrastHightIcons.VIEW_LIST_TEXT.getSmallIcon();
            }
            if (userObject instanceof IDatabaseColumnName) {
                return ContrastHightIcons.LIST_REMOVE.getSmallIcon();
            }
            if (userObject instanceof IDatabaseSequenceName) {
                return ContrastHightIcons.IMAGE_LOADING.getSmallIcon();
            }
            if (userObject instanceof IDatabaseTriggerName) {
                return ContrastHightIcons.RADIO_CHECKED.getSmallIcon();
            }
            if (userObject instanceof IDatabaseIndexName) {
                return ContrastHightIcons.VIEW_LIST_TREE.getSmallIcon();
            }
            if (userObject instanceof IDatabaseConstraintName) {
                return ContrastHightIcons.TASQUE.getSmallIcon();
            }
        }
        return this.getIcon(isLeaf, isExpanded);
    }

    private Icon getIcon(boolean isLeaf, boolean isExpanded) {
        if (!isLeaf) {
            if (isExpanded) {
                return ContrastHightIcons.FOLDER_OPEN.getSmallIcon();
            }
            return ContrastHightIcons.FOLDER.getSmallIcon();
        }
        return ContrastHightIcons.FOLDER_DOCUMENTS.getSmallIcon();
    }
}

