/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.database.swing.console.tree;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import net.anwiba.commons.jdbc.connection.IDatabaseConnector;
import net.anwiba.commons.jdbc.connection.IJdbcConnectionDescription;
import net.anwiba.commons.jdbc.database.IDatabaseFacade;
import net.anwiba.commons.jdbc.database.INamedTableFilter;
import net.anwiba.commons.jdbc.name.DatabaseSchemaName;
import net.anwiba.commons.jdbc.name.IDatabaseColumnName;
import net.anwiba.commons.jdbc.name.IDatabaseConstraintName;
import net.anwiba.commons.jdbc.name.IDatabaseIndexName;
import net.anwiba.commons.jdbc.name.IDatabaseSchemaName;
import net.anwiba.commons.jdbc.name.IDatabaseSequenceName;
import net.anwiba.commons.jdbc.name.IDatabaseTableName;
import net.anwiba.commons.jdbc.name.IDatabaseTriggerName;
import net.anwiba.commons.jdbc.name.IDatabaseViewName;
import net.anwiba.commons.lang.exception.CanceledException;
import net.anwiba.commons.lang.functional.IFunction;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.swing.tree.ReloadableFolderTreeNode;
import net.anwiba.commons.thread.cancel.ICanceler;
import net.anwiba.database.swing.console.SqlConsoleMessages;

public final class SchemaTreeFactory {
    private static ILogger logger = Logging.getLogger(SchemaTreeFactory.class);
    private final IDatabaseFacade databaseFacade;
    private final IObjectModel<String> statusModel;
    private final IDatabaseConnector databaseConnector;

    public SchemaTreeFactory(IDatabaseConnector databaseConnector, IDatabaseFacade databaseFacade, IObjectModel<String> statusModel) {
        this.databaseConnector = databaseConnector;
        this.databaseFacade = databaseFacade;
        this.statusModel = statusModel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DefaultMutableTreeNode create(ICanceler canceler, IJdbcConnectionDescription description, String schema) throws CanceledException {
        this.statusModel.set((Object)SqlConsoleMessages.working);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(description);
        try (Connection connection = this.databaseConnector.connectReadOnly(description);){
            String catalog = this.getCatalog(connection);
            LinkedHashMap<String, DefaultMutableTreeNode> schemas = new LinkedHashMap<String, DefaultMutableTreeNode>();
            if (schema != null) {
                this.addSchema(description, (IDatabaseSchemaName)new DatabaseSchemaName(catalog, schema), schemas, root);
            } else {
                if (canceler.isCanceled()) {
                    DefaultMutableTreeNode defaultMutableTreeNode = null;
                    return defaultMutableTreeNode;
                }
                LinkedHashSet schemaNames = new LinkedHashSet(this.databaseFacade.getSchemaNames(canceler, connection, catalog));
                for (IDatabaseSchemaName schemaName : schemaNames) {
                    this.addSchema(description, schemaName, schemas, root);
                }
            }
            if (schemas.isEmpty()) {
                this.addSchema(description, (IDatabaseSchemaName)new DatabaseSchemaName(catalog, schema), schemas, root);
            }
            this.statusModel.set((Object)SqlConsoleMessages.done);
            DefaultMutableTreeNode defaultMutableTreeNode = root;
            return defaultMutableTreeNode;
        }
        catch (SQLException exception) {
            logger.debug(exception.getMessage(), (Throwable)exception);
            this.statusModel.set((Object)exception.getMessage());
            return root;
        }
    }

    private void addSchema(IJdbcConnectionDescription description, IDatabaseSchemaName schemaName, Map<String, DefaultMutableTreeNode> schemas, DefaultMutableTreeNode root) {
        DefaultMutableTreeNode schemaNode = schemaName.getSchemaName() == null ? root : new DefaultMutableTreeNode(schemaName);
        schemaNode.add((MutableTreeNode)this.createTablesNode(description, schemaName));
        schemaNode.add((MutableTreeNode)this.createViewsNode(description, schemaName));
        if (this.databaseFacade.supportsSequences()) {
            schemaNode.add((MutableTreeNode)this.createSequencesNode(description, schemaName));
        }
        for (INamedTableFilter filter : this.databaseFacade.getTableFilters()) {
            schemaNode.add((MutableTreeNode)this.createOtherNodes(description, schemaName, filter));
        }
        if (root != schemaNode) {
            root.add(schemaNode);
        }
        schemas.put(schemaName.getSchemaName(), schemaNode);
    }

    private ReloadableFolderTreeNode<Object> createSequencesNode(IJdbcConnectionDescription description, IDatabaseSchemaName schemaName) {
        return new ReloadableFolderTreeNode(value -> this.execute(description, (IFunction<Connection, List<DefaultMutableTreeNode>, SQLException>)((IFunction)connection -> {
            try {
                List sequences = this.databaseFacade.getSequences(ICanceler.DummyCanceler, connection, schemaName);
                ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
                for (IDatabaseSequenceName sequence : sequences) {
                    nodes.add(new DefaultMutableTreeNode(sequence));
                }
                this.statusModel.set((Object)SqlConsoleMessages.done);
                return nodes;
            }
            catch (CanceledException exception) {
                return List.of();
            }
        })), (Object)SqlConsoleMessages.sequences);
    }

    private ReloadableFolderTreeNode<Object> createViewsNode(IJdbcConnectionDescription description, IDatabaseSchemaName schemaName) {
        return new ReloadableFolderTreeNode(value -> this.execute(description, (IFunction<Connection, List<DefaultMutableTreeNode>, SQLException>)((IFunction)connection -> {
            try {
                List<IDatabaseViewName> viewNames = this.getViewNames(ICanceler.DummyCanceler, (Connection)connection, schemaName);
                ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
                for (IDatabaseViewName view : viewNames) {
                    if (!this.databaseFacade.isView((IDatabaseTableName)view)) continue;
                    DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode(view);
                    tableNode.add(this.createViewColumnsNode(description, view));
                    nodes.add(tableNode);
                }
                return nodes;
            }
            catch (CanceledException exception) {
                return List.of();
            }
        })), (Object)SqlConsoleMessages.views);
    }

    private ReloadableFolderTreeNode<Object> createTablesNode(IJdbcConnectionDescription description, IDatabaseSchemaName schemaName) {
        return new ReloadableFolderTreeNode(value -> this.execute(description, (IFunction<Connection, List<DefaultMutableTreeNode>, SQLException>)((IFunction)connection -> {
            try {
                List<IDatabaseTableName> tableNames = this.getTableNames(ICanceler.DummyCanceler, (Connection)connection, schemaName);
                ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
                for (IDatabaseTableName table : tableNames) {
                    if (!this.databaseFacade.isTable(table)) continue;
                    DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode(table);
                    tableNode.add(this.createTableColumnsNode(description, table));
                    if (this.databaseFacade.supportsConstaints()) {
                        tableNode.add(this.createConstraintsNode(description, table));
                    }
                    tableNode.add(this.createIndiciesNode(description, table));
                    if (this.databaseFacade.supportsTrigger()) {
                        tableNode.add(this.createTriggersNode(description, table));
                    }
                    nodes.add(tableNode);
                }
                return nodes;
            }
            catch (CanceledException exception) {
                return List.of();
            }
        })), (Object)SqlConsoleMessages.tables);
    }

    private List<IDatabaseTableName> getTableNames(ICanceler canceler, Connection connection, IDatabaseSchemaName schemaName) throws SQLException, CanceledException {
        return this.databaseFacade.getTables(canceler, connection, schemaName);
    }

    private List<IDatabaseViewName> getViewNames(ICanceler canceler, Connection connection, IDatabaseSchemaName schemaName) throws SQLException, CanceledException {
        return this.databaseFacade.getViews(canceler, connection, schemaName);
    }

    private ReloadableFolderTreeNode<Object> createOtherNodes(IJdbcConnectionDescription description, IDatabaseSchemaName schemaName, INamedTableFilter filter) {
        return new ReloadableFolderTreeNode(value -> this.execute(description, (IFunction<Connection, List<DefaultMutableTreeNode>, SQLException>)((IFunction)connection -> {
            try {
                List<IDatabaseTableName> tableNames = this.getTableNames(ICanceler.DummyCanceler, (Connection)connection, schemaName);
                ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
                for (IDatabaseTableName table : tableNames) {
                    if (!filter.accept(table)) continue;
                    DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode(table);
                    tableNode.add(this.createTableColumnsNode(description, table));
                    if (this.databaseFacade.supportsConstaints()) {
                        tableNode.add(this.createConstraintsNode(description, table));
                    }
                    tableNode.add(this.createIndiciesNode(description, table));
                    if (this.databaseFacade.supportsTrigger()) {
                        tableNode.add(this.createTriggersNode(description, table));
                    }
                    nodes.add(tableNode);
                }
                return nodes;
            }
            catch (CanceledException exception) {
                return List.of();
            }
        })), (Object)filter.getName());
    }

    private MutableTreeNode createIndiciesNode(IJdbcConnectionDescription description, IDatabaseTableName table) {
        return new ReloadableFolderTreeNode(value -> this.execute(description, (IFunction<Connection, List<DefaultMutableTreeNode>, SQLException>)((IFunction)connection -> {
            try {
                List names = this.databaseFacade.getIndicies(ICanceler.DummyCanceler, connection, table);
                ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
                for (IDatabaseIndexName name : names) {
                    nodes.add(new DefaultMutableTreeNode(name));
                }
                return nodes;
            }
            catch (CanceledException exception) {
                return List.of();
            }
        })), (Object)SqlConsoleMessages.indicies);
    }

    private MutableTreeNode createTriggersNode(IJdbcConnectionDescription description, IDatabaseTableName table) {
        return new ReloadableFolderTreeNode(value -> this.execute(description, (IFunction<Connection, List<DefaultMutableTreeNode>, SQLException>)((IFunction)connection -> {
            try {
                List names = this.databaseFacade.getTriggers(ICanceler.DummyCanceler, connection, table);
                ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
                for (IDatabaseTriggerName name : names) {
                    nodes.add(new DefaultMutableTreeNode(name));
                }
                return nodes;
            }
            catch (CanceledException exception) {
                return List.of();
            }
        })), (Object)SqlConsoleMessages.triggers);
    }

    private MutableTreeNode createTableColumnsNode(IJdbcConnectionDescription description, IDatabaseTableName table) {
        return new ReloadableFolderTreeNode(value -> this.execute(description, (IFunction<Connection, List<DefaultMutableTreeNode>, SQLException>)((IFunction)connection -> {
            try {
                ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
                List names = this.databaseFacade.getTableColumns(ICanceler.DummyCanceler, connection, table);
                for (IDatabaseColumnName name : names) {
                    nodes.add(new DefaultMutableTreeNode(name));
                }
                return nodes;
            }
            catch (CanceledException exception) {
                return List.of();
            }
        })), (Object)SqlConsoleMessages.columns);
    }

    private MutableTreeNode createViewColumnsNode(IJdbcConnectionDescription description, IDatabaseViewName view) {
        return new ReloadableFolderTreeNode(value -> this.execute(description, (IFunction<Connection, List<DefaultMutableTreeNode>, SQLException>)((IFunction)connection -> {
            try {
                ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
                List names = this.databaseFacade.getViewColumns(ICanceler.DummyCanceler, connection, view);
                for (IDatabaseColumnName name : names) {
                    nodes.add(new DefaultMutableTreeNode(name));
                }
                return nodes;
            }
            catch (CanceledException exception) {
                return List.of();
            }
        })), (Object)SqlConsoleMessages.columns);
    }

    private MutableTreeNode createConstraintsNode(IJdbcConnectionDescription description, IDatabaseTableName tableName) {
        return new ReloadableFolderTreeNode(value -> this.execute(description, (IFunction<Connection, List<DefaultMutableTreeNode>, SQLException>)((IFunction)connection -> {
            try {
                List names = this.databaseFacade.getConstraints(ICanceler.DummyCanceler, connection, tableName);
                ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
                for (IDatabaseConstraintName name : names) {
                    nodes.add(new DefaultMutableTreeNode(name));
                }
                return nodes;
            }
            catch (CanceledException exception) {
                return List.of();
            }
        })), (Object)SqlConsoleMessages.constraints);
    }

    private List<DefaultMutableTreeNode> execute(IJdbcConnectionDescription description, IFunction<Connection, List<DefaultMutableTreeNode>, SQLException> function) {
        List list;
        block8: {
            this.statusModel.set((Object)SqlConsoleMessages.working);
            Connection connection = this.databaseConnector.connectReadOnly(description);
            try {
                List nodes = (List)function.execute((Object)connection);
                this.statusModel.set((Object)SqlConsoleMessages.done);
                list = nodes;
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    logger.debug(exception.getMessage(), (Throwable)exception);
                    this.statusModel.set((Object)exception.getMessage());
                    return Collections.emptyList();
                }
            }
            connection.close();
        }
        return list;
    }

    private String getCatalog(Connection connection) throws SQLException {
        return connection.getCatalog();
    }
}

