/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.eclipse.utilities;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.IPackagesViewPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbenchPart;

public class JavaProjectUtilities {
    public static IJavaProject[] getJavaProjects(IWorkbenchPart part, ISelection selection) {
        if (part instanceof IEditorPart) {
            return JavaProjectUtilities.getJavaProjects((IEditorPart)part);
        }
        if (part instanceof IPackagesViewPart) {
            return JavaProjectUtilities.getJavaProjects((ITreeSelection)selection);
        }
        return new IJavaProject[0];
    }

    public static IJavaProject[] getJavaProjects(IEditorPart part) {
        IPathEditorInput pathEditorInput;
        IJavaProject javaProject;
        if (part == null || part.getEditorInput() == null) {
            return new IJavaProject[0];
        }
        IEditorInput editorInput = part.getEditorInput();
        if (editorInput instanceof IPathEditorInput && (javaProject = JavaProjectUtilities.getJavaProject((pathEditorInput = (IPathEditorInput)editorInput).getPath())) != null && javaProject.exists()) {
            return new IJavaProject[]{javaProject};
        }
        IJavaElement element = (IJavaElement)editorInput.getAdapter(IJavaElement.class);
        if (element == null) {
            return new IJavaProject[0];
        }
        return new IJavaProject[]{element.getJavaProject()};
    }

    public static IJavaProject getJavaProject(IPath path) {
        IJavaProject[] javaProjects;
        IJavaProject[] iJavaProjectArray = javaProjects = JavaProjectUtilities.getJavaProjects();
        int n = javaProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject javaProject = iJavaProjectArray[n2];
            IPath fullPath = javaProject.getProject().getFullPath();
            if (fullPath.equals((Object)path)) {
                return javaProject;
            }
            ++n2;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IContainer container = root.getContainerForLocation(path);
        if (container != null) {
            return JavaProjectUtilities.getJavaProject(container);
        }
        container = root.getContainerForLocation(root.getLocation().append(path));
        return JavaProjectUtilities.getJavaProject(container);
    }

    private static IJavaProject getJavaProject(IContainer container) {
        if (container != null) {
            if (container instanceof IProject) {
                IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
                return model.getJavaProject(container.getName());
            }
            return JavaProjectUtilities.getJavaProject(container.getParent());
        }
        return null;
    }

    public static IJavaProject[] getJavaProjects() {
        return JavaProjectUtilities.getJavaProjects(JavaProjectUtilities.getProjects());
    }

    public static IProject[] getProjects() {
        return ResourcesPlugin.getWorkspace().getRoot().getProjects();
    }

    private static IJavaProject[] getJavaProjects(IProject[] projects) {
        ArrayList<IJavaProject> javaProjects = new ArrayList<IJavaProject>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            IJavaProject javaProject = JavaProjectUtilities.getJavaProject((IContainer)project);
            if (javaProject != null) {
                javaProjects.add(javaProject);
            }
            ++n2;
        }
        return javaProjects.toArray(new IJavaProject[javaProjects.size()]);
    }

    public static IJavaProject[] getJavaProjects(ITreeSelection treeSelection) {
        TreePath[] paths;
        if (treeSelection == null) {
            return new IJavaProject[0];
        }
        ArrayList<IJavaProject> projects = new ArrayList<IJavaProject>();
        TreePath[] treePathArray = paths = treeSelection.getPaths();
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath treePath = treePathArray[n2];
            if (!treePath.equals((Object)TreePath.EMPTY)) {
                int i = 0;
                while (i < treePath.getSegmentCount()) {
                    Object segment = treePath.getSegment(i);
                    if (segment instanceof IJavaProject) {
                        projects.add((IJavaProject)segment);
                        break;
                    }
                    ++i;
                }
            }
            ++n2;
        }
        return projects.toArray(new IJavaProject[projects.size()]);
    }

    public static IJavaElement[] getJavaElements(IWorkbenchPart part, ISelection selection) {
        if (part instanceof IPackagesViewPart) {
            return JavaProjectUtilities.getJavaElements((ITreeSelection)selection);
        }
        return new IJavaElement[0];
    }

    public static IJavaElement[] getJavaElements(ITreeSelection selection) {
        if (selection == null) {
            return new IJavaProject[0];
        }
        ArrayList<IJavaElement> projects = new ArrayList<IJavaElement>();
        TreePath[] treePathArray = selection.getPaths();
        int n = treePathArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object lastSegment;
            TreePath treePath = treePathArray[n2];
            if (!treePath.equals((Object)TreePath.EMPTY) && (lastSegment = treePath.getLastSegment()) instanceof IJavaElement) {
                projects.add((IJavaElement)lastSegment);
            }
            ++n2;
        }
        return projects.toArray(new IJavaElement[projects.size()]);
    }
}

