/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.eclipse.icons.io;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.anwiba.commons.eclipse.utilities.JavaProjectUtilities;
import net.anwiba.eclipse.icons.io.IconContext;
import net.anwiba.tools.icons.configuration.GuiIconConfigurationsReader;
import net.anwiba.tools.icons.configuration.IImageExistsValidator;
import net.anwiba.tools.icons.configuration.IOutput;
import net.anwiba.tools.icons.configuration.IconResource;
import net.anwiba.tools.icons.configuration.ImageExistsValidator;
import net.anwiba.tools.icons.configuration.generated.Class;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;

public class IconConfigurationReader {
    private static final String RESOURCES_PATH_SEGMENT = "resources";
    private static final String ICONS_FILE_NAME = "icons.xml";
    private static final String ICONS_PATH_SEGMENT = "icons";

    public Map<Class, List<IconContext>> read(IJavaProject ... projects) throws IOException {
        HashMap<Class, List<IconContext>> iconConfigurations = new HashMap<Class, List<IconContext>>();
        HashSet<IJavaProject> visited = new HashSet<IJavaProject>();
        IJavaProject[] iJavaProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject project = iJavaProjectArray[n2];
            iconConfigurations.putAll(this.read(visited, project));
            ++n2;
        }
        return iconConfigurations;
    }

    private Map<Class, List<IconContext>> read(Set<IJavaProject> visited, IJavaProject project) throws IOException {
        if (visited.contains(project)) {
            return new HashMap<Class, List<IconContext>>();
        }
        visited.add(project);
        HashMap<Class, List<IconContext>> iconConfigurations = new HashMap<Class, List<IconContext>>();
        try {
            IClasspathEntry[] classpathEntries;
            IClasspathEntry[] iClasspathEntryArray = classpathEntries = project.getResolvedClasspath(true);
            int n = classpathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                File iconsPath;
                File iconsFile;
                IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
                if (classpathEntry.getEntryKind() == 2) {
                    IJavaProject javaProject = JavaProjectUtilities.getJavaProject((IPath)classpathEntry.getPath());
                    if (javaProject != null && javaProject.exists()) {
                        iconConfigurations.putAll(this.read(visited, javaProject));
                    }
                } else if (classpathEntry.getEntryKind() == 3 && classpathEntry.getPath().lastSegment().equals(RESOURCES_PATH_SEGMENT) && (iconsFile = new File(iconsPath = this.getIconsPath(project, classpathEntry), ICONS_FILE_NAME)).exists()) {
                    IOutput output = new IOutput(){

                        public void warn(String message) {
                        }

                        public void info(String message) {
                        }

                        public void error(String message, Throwable throwable) {
                        }

                        public void error(String message) {
                        }
                    };
                    ArrayList resources = new ArrayList();
                    ImageExistsValidator imageExistsValidator = new ImageExistsValidator(resources, output);
                    GuiIconConfigurationsReader reader = new GuiIconConfigurationsReader((IImageExistsValidator)imageExistsValidator, output);
                    reader.add(iconsFile);
                    Class clazz = reader.getClazz();
                    Map configurations = reader.getIconConfigurations();
                    ArrayList<IconContext> iconContexts = new ArrayList<IconContext>();
                    reader.getFolders();
                    for (IconResource entry : configurations.values()) {
                        iconContexts.add(new IconContext(project.getElementName(), iconsPath, entry));
                    }
                    iconConfigurations.put(clazz, iconContexts);
                }
                ++n2;
            }
            return iconConfigurations;
        }
        catch (JavaModelException exception) {
            throw new IOException(exception);
        }
    }

    private File getIconsPath(IJavaProject javaProject, IClasspathEntry classpathEntry) {
        URI locationURI = javaProject.getProject().getLocationURI();
        boolean isMavenPomDerived = this.isMavenPomDerived(classpathEntry);
        IPath path = classpathEntry.getPath();
        if (isMavenPomDerived) {
            String osString = isMavenPomDerived ? path.makeRelativeTo(path.uptoSegment(1)).toString() : path.toOSString();
            File basePath = new File(new File(locationURI), osString);
            return new File(basePath, ICONS_PATH_SEGMENT);
        }
        String osString = isMavenPomDerived ? path.makeRelativeTo(path.uptoSegment(1)).toString() : path.toOSString();
        File basePath = new File(new File(locationURI).getParentFile(), osString);
        return new File(basePath, ICONS_PATH_SEGMENT);
    }

    private boolean isMavenPomDerived(IClasspathEntry classpathEntry) {
        IClasspathAttribute[] iClasspathAttributeArray = classpathEntry.getExtraAttributes();
        int n = iClasspathAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathAttribute classpathAttribute = iClasspathAttributeArray[n2];
            if (Objects.equals(classpathAttribute.getName(), "maven.pomderived")) {
                return Objects.equals(classpathAttribute.getValue(), "true");
            }
            ++n2;
        }
        return false;
    }
}

