/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.eclipse.icons.view.action;

import java.text.MessageFormat;
import net.anwiba.commons.lang.object.IObjectText;
import net.anwiba.eclipse.icons.description.IGuiIconDescription;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class CopyAction
extends Action {
    private final Display display;
    private final IObjectText<IGuiIconDescription> descriptionText = new IObjectText<IGuiIconDescription>(){

        public String getText(IGuiIconDescription description) {
            return description == null ? "" : MessageFormat.format("{0}.{1}", description.getConstant().getClassName(), description.getConstant().getConstantName());
        }
    };
    private final ISelectionProvider selectionProvider;

    public CopyAction(Display display, ISelectionProvider selectionProvider) {
        this.display = display;
        this.selectionProvider = selectionProvider;
        this.setToolTipText("Copy");
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        selectionProvider.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CopyAction.this.setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.setEnabled(!selectionProvider.getSelection().isEmpty());
    }

    public void run() {
        IGuiIconDescription description = this.getGuiIconDescription();
        Clipboard clipboard = new Clipboard(this.display);
        TextTransfer textTransfer = TextTransfer.getInstance();
        clipboard.setContents(new Object[]{this.descriptionText.getText((Object)description)}, new Transfer[]{textTransfer});
    }

    private IGuiIconDescription getGuiIconDescription() {
        return (IGuiIconDescription)((IStructuredSelection)this.selectionProvider.getSelection()).getFirstElement();
    }
}

