/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.eclipse.icons.description;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.anwiba.commons.thread.cancel.ICanceler;
import net.anwiba.eclipse.icons.description.Constant;
import net.anwiba.eclipse.icons.description.GuiIconDescriptionFactory;
import net.anwiba.eclipse.icons.description.IConstant;
import net.anwiba.eclipse.icons.description.IGuiIconDescription;
import net.anwiba.eclipse.icons.io.IconContext;
import net.anwiba.tools.icons.configuration.generated.Class;
import org.eclipse.swt.graphics.Device;

public final class GuiIconDescriptionsFactory {
    private final Device device;

    public GuiIconDescriptionsFactory(Device device) {
        this.device = device;
    }

    public List<IGuiIconDescription> create(ICanceler canceler, Map<Class, List<IconContext>> configurations) {
        ArrayList<IGuiIconDescription> descriptions = new ArrayList<IGuiIconDescription>();
        HashMap<IConstant, IconContext> map = new HashMap<IConstant, IconContext>();
        for (Map.Entry<Class, List<IconContext>> entry : configurations.entrySet()) {
            if (canceler.isCanceled()) {
                return new ArrayList<IGuiIconDescription>();
            }
            Class clazz = entry.getKey();
            for (IconContext iconContext : entry.getValue()) {
                map.put(new Constant(clazz.getPackage(), clazz.getName(), iconContext.getResource().getName()), iconContext);
            }
        }
        GuiIconDescriptionFactory factory = new GuiIconDescriptionFactory(this.device);
        for (Map.Entry<Class, List<IconContext>> entry : configurations.entrySet()) {
            Class clazz = entry.getKey();
            for (IconContext iconContext : entry.getValue()) {
                IGuiIconDescription description;
                if (canceler.isCanceled()) {
                    return new ArrayList<IGuiIconDescription>();
                }
                if (this.isRefernced(iconContext)) {
                    IGuiIconDescription description2;
                    HashSet<IConstant> set = new HashSet<IConstant>();
                    Constant constant = new Constant(clazz.getPackage(), clazz.getName(), iconContext.getResource().getName());
                    set.add(constant);
                    IconContext referenzedContext = this.getReferenzedIconContext(map, constant, iconContext, set);
                    if (referenzedContext == null || (description2 = factory.create(clazz, iconContext, referenzedContext)) == null) continue;
                    descriptions.add(description2);
                    continue;
                }
                if (iconContext.getResource().getImage() == null || (description = factory.create(clazz, iconContext)) == null) continue;
                descriptions.add(description);
            }
        }
        return descriptions;
    }

    private IconContext getReferenzedIconContext(Map<IConstant, IconContext> map, IConstant constant, IconContext context, HashSet<IConstant> set) {
        IConstant referenzedConstant = this.getReferenzedConstant(constant, context);
        IconContext referencedContext = map.get(referenzedConstant);
        if (referencedContext == null || !this.isRefernced(context)) {
            return context;
        }
        if (set.contains(referenzedConstant)) {
            return null;
        }
        set.add(referenzedConstant);
        return this.getReferenzedIconContext(map, referenzedConstant, referencedContext, set);
    }

    private IConstant getReferenzedConstant(IConstant constant, IconContext context) {
        String reference;
        System.out.println(MessageFormat.format("{0}.{1}.{2}", constant.getPackageName(), constant.getClassName(), constant.getConstantName()));
        Class referencedClass = context.getResource().getClazz();
        String string = reference = context.getResource().getReference() == null ? context.getResource().getName() : context.getResource().getReference();
        if (referencedClass == null || constant.equals(referencedClass)) {
            return new Constant(constant.getPackageName(), constant.getClassName(), reference);
        }
        return new Constant(referencedClass.getPackage(), referencedClass.getName(), reference);
    }

    private boolean isRefernced(IconContext iconContext) {
        return iconContext.getResource().getReference() != null || iconContext.getResource().getImage() == null;
    }
}

