/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.eclipse.icons.runner;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.anwiba.commons.process.cancel.ICanceler;
import net.anwiba.eclipse.icons.description.GuiIconDescriptionsFactory;
import net.anwiba.eclipse.icons.description.IGuiIconDescription;
import net.anwiba.eclipse.icons.io.IconConfigurationReader;
import net.anwiba.eclipse.icons.io.IconContext;
import net.anwiba.tools.icons.configuration.generated.Class;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Device;

public final class UpdateRunner
implements IRunnableWithProgress {
    private final IconConfigurationReader reader = new IconConfigurationReader();
    private final WritableList<IGuiIconDescription> descriptions;
    private final Device device;
    private final ICanceler canceler;
    private final IJavaProject[] projects;

    public UpdateRunner(ICanceler canceler, Device device, WritableList<IGuiIconDescription> descriptions, IJavaProject ... projects) {
        this.device = device;
        this.descriptions = descriptions;
        this.projects = projects;
        this.canceler = canceler;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask("GuiIcons update", -1);
            List<IGuiIconDescription> iconDescriptions = this.read(this.projects);
            if (this.canceler.isCanceled()) {
                return;
            }
            if (iconDescriptions.size() == this.descriptions.size() && iconDescriptions.containsAll((Collection<?>)this.descriptions)) {
                return;
            }
            try {
                this.clear();
                this.descriptions.addAll(iconDescriptions);
            }
            catch (IOException exception) {
                throw new InvocationTargetException(exception);
            }
        }
        finally {
            monitor.done();
        }
    }

    private void clear() {
        IGuiIconDescription[] array = (IGuiIconDescription[])this.descriptions.toArray((Object[])new IGuiIconDescription[this.descriptions.size()]);
        this.descriptions.clear();
        IGuiIconDescription[] iGuiIconDescriptionArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            IGuiIconDescription description = iGuiIconDescriptionArray[n2];
            description.dispose();
            ++n2;
        }
    }

    private List<IGuiIconDescription> read(IJavaProject ... projects) throws IOException {
        ArrayList<IGuiIconDescription> descriptions = new ArrayList<IGuiIconDescription>();
        IJavaProject[] iJavaProjectArray = projects;
        if (projects.length != 0) {
            IJavaProject project = iJavaProjectArray[0];
            Map<Class, List<IconContext>> configurations = this.reader.read(project);
            return new GuiIconDescriptionsFactory(this.device).create(this.canceler, configurations);
        }
        return descriptions;
    }
}

