/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.eclipse.icons.table;

import java.text.MessageFormat;
import net.anwiba.eclipse.icons.description.IConstant;
import net.anwiba.eclipse.icons.description.IGuiIconDescription;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public final class TableLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public Image getImage(Object element) {
        if (element == null) {
            return null;
        }
        IGuiIconDescription description = (IGuiIconDescription)element;
        return description.getImage();
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element == null) {
            return null;
        }
        IGuiIconDescription description = (IGuiIconDescription)element;
        IConstant constant = description.getConstant();
        switch (columnIndex) {
            case 0: {
                return null;
            }
            case 1: {
                return constant.getConstantName();
            }
            case 2: {
                return description.getSmallIcon() != null ? "yes" : "no";
            }
            case 3: {
                return description.getMediumIcon() != null ? "yes" : "no";
            }
            case 4: {
                return description.getLargeIcon() != null ? "yes" : "no";
            }
            case 5: {
                return description.getSource();
            }
            case 6: {
                return MessageFormat.format("{0}.{1}", constant.getPackageName(), constant.getClassName());
            }
        }
        return null;
    }

    public String getText(Object element) {
        if (element == null) {
            return null;
        }
        IGuiIconDescription description = (IGuiIconDescription)element;
        IConstant constant = description.getConstant();
        return MessageFormat.format("{0}.{1}.{2}", constant.getPackageName(), constant.getClassName(), constant.getConstantName());
    }
}

