/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.eclipse.icons.table;

import net.anwiba.commons.model.IChangeableObjectListener;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.eclipse.icons.description.IGuiIconDescription;
import net.anwiba.eclipse.icons.table.ColumnSelectionListener;
import net.anwiba.eclipse.icons.table.TableCellLabelProvider;
import net.anwiba.eclipse.icons.table.TableLabelProvider;
import net.anwiba.eclipse.icons.table.TableViewerSorter;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableViewerFactory {
    private void createColumns(TableViewer tableViewer) {
        String[] titles = new String[]{"Icon", "Name", "Small", "Medium", "Large", "Source", "Class"};
        int[] bounds = new int[]{40, 200, 60, 60, 60, 200, 200};
        int i = 0;
        while (i < titles.length) {
            TableViewerColumn viewerColumn = new TableViewerColumn(tableViewer, 0);
            tableViewer.setSorter((ViewerSorter)new TableViewerSorter(titles));
            viewerColumn.setLabelProvider((CellLabelProvider)new TableCellLabelProvider());
            TableColumn column = viewerColumn.getColumn();
            column.addSelectionListener((SelectionListener)new ColumnSelectionListener(column, tableViewer));
            column.setText(titles[i]);
            column.setWidth(bounds[i]);
            column.setResizable(true);
            column.setMoveable(false);
            ++i;
        }
        Table table = tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer, (int)1);
    }

    public TableViewer createTable(Composite parent, WritableList<IGuiIconDescription> descriptions, final IObjectModel<String> searchStringModel) {
        final GuiIconDescriptionViewerFilter viewerFilter = new GuiIconDescriptionViewerFilter();
        final TableViewer table = new TableViewer(parent, 66308);
        this.createColumns(table);
        table.getTable().setLayoutData((Object)new GridData(1808));
        table.setContentProvider((IContentProvider)new ObservableListContentProvider());
        table.setInput(descriptions);
        table.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        table.setFilters(new ViewerFilter[]{viewerFilter});
        searchStringModel.addChangeListener(new IChangeableObjectListener(){

            public void objectChanged() {
                viewerFilter.setSearchText((String)searchStringModel.get());
                table.refresh();
            }
        });
        return table;
    }

    private final class GuiIconDescriptionViewerFilter
    extends ViewerFilter {
        private boolean isActive = false;
        private String searchText = null;

        private GuiIconDescriptionViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!this.isActive) {
                return true;
            }
            IGuiIconDescription description = (IGuiIconDescription)element;
            return description.getConstant().getConstantName().toLowerCase().contains(this.searchText.toLowerCase());
        }

        public void setSearchText(String searchText) {
            this.isActive = !StringUtilities.isNullOrTrimmedEmpty((String)searchText);
            this.searchText = searchText;
        }
    }
}

