/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.eclipse.icons.table;

import java.io.File;
import net.anwiba.eclipse.icons.description.IGuiIconDescription;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public final class TableViewerSorter
extends ViewerSorter {
    private final String[] titles;

    public TableViewerSorter(String[] titles) {
        this.titles = titles;
    }

    public int compare(Viewer viewer, Object object, Object other) {
        TableViewer tableViewer = (TableViewer)viewer;
        Table table = tableViewer.getTable();
        int sortDirection = table.getSortDirection();
        if (sortDirection == 0) {
            return 1;
        }
        if (object == null && other == null) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (other == null) {
            return 1;
        }
        int columnIndex = this.getSortColumnIndex(table);
        IGuiIconDescription description = (IGuiIconDescription)object;
        IGuiIconDescription otherDescription = (IGuiIconDescription)other;
        int compare = this.compare(columnIndex, description, otherDescription);
        if (sortDirection == 128) {
            return compare * -1;
        }
        return compare;
    }

    private int compare(int columnIndex, IGuiIconDescription description, IGuiIconDescription otherDescription) {
        switch (columnIndex) {
            case 0: 
            case 1: {
                return this.compareConstantName(description, otherDescription);
            }
            case 2: {
                return this.compare(description, description.getSmallIcon(), otherDescription, otherDescription.getSmallIcon());
            }
            case 3: {
                return this.compare(description, description.getMediumIcon(), otherDescription, otherDescription.getMediumIcon());
            }
            case 4: {
                return this.compare(description, description.getLargeIcon(), otherDescription, otherDescription.getLargeIcon());
            }
            case 5: {
                return this.compareSource(description, description.getSource(), otherDescription, otherDescription.getSource());
            }
            case 6: {
                return String.CASE_INSENSITIVE_ORDER.compare(description.getConstant().getName(), otherDescription.getConstant().getName());
            }
        }
        return 1;
    }

    private int compareSource(IGuiIconDescription description, String source, IGuiIconDescription otherDescription, String otherSource) {
        int compare = String.CASE_INSENSITIVE_ORDER.compare(source, otherSource);
        if (compare == 0) {
            return this.compareConstantName(description, otherDescription);
        }
        return compare;
    }

    private int compare(IGuiIconDescription description, File file, IGuiIconDescription otherDescription, File otherFile) {
        int compare = this.compare(this.getBooleanValue(file), this.getBooleanValue(otherFile));
        if (compare == 0) {
            return this.compareConstantName(description, otherDescription);
        }
        return compare;
    }

    private int compareConstantName(IGuiIconDescription description, IGuiIconDescription otherDescription) {
        int constantNameCompare = String.CASE_INSENSITIVE_ORDER.compare(description.getConstant().getConstantName(), otherDescription.getConstant().getConstantName());
        if (constantNameCompare == 0) {
            return String.CASE_INSENSITIVE_ORDER.compare(description.getConstant().getName(), otherDescription.getConstant().getName());
        }
        return constantNameCompare;
    }

    private int getSortColumnIndex(Table table) {
        TableColumn sortColumn = table.getSortColumn();
        if (sortColumn == null) {
            return -1;
        }
        return this.getColumnIndex(sortColumn.getText());
    }

    private int compare(boolean value, boolean otherValue) {
        return value == otherValue ? 0 : (otherValue ? 1 : -1);
    }

    private boolean getBooleanValue(File file) {
        return file != null;
    }

    private int getColumnIndex(String text) {
        int i = 0;
        while (i < this.titles.length) {
            if (this.titles[i].equals(text)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

