/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.eclipse.icons.view;

import java.util.ArrayList;
import net.anwiba.commons.lang.object.IObjectReceiver;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.eclipse.icons.description.IGuiIconDescription;
import net.anwiba.eclipse.icons.table.TableViewerFactory;
import net.anwiba.eclipse.icons.view.action.CopyAction;
import net.anwiba.eclipse.icons.view.action.ToggleEnabledAction;
import net.anwiba.eclipse.icons.view.listener.GuiIconDragListener;
import net.anwiba.eclipse.icons.view.listener.ViewSiteListener;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IProgressService;

public class GuiIconsView
extends ViewPart {
    private final WritableList<IGuiIconDescription> descriptions = new WritableList(new ArrayList(), IGuiIconDescription.class);
    private ViewSiteListener listener;
    private TableViewer viewer;

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void createPartControl(Composite parent) {
        Composite composite = this.createComposite(parent, 1808, 1, true);
        Composite searchComposite = this.createComposite(composite, 768, 2, false);
        ObjectModel searchStringModel = new ObjectModel();
        Label searchLabel = new Label(searchComposite, 0);
        searchLabel.setText("Search: ");
        Text searchText = new Text(searchComposite, 2176);
        searchText.setLayoutData((Object)new GridData(768));
        searchText.addKeyListener((KeyListener)new KeyAdapter((IObjectModel)searchStringModel, searchText){
            private final /* synthetic */ IObjectModel val$searchStringModel;
            private final /* synthetic */ Text val$searchText;
            {
                this.val$searchStringModel = iObjectModel;
                this.val$searchText = text;
            }

            public void keyReleased(KeyEvent event) {
                this.val$searchStringModel.set((Object)this.val$searchText.getText());
            }
        });
        this.viewer = new TableViewerFactory().createTable(composite, this.descriptions, (IObjectModel<String>)searchStringModel);
        if (this.listener == null) {
            IProgressService progressService = this.getViewSite().getWorkbenchWindow().getWorkbench().getProgressService();
            this.listener = new ViewSiteListener((Device)parent.getDisplay(), progressService, this.descriptions);
            Transfer[] transferTypes = new Transfer[]{TextTransfer.getInstance()};
            this.viewer.addDragSupport(1, transferTypes, (DragSourceListener)new GuiIconDragListener(this.viewer));
        }
        this.initActionBar(parent.getDisplay(), (ISelectionProvider)this.viewer, this.listener);
        final IObjectReceiver<IGuiIconDescription> messageReciever = this.createMessageReceiver(composite);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection.isEmpty()) {
                    messageReciever.set(null);
                }
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                messageReciever.set((Object)((IGuiIconDescription)structuredSelection.getFirstElement()));
            }
        });
        this.getViewSite().getPage().addSelectionListener((ISelectionListener)this.listener);
    }

    private Label createLabel(Composite composite) {
        Label label = new Label(composite, 4);
        label.setLayoutData((Object)new GridData(768));
        return label;
    }

    private IObjectReceiver<IGuiIconDescription> createMessageReceiver(Composite composite) {
        IActionBars bars = this.getViewSite().getActionBars();
        final Label messageLabel = this.createLabel(composite);
        final IStatusLineManager statusLineManager = bars.getStatusLineManager();
        return new IObjectReceiver<IGuiIconDescription>(){

            public void set(IGuiIconDescription description) {
                String message = description == null ? "" : description.getConstant().getName();
                messageLabel.setText(message);
                statusLineManager.setMessage(message);
            }
        };
    }

    private Composite createComposite(Composite parent, int style, int numColumns, boolean makeColumnsEqualWidth) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)this.createLayout(numColumns, makeColumnsEqualWidth));
        composite.setLayoutData((Object)new GridData(style));
        return composite;
    }

    private GridLayout createLayout(int numColumns, boolean makeColumnsEqualWidth) {
        GridLayout gridLayout = new GridLayout(numColumns, makeColumnsEqualWidth);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        return gridLayout;
    }

    private void initActionBar(Display display, ISelectionProvider selectionProvider, ViewSiteListener listener) {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager toolBarManager = bars.getToolBarManager();
        toolBarManager.add((IAction)new CopyAction(display, selectionProvider));
        toolBarManager.add((IAction)new ToggleEnabledAction(listener));
    }

    public void dispose() {
        if (this.listener != null) {
            this.getViewSite().getPage().removeSelectionListener((ISelectionListener)this.listener);
        }
        for (Object object : this.descriptions) {
            IGuiIconDescription description = (IGuiIconDescription)object;
            description.dispose();
        }
        this.descriptions.clear();
        super.dispose();
    }
}

