/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.eclipse.icons.description;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import net.anwiba.eclipse.icons.description.IConstant;
import net.anwiba.eclipse.icons.description.IGuiIconDescription;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class GuiIconDescription
implements IGuiIconDescription {
    private final Device device;
    private final IConstant constant;
    private Image image;
    private final File smallIcon;
    private final File mediumIcon;
    private final File largeIcon;
    private final String source;

    public GuiIconDescription(Device device, IConstant constant, File smallIcon, File mediumIcon, File largeIcon, String source) {
        this.device = device;
        this.constant = constant;
        this.smallIcon = smallIcon;
        this.mediumIcon = mediumIcon;
        this.largeIcon = largeIcon;
        this.source = source;
    }

    @Override
    public IConstant getConstant() {
        return this.constant;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public Image getImage() {
        if (this.image == null && this.getSmallIcon() != null) {
            try {
                this.image = new Image(this.device, new ImageData(this.getSmallIcon().getCanonicalPath()));
            }
            catch (IOException iOException) {
                this.image = null;
            }
        }
        return this.image;
    }

    @Override
    public void dispose() {
        if (this.image == null) {
            return;
        }
        this.image.dispose();
        this.image = null;
    }

    @Override
    public File getSmallIcon() {
        return this.smallIcon;
    }

    @Override
    public File getMediumIcon() {
        return this.mediumIcon;
    }

    @Override
    public File getLargeIcon() {
        return this.largeIcon;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IGuiIconDescription) {
            IGuiIconDescription other = (IGuiIconDescription)obj;
            return Arrays.equals(new Object[]{this.getConstant(), this.getSmallIcon(), this.getMediumIcon(), this.getLargeIcon()}, new Object[]{other.getConstant(), other.getSmallIcon(), other.getMediumIcon(), other.getLargeIcon()});
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.getConstant(), this.getSmallIcon(), this.getMediumIcon(), this.getLargeIcon()});
    }
}

