/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.eclipse.icons.description;

import java.io.File;
import net.anwiba.eclipse.icons.description.Constant;
import net.anwiba.eclipse.icons.description.GuiIconDescription;
import net.anwiba.eclipse.icons.description.IGuiIconDescription;
import net.anwiba.eclipse.icons.io.IconContext;
import net.anwiba.tools.icons.configuration.IIconSizesConfiguration;
import net.anwiba.tools.icons.configuration.generated.Class;
import org.eclipse.swt.graphics.Device;

public class GuiIconDescriptionFactory {
    private final Device device;

    public GuiIconDescriptionFactory(Device device) {
        this.device = device;
    }

    public IGuiIconDescription create(Class clazz, IconContext iconContext) {
        Constant constant = new Constant(clazz.getPackage(), clazz.getName(), iconContext.getResource().getName());
        IIconSizesConfiguration iconSizesConfiguration = iconContext.getResource().getIconSizesConfiguration();
        String folder = iconSizesConfiguration.getFolder();
        File iconsPath = folder == null ? iconContext.getIconsPath() : new File(iconContext.getIconsPath(), folder);
        String imageName = iconContext.getResource().getImage();
        return this.create(constant, iconsPath, iconSizesConfiguration, imageName, iconContext.getSource());
    }

    public IGuiIconDescription create(Class clazz, IconContext iconContext, IconContext referenzedContext) {
        Constant constant = new Constant(clazz.getPackage(), clazz.getName(), iconContext.getResource().getName());
        IIconSizesConfiguration iconSizesConfiguration = referenzedContext.getResource().getIconSizesConfiguration();
        String folder = iconSizesConfiguration.getFolder();
        File iconsPath = folder == null ? referenzedContext.getIconsPath() : new File(referenzedContext.getIconsPath(), folder);
        String imageName = referenzedContext.getResource().getImage();
        if (imageName == null) {
            return null;
        }
        return this.create(constant, iconsPath, iconSizesConfiguration, imageName, iconContext.getSource());
    }

    private IGuiIconDescription create(Constant constant, File iconsPath, IIconSizesConfiguration iconSizesConfiguration, String imageName, String source) {
        File smallIcon = this.create(iconsPath, iconSizesConfiguration.small().path(), imageName);
        File mediumIcon = this.create(iconsPath, iconSizesConfiguration.medium().path(), imageName);
        File largeIcon = this.create(iconsPath, iconSizesConfiguration.large().path(), imageName);
        return new GuiIconDescription(this.device, constant, smallIcon, mediumIcon, largeIcon, source);
    }

    private File create(File iconsPath, String folder, String image) {
        File file;
        if (folder == null) {
            System.out.println();
        }
        if (iconsPath == null) {
            System.out.println();
        }
        if (image == null) {
            System.out.println();
        }
        if (!(file = new File(new File(iconsPath, folder), image)).exists()) {
            return null;
        }
        return file;
    }
}

