/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.eclipse.icons.view.listener;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import net.anwiba.commons.eclipse.utilities.JavaProjectUtilities;
import net.anwiba.commons.thread.cancel.Canceler;
import net.anwiba.commons.thread.cancel.ICanceler;
import net.anwiba.eclipse.icons.GuiIconsViewPlugin;
import net.anwiba.eclipse.icons.description.IGuiIconDescription;
import net.anwiba.eclipse.icons.runner.UpdateRunner;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Device;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.progress.IProgressService;

public final class ViewSiteListener
implements ISelectionListener {
    private final WritableList<IGuiIconDescription> descriptions;
    private final Device device;
    private final IProgressService progressService;
    private Canceler canceler;
    private boolean isEnabled;
    private IJavaProject[] projects = new IJavaProject[0];

    public ViewSiteListener(Device device, IProgressService progressService, WritableList<IGuiIconDescription> input) {
        this.device = device;
        this.progressService = progressService;
        this.descriptions = input;
    }

    public synchronized void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.isEnabled) {
            this.projects = new IJavaProject[0];
            return;
        }
        try {
            Object[] projects = JavaProjectUtilities.getJavaProjects((IWorkbenchPart)part, (ISelection)selection);
            if (Arrays.equals(this.projects, projects)) {
                return;
            }
            this.projects = projects;
            this.canceler = this.createCanceler();
            UpdateRunner runnable = new UpdateRunner((ICanceler)this.canceler, this.device, this.descriptions, (IJavaProject[])projects);
            IWorkbenchWindow context = part.getSite().getWorkbenchWindow();
            this.progressService.runInUI((IRunnableContext)context, (IRunnableWithProgress)runnable, null);
        }
        catch (InvocationTargetException exception) {
            GuiIconsViewPlugin.log(4, 4, exception.getCause());
        }
        catch (InterruptedException exception) {
            GuiIconsViewPlugin.log(4, 8, exception);
        }
    }

    private Canceler createCanceler() {
        if (this.canceler != null) {
            this.canceler.cancel();
        }
        return new Canceler(true);
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }
}

