/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.coordinate.test;

import net.anwiba.commons.lang.functional.IStrategy;
import net.anwiba.spatial.coordinate.Coordinate;
import net.anwiba.spatial.coordinate.CoordinateSequenceFactory;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinate.ICoordinateSequenceFactory;
import org.junit.Assert;
import org.junit.Test;

public class CoordinateSequenceTest {
    final ICoordinateSequenceFactory coordinateSequenceFactory = new CoordinateSequenceFactory();

    @Test
    public void testDimensionLowerTwo() {
        IStrategy<Exception, RuntimeException> strategie = new IStrategy<Exception, RuntimeException>(){

            public Exception execute() {
                try {
                    CoordinateSequenceTest.this.coordinateSequenceFactory.createEmptyCoordinateSequence(1, false);
                }
                catch (Exception e) {
                    return e;
                }
                return null;
            }
        };
        Exception exception = (Exception)strategie.execute();
        Assert.assertEquals(IllegalArgumentException.class, exception.getClass());
        Assert.assertEquals((Object)"Coordinatesequence dimension is lower than 2", (Object)exception.getMessage());
    }

    @Test
    public void testWithMValuedDimensionLowerTwo() {
        IStrategy<Exception, RuntimeException> strategie = new IStrategy<Exception, RuntimeException>(){

            public Exception execute() {
                try {
                    double[][] coordinates = new double[][]{new double[0], new double[0]};
                    CoordinateSequenceTest.this.coordinateSequenceFactory.create((double[][])coordinates, true);
                }
                catch (Exception e) {
                    return e;
                }
                return null;
            }
        };
        Exception exception = (Exception)strategie.execute();
        Assert.assertEquals(IllegalArgumentException.class, exception.getClass());
        Assert.assertEquals((Object)"Coordinatesequence dimension is lower than 2", (Object)exception.getMessage());
    }

    @Test
    public void testOrdinateCountNotEqual() {
        IStrategy<Exception, RuntimeException> strategie = new IStrategy<Exception, RuntimeException>(){

            public Exception execute() {
                try {
                    double[][] coordinates = new double[][]{new double[0], new double[5]};
                    CoordinateSequenceTest.this.coordinateSequenceFactory.create((double[][])coordinates, false);
                }
                catch (Exception e) {
                    return e;
                }
                return null;
            }
        };
        Exception exception = (Exception)strategie.execute();
        Assert.assertEquals(IllegalArgumentException.class, exception.getClass());
        Assert.assertEquals((Object)"ordinates count are not equal", (Object)exception.getMessage());
    }

    @Test
    public void testNoMeasuredValues() {
        IStrategy<Exception, RuntimeException> strategie = new IStrategy<Exception, RuntimeException>(){

            public Exception execute() {
                try {
                    double[][] coordinates = new double[][]{new double[0], new double[0]};
                    CoordinateSequenceTest.this.coordinateSequenceFactory.create((double[][])coordinates, false).getMeasuredValues();
                }
                catch (Exception e) {
                    return e;
                }
                return null;
            }
        };
        Exception exception = (Exception)strategie.execute();
        Assert.assertEquals(IllegalArgumentException.class, exception.getClass());
        Assert.assertEquals((Object)"Coordinatesequence has no measured values", (Object)exception.getMessage());
    }

    @Test
    public void testHasMeasuredValues() {
        double[][] coordinates = new double[][]{new double[0], new double[0], new double[0]};
        double[] measuredValues = this.coordinateSequenceFactory.create((double[][])coordinates, true).getMeasuredValues();
        Assert.assertNotNull((String)"has no measured values", (Object)measuredValues);
    }

    @Test
    public void testHasZValues() {
        double[][] coordinates = new double[][]{new double[0], new double[0], new double[0]};
        double[] zValues = this.coordinateSequenceFactory.create((double[][])coordinates, false).getZValues();
        Assert.assertNotNull((String)"has no z values", (Object)zValues);
        coordinates = new double[][]{new double[0], new double[0], new double[0], new double[0]};
        zValues = this.coordinateSequenceFactory.create((double[][])coordinates, false).getZValues();
        Assert.assertNotNull((String)"has no z values", (Object)zValues);
    }

    @Test
    public void testNoZValues() {
        IStrategy<Exception, RuntimeException> strategie = new IStrategy<Exception, RuntimeException>(){

            public Exception execute() {
                try {
                    double[][] coordinates = new double[][]{new double[0], new double[0]};
                    CoordinateSequenceTest.this.coordinateSequenceFactory.create((double[][])coordinates, false).getZValues();
                }
                catch (Exception e) {
                    return e;
                }
                return null;
            }
        };
        Exception exception = (Exception)strategie.execute();
        Assert.assertEquals(IllegalArgumentException.class, exception.getClass());
        Assert.assertEquals((Object)"Coordinatesequence has no z values", (Object)exception.getMessage());
    }

    @Test
    public void testWithMAndNoZValues() {
        IStrategy<Exception, RuntimeException> strategie = new IStrategy<Exception, RuntimeException>(){

            public Exception execute() {
                try {
                    double[][] coordinates = new double[][]{new double[0], new double[0], new double[0]};
                    CoordinateSequenceTest.this.coordinateSequenceFactory.create((double[][])coordinates, true).getZValues();
                }
                catch (Exception e) {
                    return e;
                }
                return null;
            }
        };
        Exception exception = (Exception)strategie.execute();
        Assert.assertEquals(IllegalArgumentException.class, exception.getClass());
        Assert.assertEquals((Object)"Coordinatesequence has no z values", (Object)exception.getMessage());
    }

    @Test
    public void testValues() {
        double[][] coordinates = new double[][]{{1.0, 2.0, 4.0}, {3.0, 4.0, 5.0}, {5.0, 6.0, 9.0}, {7.0, 8.0, Double.NaN}};
        ICoordinateSequence coordinateSequence = this.coordinateSequenceFactory.create((double[][])coordinates, true);
        Assert.assertEquals((double)1.0, (double)coordinateSequence.getCoordinateN(0).getXValue(), (double)0.0);
        Assert.assertEquals((double)2.0, (double)coordinateSequence.getCoordinateN(1).getXValue(), (double)0.0);
        Assert.assertEquals((double)3.0, (double)coordinateSequence.getCoordinateN(0).getYValue(), (double)0.0);
        Assert.assertEquals((double)4.0, (double)coordinateSequence.getCoordinateN(1).getYValue(), (double)0.0);
        Assert.assertEquals((double)5.0, (double)coordinateSequence.getCoordinateN(0).getZValue(), (double)0.0);
        Assert.assertEquals((double)6.0, (double)coordinateSequence.getCoordinateN(1).getZValue(), (double)0.0);
        Assert.assertTrue((boolean)coordinateSequence.isMeasured());
        Assert.assertEquals((double)7.0, (double)coordinateSequence.getCoordinateN(0).getMeasuredValue(), (double)0.0);
        Assert.assertEquals((double)8.0, (double)coordinateSequence.getCoordinateN(1).getMeasuredValue(), (double)0.0);
        Assert.assertEquals((long)3L, (long)coordinateSequence.getNumberOfCoordinates());
        Assert.assertEquals((Object)new Coordinate(1.0, 3.0, 5.0, 7.0), (Object)coordinateSequence.getCoordinateN(0));
        Assert.assertTrue((boolean)coordinateSequence.getCoordinateN(0).isMeasured());
        Assert.assertTrue((boolean)coordinateSequence.getCoordinateN(1).isMeasured());
        Assert.assertTrue((boolean)coordinateSequence.getCoordinateN(2).isMeasured());
    }

    @Test
    public void testIsClosed() {
        Assert.assertFalse((boolean)this.coordinateSequenceFactory.create(new double[0], new double[0]).isClosed());
        Assert.assertFalse((boolean)this.coordinateSequenceFactory.create(new double[]{1.0, 1.0, 2.0}, new double[]{1.0, 2.0, 2.0}).isClosed());
        Assert.assertTrue((boolean)this.coordinateSequenceFactory.create(new double[]{1.0, 1.0, 1.0}, new double[]{1.0, 2.0, 1.0}).isClosed());
    }
}

