/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.coordinate.test;

import net.anwiba.spatial.coordinate.Coordinate;
import net.anwiba.spatial.coordinate.CoordinateSequenceFactory;
import net.anwiba.spatial.coordinate.Envelope;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinate.ICoordinateSequenceFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class EnvelopeTest {
    ICoordinateSequenceFactory coordinateSequenceFactory = new CoordinateSequenceFactory();

    @Test
    public void testGetCoordinateSequenceForNullEnvelope() {
        ICoordinateSequence sequence = Envelope.NULL_ENVELOPE.getCoordinateSequence();
        Assert.assertThat((Object)sequence.getDimension(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)sequence.getNumberOfCoordinates(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testGetCoordinateSequence() {
        ICoordinateSequence sequence = new Envelope(new double[]{5.0, 5.0}, new double[]{10.0, 10.0}, false).getCoordinateSequence(1);
        Assert.assertThat((Object)sequence.getDimension(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)sequence.getNumberOfCoordinates(), (Matcher)CoreMatchers.equalTo((Object)9));
        Assert.assertThat((Object)sequence.getCoordinateN(0), (Matcher)CoreMatchers.equalTo((Object)new Coordinate(5.0, 5.0)));
        Assert.assertThat((Object)sequence.getCoordinateN(1), (Matcher)CoreMatchers.equalTo((Object)new Coordinate(5.0, 7.5)));
        Assert.assertThat((Object)sequence.getCoordinateN(2), (Matcher)CoreMatchers.equalTo((Object)new Coordinate(5.0, 10.0)));
        Assert.assertThat((Object)sequence.getCoordinateN(3), (Matcher)CoreMatchers.equalTo((Object)new Coordinate(7.5, 10.0)));
        Assert.assertThat((Object)sequence.getCoordinateN(4), (Matcher)CoreMatchers.equalTo((Object)new Coordinate(10.0, 10.0)));
        Assert.assertThat((Object)sequence.getCoordinateN(5), (Matcher)CoreMatchers.equalTo((Object)new Coordinate(10.0, 7.5)));
        Assert.assertThat((Object)sequence.getCoordinateN(6), (Matcher)CoreMatchers.equalTo((Object)new Coordinate(10.0, 5.0)));
        Assert.assertThat((Object)sequence.getCoordinateN(7), (Matcher)CoreMatchers.equalTo((Object)new Coordinate(7.5, 5.0)));
        Assert.assertThat((Object)sequence.getCoordinateN(8), (Matcher)CoreMatchers.equalTo((Object)new Coordinate(5.0, 5.0)));
    }

    @Test
    public void testGetCenterCoordinate() {
        Envelope envelope = new Envelope(new double[]{5.0, 5.0}, new double[]{10.0, 10.0}, false);
        Assert.assertThat((Object)envelope.getCenterCoordinate(), (Matcher)CoreMatchers.equalTo((Object)new Coordinate(7.5, 7.5)));
    }

    @Test
    public void testGetX() {
        Envelope envelope = new Envelope(new double[]{5.0, 5.0}, new double[]{10.0, 10.0}, false);
        Assert.assertThat((Object)envelope.getX(), (Matcher)CoreMatchers.equalTo((Object)5.0));
    }

    @Test
    public void testGetY() {
        Envelope envelope = new Envelope(new double[]{5.0, 5.0}, new double[]{10.0, 10.0}, false);
        Assert.assertThat((Object)envelope.getY(), (Matcher)CoreMatchers.equalTo((Object)5.0));
    }

    @Test
    public void testGetWidth() {
        Envelope envelope = new Envelope(new double[]{5.0, 5.0}, new double[]{10.0, 10.0}, false);
        Assert.assertThat((Object)envelope.getWidth(), (Matcher)CoreMatchers.equalTo((Object)5.0));
    }

    @Test
    public void testGetHeight() {
        Envelope envelope = new Envelope(new double[]{5.0, 5.0}, new double[]{10.0, 10.0}, false);
        Assert.assertThat((Object)envelope.getHeight(), (Matcher)CoreMatchers.equalTo((Object)5.0));
    }
}

