/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.coordinate.junit;

import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.IEnvelope;
import org.junit.Assert;

public class CoordinateAssert
extends Assert {
    public static void assertEquals(IEnvelope expected, IEnvelope actual) {
        CoordinateAssert.assertEquals("", expected.getMinimum(), actual.getMinimum());
        CoordinateAssert.assertEquals("", expected.getMaximum(), actual.getMaximum());
    }

    public static void assertEquals(ICoordinate expected, ICoordinate actual) {
        CoordinateAssert.assertEquals("", expected, actual);
    }

    public static void assertEquals(ICoordinate[] expected, ICoordinate[] actual) {
        if (expected.length != actual.length) {
            CoordinateAssert.fail((String)("coordinate array length differed, expected.length=" + expected.length + " actual.length=" + actual.length));
            return;
        }
        int i = 0;
        while (i < expected.length) {
            CoordinateAssert.assertEquals("array coordinate" + i + ", ", expected[i], actual[i]);
            ++i;
        }
    }

    public static void assertEquals(String message, ICoordinate expected, ICoordinate actual) {
        if (expected.getDimension() != actual.getDimension()) {
            CoordinateAssert.fail((String)(String.valueOf(message) + "coordinate dimension differed, expected.dimension=" + expected.getDimension() + " actual.dimension=" + actual.getDimension()));
            return;
        }
        if (expected.isMeasured() != actual.isMeasured()) {
            CoordinateAssert.fail((String)(String.valueOf(message) + "value of is measured differed, expected.isMeasured=" + expected.isMeasured() + " actual.isMeasured=" + actual.isMeasured()));
            return;
        }
        int i = 0;
        while (i < expected.getDimension()) {
            if (expected.getValue(i) != actual.getValue(i)) {
                CoordinateAssert.fail((String)(String.valueOf(message) + "value of dimension " + i + " differed, expected.value=" + expected.getValue(i) + " actual.value=" + actual.getValue(i)));
            }
            ++i;
        }
        if (expected.isMeasured() && expected.getMeasuredValue() != actual.getMeasuredValue()) {
            CoordinateAssert.fail((String)(String.valueOf(message) + "measured value differed, expected.value=" + expected.getMeasuredValue() + " actual.value=" + actual.getMeasuredValue()));
        }
    }
}

