/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.coordinate.junit;

import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinate.junit.CoordinateAssert;

public class CoordinateSequenceAssert
extends CoordinateAssert {
    public static void assertEquals(ICoordinateSequence expected, ICoordinateSequence actual) {
        CoordinateSequenceAssert.assertEquals("", expected, actual);
    }

    public static void assertEquals(String message, ICoordinateSequence expected, ICoordinateSequence actual) {
        if (expected.getNumberOfCoordinates() != actual.getNumberOfCoordinates()) {
            CoordinateSequenceAssert.fail((String)(String.valueOf(message) + "number of coordinates differed, expected.numberOfCoordinates=" + expected.getNumberOfCoordinates() + " actual.numberOfCoordinates=" + actual.getNumberOfCoordinates()));
            return;
        }
        if (expected.getDimension() != actual.getDimension()) {
            CoordinateSequenceAssert.fail((String)(String.valueOf(message) + "coordinate dimension differed, expected.dimension=" + expected.getDimension() + " actual.dimension=" + actual.getDimension()));
            return;
        }
        if (expected.isMeasured() != actual.isMeasured()) {
            CoordinateSequenceAssert.fail((String)(String.valueOf(message) + "value of is measured differed, expected.isMeasured=" + expected.isMeasured() + " actual.isMeasured=" + actual.isMeasured()));
            return;
        }
        int i = 0;
        while (i < expected.getNumberOfCoordinates()) {
            ICoordinate expectedCoordinate = expected.getCoordinateN(i);
            ICoordinate actualCoordinate = actual.getCoordinateN(i);
            CoordinateAssert.assertEquals(String.valueOf(message) + "coordinate " + i + ", ", expectedCoordinate, actualCoordinate);
            ++i;
        }
    }
}

