/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.coordinate.test;

import net.anwiba.spatial.coordinate.Coordinate;
import net.anwiba.spatial.coordinate.CoordinateSequenceFactory;
import net.anwiba.spatial.coordinate.CoordinateSequenceUtilities;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinate.ICoordinateSequenceFactory;
import net.anwiba.spatial.coordinate.junit.CoordinateSequenceAssert;
import org.junit.Test;

public class CoordinateSequenceUtilitiesTest {
    private final ICoordinateSequenceFactory coordinateSequenceFactory = new CoordinateSequenceFactory();

    @Test
    public void testConcat() throws Exception {
        Coordinate expectedCoordinate = new Coordinate(5.0, 5.0);
        ICoordinateSequence expectedCoordinateSequence = this.coordinateSequenceFactory.create(new ICoordinate[]{expectedCoordinate});
        CoordinateSequenceAssert.assertEquals(expectedCoordinateSequence, CoordinateSequenceUtilities.concat(null, (ICoordinateSequence)expectedCoordinateSequence));
        CoordinateSequenceAssert.assertEquals(expectedCoordinateSequence, CoordinateSequenceUtilities.concat((ICoordinateSequence)expectedCoordinateSequence, null));
        ICoordinateSequence expectedCoordinateSequence01 = this.coordinateSequenceFactory.create(new ICoordinate[]{expectedCoordinate, expectedCoordinate});
        CoordinateSequenceAssert.assertEquals(expectedCoordinateSequence01, CoordinateSequenceUtilities.concat((ICoordinateSequence)expectedCoordinateSequence, (ICoordinateSequence)expectedCoordinateSequence));
        CoordinateSequenceAssert.assertEquals(expectedCoordinateSequence01, CoordinateSequenceUtilities.concat((ICoordinateSequence[])new ICoordinateSequence[]{expectedCoordinateSequence, expectedCoordinateSequence}));
    }

    @Test
    public void testCopy() throws Exception {
        Coordinate expectedCoordinate = new Coordinate(5.0, 5.0);
        ICoordinateSequence expectedCoordinateSequence = this.coordinateSequenceFactory.create(new ICoordinate[]{expectedCoordinate});
        CoordinateSequenceAssert.assertEquals(expectedCoordinateSequence, CoordinateSequenceUtilities.copy((ICoordinateSequence)expectedCoordinateSequence));
    }

    @Test
    public void testCopyPart() throws Exception {
        double[] xs = new double[]{0.0, 5.0, 6.0, 7.0, 8.0, 9.0, 4.0};
        double[] ys = new double[]{4.0, 56.0, 78.0, 9.0, 0.0, 4.0, 7.0};
        double[] exs = new double[]{6.0, 7.0, 8.0, 9.0};
        double[] eys = new double[]{78.0, 9.0, 0.0, 4.0};
        ICoordinateSequence expectedCoordinateSequence = this.coordinateSequenceFactory.create(exs, eys);
        CoordinateSequenceAssert.assertEquals(expectedCoordinateSequence, CoordinateSequenceUtilities.copy((ICoordinateSequence)this.coordinateSequenceFactory.create(xs, ys), (int)2, (int)4));
    }

    @Test
    public void testRevers() throws Exception {
        double[] xs = new double[]{5.0, 5.0, 0.0, 0.0, 5.0};
        double[] ys = new double[]{5.0, 0.0, 0.0, 5.0, 5.0};
        ICoordinateSequence expectedCoordinateSequence = this.coordinateSequenceFactory.create(xs, ys);
        ICoordinateSequence coordinateSequence = this.coordinateSequenceFactory.create(ys, xs);
        CoordinateSequenceAssert.assertEquals(expectedCoordinateSequence, CoordinateSequenceUtilities.reverse((ICoordinateSequence)coordinateSequence));
    }
}

