/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.coordinate;

import net.anwiba.spatial.coordinate.Envelope;
import net.anwiba.spatial.coordinate.EnvelopeUtilities;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.IEnvelope;

public final class TargetEnvelopeCalculator {
    private final double envelopeScaleFactor;
    private final double minimumSizeScale;

    public TargetEnvelopeCalculator(double targetEnvelopeFactor, double notZoomInsideFactor) {
        this.envelopeScaleFactor = targetEnvelopeFactor;
        this.minimumSizeScale = notZoomInsideFactor;
    }

    private IEnvelope scale(IEnvelope envelope, double scaleFactor) {
        double[] oldMin = envelope.getMinimum().getValues();
        double[] oldMax = envelope.getMaximum().getValues();
        double[] min = new double[oldMin.length];
        double[] max = new double[oldMax.length];
        int i = 0;
        while (i < oldMin.length) {
            double oldDist = oldMax[i] - oldMin[i];
            double avg = oldMin[i] + oldDist * 0.5;
            double dist = oldDist * scaleFactor * 0.5;
            min[i] = avg - dist;
            max[i] = avg + dist;
            ++i;
        }
        return new Envelope(min, max, envelope.isMeasured());
    }

    public IEnvelope moveCenterTo(IEnvelope envelope, ICoordinate coordinate) {
        double[] center = coordinate.getValues();
        double[] oldMin = envelope.getMinimum().getValues();
        double[] oldMax = envelope.getMaximum().getValues();
        double[] min = new double[oldMin.length];
        double[] max = new double[oldMax.length];
        int i = 0;
        while (i < 2) {
            double dist = (oldMax[i] - oldMin[i]) * 0.5;
            min[i] = center[i] - dist;
            max[i] = center[i] + dist;
            ++i;
        }
        return new Envelope(min, max, false);
    }

    public IEnvelope calculate(IEnvelope currentEnvelope, IEnvelope maximalEnvelope, IEnvelope objectEnvelope, boolean isMoveEnabled) {
        IEnvelope targetEnvelope = this.scale(objectEnvelope, this.envelopeScaleFactor);
        if (currentEnvelope.contains(objectEnvelope)) {
            if (!isMoveEnabled && currentEnvelope.getWidth() * this.minimumSizeScale > objectEnvelope.getWidth() && currentEnvelope.getHeight() * this.minimumSizeScale > objectEnvelope.getHeight()) {
                return targetEnvelope;
            }
            return currentEnvelope;
        }
        if (isMoveEnabled) {
            return this.moveCenterTo(currentEnvelope, objectEnvelope.getCenterCoordinate());
        }
        if (!EnvelopeUtilities.isNullEnvelope(maximalEnvelope) && (targetEnvelope.getWidth() > maximalEnvelope.getWidth() || targetEnvelope.getHeight() > maximalEnvelope.getWidth() && maximalEnvelope.contains(objectEnvelope))) {
            return maximalEnvelope;
        }
        return targetEnvelope;
    }
}

