/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.coordinate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.anwiba.spatial.coordinate.Envelope;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinate.ICoordinateSequenceSegment;
import net.anwiba.spatial.coordinate.IEnvelope;

public class CompoundCoordinateSequence
implements ICoordinateSequence {
    private static final long serialVersionUID = 1L;
    private final List<ICoordinateSequenceSegment> segments = new ArrayList<ICoordinateSequenceSegment>();
    private final int numberOfCoordinates;
    private final IEnvelope envelope;
    private final boolean isEmpty;
    private final boolean isMeasured;
    private final int dimension;

    CompoundCoordinateSequence(List<ICoordinateSequenceSegment> segments) {
        int pos = 0;
        IEnvelope envelope = Envelope.NULL_ENVELOPE;
        if (segments.isEmpty()) {
            this.numberOfCoordinates = pos;
            this.envelope = envelope;
            this.isEmpty = true;
            this.isMeasured = false;
            this.dimension = 2;
            return;
        }
        boolean isEmpty = true;
        boolean isMeasured = true;
        int dimension = 3;
        for (ICoordinateSequenceSegment segment : segments) {
            int numberOfCoordinates = segment.getNumberOfCoordinates();
            envelope = envelope.concat(segment.getEnvelope());
            pos += numberOfCoordinates;
            isEmpty &= segment.isEmpty();
            isMeasured &= segment.isMeasured();
            dimension = Math.min(dimension, segment.getDimension());
        }
        segments.addAll(segments);
        this.numberOfCoordinates = pos;
        this.envelope = envelope;
        this.isEmpty = isEmpty;
        this.isMeasured = isMeasured;
        this.dimension = dimension;
    }

    private ICoordinate getCoordinate(BiFunction<ICoordinateSequenceSegment, Integer, ICoordinate> function, int index) {
        int from = 0;
        for (ICoordinateSequenceSegment segment : this.segments) {
            int until = from + segment.getNumberOfCoordinates();
            if (index < until) {
                return function.apply(segment, index - from);
            }
            from = until;
        }
        throw new IllegalArgumentException();
    }

    private ICoordinate getCoordinate(int index) {
        return this.getCoordinate((segment, pos) -> segment.getCoordinateN((int)pos), index);
    }

    private double getOrdinate(BiFunction<ICoordinateSequenceSegment, Integer, Double> function, int index) {
        int from = 0;
        for (ICoordinateSequenceSegment segment : this.segments) {
            int until = from + segment.getNumberOfCoordinates();
            if (index < until) {
                return function.apply(segment, index - from);
            }
            from = until;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public double getXValue(int index) {
        return this.getOrdinate((segment, pos) -> segment.getXValue((int)pos), index);
    }

    @Override
    public double getYValue(int index) {
        return this.getOrdinate((segment, pos) -> segment.getYValue((int)pos), index);
    }

    @Override
    public double getZValue(int index) {
        return this.getOrdinate((segment, pos) -> segment.getZValue((int)pos), index);
    }

    @Override
    public double getMeasuredValue(int index) {
        return this.getOrdinate((segment, pos) -> segment.getMeasuredValue((int)pos), index);
    }

    @Override
    public ICoordinate getCoordinateN(int index) {
        ICoordinate coordinate = this.getCoordinate(index);
        return coordinate;
    }

    private double[] getOrdinates(Function<ICoordinateSequenceSegment, double[]> function) {
        double[] values = new double[this.getNumberOfCoordinates()];
        int pos = 0;
        for (ICoordinateSequenceSegment segment : this.segments) {
            int length = segment.getNumberOfCoordinates();
            System.arraycopy(function.apply(segment), 0, segment, pos, length);
            pos += length;
        }
        return values;
    }

    @Override
    public double[] getXValues() {
        return this.getOrdinates(segment -> segment.getXValues());
    }

    @Override
    public double[] getYValues() {
        return this.getOrdinates(segment -> segment.getYValues());
    }

    @Override
    public double[] getZValues() {
        return this.getOrdinates(segment -> segment.getZValues());
    }

    @Override
    public double[] getMeasuredValues() {
        return this.getOrdinates(segment -> segment.getMeasuredValues());
    }

    @Override
    public double[][] getValues() {
        double[][] values = new double[this.getDimension() + (this.isMeasured() ? 1 : 0)][];
        values[0] = this.getXValues();
        values[1] = this.getYValues();
        if (this.getDimension() == 2) {
            if (this.isMeasured()) {
                values[2] = this.getMeasuredValues();
            }
            return values;
        }
        values[2] = this.getZValues();
        if (this.isMeasured()) {
            values[3] = this.getMeasuredValues();
        }
        return values;
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public boolean isMeasured() {
        return this.isMeasured;
    }

    @Override
    public int getNumberOfCoordinates() {
        return this.numberOfCoordinates;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        boolean cordinateFlag = false;
        boolean ordinateFlag = false;
        for (ICoordinate coordinate : this.getCoordinates()) {
            if (cordinateFlag) {
                buffer.append("; ");
            }
            cordinateFlag = true;
            double[] values = coordinate.getValues();
            ordinateFlag = false;
            double[] dArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                double value = dArray[n2];
                if (ordinateFlag) {
                    buffer.append(", ");
                }
                ordinateFlag = true;
                buffer.append(value);
                ++n2;
            }
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public Iterable<ICoordinate> getCoordinates() {
        return new Iterable<ICoordinate>(){

            @Override
            public Iterator<ICoordinate> iterator() {
                return new Iterator<ICoordinate>(){
                    int index = 0;

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public ICoordinate next() {
                        return CompoundCoordinateSequence.this.getCoordinateN(this.index++);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index < CompoundCoordinateSequence.this.getNumberOfCoordinates();
                    }
                };
            }
        };
    }

    @Override
    public boolean isClosed() {
        if (this.getNumberOfCoordinates() == 0) {
            return false;
        }
        return this.getCoordinateN(0).equals(this.getCoordinateN(this.getNumberOfCoordinates() - 1));
    }

    @Override
    public Iterable<ICoordinateSequenceSegment> getCoordinateSequenceSegments() {
        return Collections.unmodifiableCollection(this.segments);
    }

    @Override
    public IEnvelope getEnvelope() {
        return this.envelope;
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    public boolean isCompouned() {
        return true;
    }
}

