/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.coordinate;

import java.util.List;
import net.anwiba.spatial.coordinate.CoordinateSequence;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinate.ICoordinateSequenceFactory;
import net.anwiba.spatial.coordinate.LineCoordinateSequenceSegment;

public class CoordinateSequenceFactory
implements ICoordinateSequenceFactory {
    private static final long serialVersionUID = 1L;

    @Override
    public ICoordinateSequence createEmptyCoordinateSequence(int dimension, boolean isMeasured) {
        double[][] coordinates = this.create(dimension, 0, isMeasured);
        return this.create(coordinates, isMeasured);
    }

    @Override
    public double[][] create(int dimension, int length, boolean isMeasured) {
        int arrayDimension = isMeasured ? dimension + 1 : dimension;
        double[][] coordinates = new double[arrayDimension][];
        int i = 0;
        while (i < coordinates.length) {
            coordinates[i] = new double[length];
            ++i;
        }
        if (isMeasured) {
            i = 0;
            while (i < coordinates[arrayDimension - 1].length) {
                coordinates[arrayDimension - 1][i] = Double.NaN;
                ++i;
            }
        }
        return coordinates;
    }

    @Override
    public ICoordinateSequence create(double[] values, int dimension, boolean isMeasured) {
        int numberOfOrdinates = dimension + (isMeasured ? 1 : 0);
        int numberOfCoordinates = values.length / numberOfOrdinates;
        double[][] coordinates = new double[numberOfOrdinates][numberOfCoordinates];
        int j = 0;
        while (j < numberOfOrdinates) {
            int i = 0;
            while (i < numberOfCoordinates) {
                coordinates[j][i] = values[numberOfOrdinates * i + j];
                ++i;
            }
            ++j;
        }
        return this.create(coordinates, isMeasured);
    }

    @Override
    public ICoordinateSequence create(double xs, double ys) {
        double[][] coordinates = new double[][]{{xs}, {ys}};
        return this.create(coordinates, false);
    }

    @Override
    public ICoordinateSequence create(double xs, double ys, double zs) {
        double[][] coordinates = new double[][]{{xs}, {ys}, {zs}};
        return this.create(coordinates, false);
    }

    @Override
    public ICoordinateSequence create(double xs, double ys, double ns, boolean isMeasured) {
        double[][] coordinates = new double[][]{{xs}, {ys}, {ns}};
        return this.create(coordinates, isMeasured);
    }

    @Override
    public ICoordinateSequence create(double xs, double ys, double zs, double ms) {
        double[][] coordinates = new double[][]{{xs}, {ys}, {zs}, {ms}};
        return this.create(coordinates, true);
    }

    @Override
    public ICoordinateSequence create(double[] xs, double[] ys) {
        double[][] coordinates = new double[][]{xs, ys};
        return this.create(coordinates, false);
    }

    @Override
    public ICoordinateSequence create(double[] xs, double[] ys, double[] ns, boolean isMeasured) {
        double[][] coordinates = new double[][]{xs, ys, ns};
        return this.create(coordinates, isMeasured);
    }

    @Override
    public ICoordinateSequence create(double[] xs, double[] ys, double[] zs, double[] ms) {
        double[][] coordinates = new double[][]{xs, ys, zs, ms};
        return this.create(coordinates, true);
    }

    @Override
    public ICoordinateSequence create(double[][] coordinates) {
        return this.create(coordinates, false);
    }

    @Override
    public ICoordinateSequence create(double[][] coordinates, boolean isMeasured) {
        return new CoordinateSequence(new LineCoordinateSequenceSegment(coordinates, isMeasured));
    }

    @Override
    public ICoordinateSequence create(ICoordinate ... coordinates) {
        double[][] array = new double[CoordinateSequenceFactory.getDimension(coordinates)][];
        int i = 0;
        while (i < array.length) {
            array[i] = new double[coordinates.length];
            int j = 0;
            while (j < coordinates.length) {
                if (coordinates[j] != null) {
                    array[i][j] = coordinates[j].getValues()[i];
                }
                ++j;
            }
            ++i;
        }
        return this.create(array, CoordinateSequenceFactory.isMeasured(coordinates));
    }

    private static int getDimension(ICoordinate[] coordinates) {
        int dimension = Integer.MAX_VALUE;
        ICoordinate[] iCoordinateArray = coordinates;
        int n = coordinates.length;
        int n2 = 0;
        while (n2 < n) {
            ICoordinate coordinate = iCoordinateArray[n2];
            if (coordinate != null) {
                dimension = Math.min(dimension, coordinate.getValues().length);
            }
            ++n2;
        }
        return dimension == Integer.MAX_VALUE ? 2 : dimension;
    }

    private static boolean isMeasured(ICoordinate[] coordinates) {
        ICoordinate[] iCoordinateArray = coordinates;
        int n = coordinates.length;
        int n2 = 0;
        while (n2 < n) {
            ICoordinate coordinate = iCoordinateArray[n2];
            if (!coordinate.isMeasured()) {
                return false;
            }
            ++n2;
        }
        return coordinates.length != 0;
    }

    @Override
    public ICoordinateSequence create(double[] ordinates, int numberOfPoints, int dimensions, boolean isMeasured) {
        double[][] coordinates = new double[dimensions][];
        int i = 0;
        while (i < dimensions) {
            coordinates[i] = new double[numberOfPoints];
            ++i;
        }
        int counter = 0;
        int n = 0;
        while (n < numberOfPoints) {
            int i2 = 0;
            while (i2 < dimensions) {
                coordinates[i2][n] = ordinates[counter++];
                ++i2;
            }
            ++n;
        }
        return this.create(coordinates, isMeasured);
    }

    @Override
    public ICoordinateSequence create(List<ICoordinate> coordinates) {
        return this.create(coordinates.toArray(new ICoordinate[coordinates.size()]));
    }

    @Override
    public ICoordinateSequence create(int coordinateDimension, double[] coordinates, boolean is3D, boolean isMeasured) {
        int numberOfCoordinates = coordinates.length / coordinateDimension;
        double[][] values = new double[coordinateDimension][numberOfCoordinates];
        int i = 0;
        while (i < numberOfCoordinates) {
            int j = 0;
            while (j < coordinateDimension) {
                values[j][i] = coordinates[i * coordinateDimension + j];
                ++j;
            }
            ++i;
        }
        return this.create(values, coordinateDimension == 3 && isMeasured && !is3D || coordinateDimension > 3 && isMeasured);
    }
}

