/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.coordinate;

import net.anwiba.commons.utilities.math.MathWrapper;
import net.anwiba.spatial.coordinate.Coordinate;
import net.anwiba.spatial.coordinate.CoordinateCalculationException;
import net.anwiba.spatial.coordinate.EnvelopeUtilities;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinate.calculator.DefaultCoordinateDistanceCalculator;
import net.anwiba.spatial.coordinate.calculator.ICoordinateDistanceCalculator;
import net.anwiba.spatial.coordinate.calculator.RobustDeterminantCalculator;
import net.anwiba.spatial.coordinate.calculator.SmallPointCalculator;

public class CoordinateUtilities {
    static final ICoordinateDistanceCalculator coordinateDistanceCalculator = new DefaultCoordinateDistanceCalculator();

    public static ICoordinate[] getCoordinates(ICoordinateSequence sequence) {
        ICoordinate[] coordinates = new ICoordinate[sequence.getNumberOfCoordinates()];
        int i = 0;
        while (i < coordinates.length) {
            coordinates[i] = sequence.getCoordinateN(i);
            ++i;
        }
        return coordinates;
    }

    public static double calculateArea(ICoordinateSequence sequence) {
        if (sequence == null || sequence.getNumberOfCoordinates() < 3) {
            return 0.0;
        }
        double sum = 0.0;
        int i = 0;
        while (i < sequence.getNumberOfCoordinates()) {
            ICoordinate prior = CoordinateUtilities.getPrior(sequence, i);
            ICoordinate coordinate = sequence.getCoordinateN(i);
            ICoordinate next = CoordinateUtilities.getNext(sequence, i);
            sum += coordinate.getXValue() * (prior.getYValue() - next.getYValue());
            ++i;
        }
        return sum / 2.0;
    }

    private static ICoordinate getPrior(ICoordinateSequence sequence, int i) {
        if (i == 0) {
            return sequence.getCoordinateN(sequence.getNumberOfCoordinates() - 1);
        }
        return sequence.getCoordinateN(i - 1);
    }

    private static ICoordinate getNext(ICoordinateSequence sequence, int i) {
        if (i + 1 == sequence.getNumberOfCoordinates()) {
            return sequence.getCoordinateN(0);
        }
        return sequence.getCoordinateN(i + 1);
    }

    public static double calculateLength(ICoordinateSequence sequence) {
        double sum = 0.0;
        ICoordinate prior = null;
        for (ICoordinate coordinate : sequence.getCoordinates()) {
            if (prior != null) {
                sum += CoordinateUtilities.calculateDistance(prior, coordinate);
            }
            prior = coordinate;
        }
        return sum;
    }

    public static double calculateDistance(ICoordinate c0, ICoordinate c1) {
        double sum = MathWrapper.pow((double)(c1.getXValue() - c0.getXValue()), (double)2.0) + MathWrapper.pow((double)(c1.getYValue() - c0.getYValue()), (double)2.0);
        return MathWrapper.sqrt((double)sum);
    }

    public static ICoordinate calculateSmallPoint(ICoordinate c0, ICoordinate c1, double s, double r) {
        return new SmallPointCalculator(c0, c1).calculate(s, r);
    }

    public static ICoordinate calculateSmallPoint(ICoordinate c0, ICoordinate c1, double s) throws CoordinateCalculationException {
        double y0;
        double x0 = c0.getXValue();
        if (c1.touch(x0, y0 = c0.getYValue())) {
            throw new CoordinateCalculationException("base points are equal");
        }
        double x1 = c1.getXValue();
        double y1 = c1.getYValue();
        double d = coordinateDistanceCalculator.calculateDistance(x0, y0, x1, y1);
        double xs = x0 + (x1 - x0) / d * s;
        double ys = y0 + (y1 - y0) / d * s;
        if (c0.getDimension() > 2 && c1.getDimension() > 2) {
            double z0 = c0.getZValue();
            double z1 = c1.getZValue();
            double zs = z0 + (z1 - z0) / d * s;
            return new Coordinate(xs, ys, zs, false);
        }
        return new Coordinate(xs, ys);
    }

    public static ICoordinate calculateBasePoint(ICoordinate c0, ICoordinate c1, ICoordinate coordinate) {
        double y0;
        double x0 = c0.getXValue();
        if (c1.touch(x0, y0 = c0.getYValue())) {
            return new Coordinate(x0, y0);
        }
        double x1 = c1.getXValue();
        double y1 = c1.getYValue();
        double x2 = coordinate.getXValue();
        double y2 = coordinate.getYValue();
        if (x0 == x1) {
            return new Coordinate(x0, y2);
        }
        if (y0 == y1) {
            return new Coordinate(x2, y0);
        }
        double m = (y1 - y0) / (x1 - x0);
        double xs = (m * (y2 - y0) + x2 - x0) / (m * m + 1.0) + x0;
        double ys = (xs - x0) * m + y0;
        return new Coordinate(xs, ys);
    }

    public static ICoordinate calculateIntersection(ICoordinate c0, ICoordinate c1, ICoordinate c2, ICoordinate c3) throws CoordinateCalculationException {
        double y2;
        double y0;
        double x0 = c0.getXValue();
        if (c1.touch(x0, y0 = c0.getYValue())) {
            throw new CoordinateCalculationException("base points 0 and 1 are equal");
        }
        double x1 = c1.getXValue();
        double y1 = c1.getYValue();
        double x2 = c2.getXValue();
        if (c3.touch(x2, y2 = c2.getYValue())) {
            throw new CoordinateCalculationException("base points 2 and 3 are equal");
        }
        double x3 = c3.getXValue();
        double y3 = c3.getYValue();
        if (x0 == x1 && x2 == x3 || y0 == y1 && y2 == y3) {
            throw new CoordinateCalculationException("lines are parallel");
        }
        if (x0 == x1) {
            double m1 = (y3 - y2) / (x3 - x2);
            return new Coordinate(x0, y2 + m1 * (x0 - x2));
        }
        if (x2 == x3) {
            double m0 = (y1 - y0) / (x1 - x0);
            return new Coordinate(x2, y0 + m0 * (x3 - x0));
        }
        double m0 = (y1 - y0) / (x1 - x0);
        double m1 = (y3 - y2) / (x3 - x2);
        double d = (y0 - y2 - m0 * (x0 - x2)) / (m1 - m0);
        return new Coordinate(d + x2, y2 + m1 * d);
    }

    public static ICoordinate getAvarageCoordinate(ICoordinate ... coordinates) {
        if (coordinates.length == 1) {
            return coordinates[0];
        }
        ICoordinate centroid = null;
        int i = 0;
        while (i < coordinates.length) {
            ICoordinate coordinate = coordinates[i];
            centroid = centroid == null ? coordinate : CoordinateUtilities.getAvarageCoordinate(centroid, coordinate, i + 1);
            ++i;
        }
        return centroid;
    }

    public static ICoordinate getAvarageCoordinate(ICoordinate c0, ICoordinate c1, int n) {
        if (c0.isMeasured() && c1.isMeasured()) {
            double[] values = new double[MathWrapper.min((int)c0.getDimension(), (int)c1.getDimension()) + 1];
            int i = 0;
            while (i < values.length - 1) {
                values[i] = CoordinateUtilities.getAvarageValue(c0.getValue(i), c1.getValue(i), n);
                ++i;
            }
            values[values.length - 1] = CoordinateUtilities.getAvarageValue(c0.getMeasuredValue(), c1.getMeasuredValue(), n);
            return new Coordinate(values, true);
        }
        double[] values = new double[MathWrapper.min((int)c0.getDimension(), (int)c1.getDimension())];
        int i = 0;
        while (i < values.length) {
            values[i] = CoordinateUtilities.getAvarageValue(c0.getValue(i), c1.getValue(i), n);
            ++i;
        }
        return new Coordinate(values, false);
    }

    public static double getAvarageValue(double m1, double d, int n) {
        return m1 + (d - m1) / (double)n;
    }

    public static boolean isInterior(ICoordinate c0, ICoordinate c1, ICoordinate coordinate) {
        double m2;
        double xmin = MathWrapper.min((double)c0.getXValue(), (double)c1.getXValue());
        double xmax = MathWrapper.max((double)c0.getXValue(), (double)c1.getXValue());
        double xc = coordinate.getXValue();
        if (!(xmin <= xc) || !(xc <= xmax)) {
            return false;
        }
        double ymin = MathWrapper.min((double)c0.getYValue(), (double)c1.getYValue());
        double ymax = MathWrapper.max((double)c0.getYValue(), (double)c1.getYValue());
        double yc = coordinate.getYValue();
        if (!(ymin <= yc) || !(yc <= ymax)) {
            return false;
        }
        if (xmin == xmax) {
            return true;
        }
        if (ymin == ymax) {
            return true;
        }
        double m1 = (c1.getYValue() - c0.getYValue()) / (c1.getXValue() - c0.getXValue());
        double abs = MathWrapper.abs((double)(m1 - (m2 = (yc - c0.getYValue()) / (xc - c0.getXValue()))));
        return abs < 1.0E-8;
    }

    public static boolean isPointInRing(ICoordinate coordinate, ICoordinateSequence ring) {
        double x = coordinate.getXValue();
        double y = coordinate.getYValue();
        boolean isInside = false;
        ICoordinate previous = null;
        for (ICoordinate next : ring.getCoordinates()) {
            if (previous == null) {
                previous = next;
                continue;
            }
            double yp = previous.getYValue();
            double yn = next.getYValue();
            if (yp > y && yn <= y || yn > y && yp <= y) {
                double y0 = yp - y;
                double y1 = yn - y;
                if ((double)RobustDeterminantCalculator.signOfDet(previous.getXValue() - x, y0, next.getXValue() - x, y1) / (y1 - y0) > 0.0) {
                    if (y == yn) continue;
                    isInside = !isInside;
                }
            }
            previous = next;
        }
        return isInside;
    }

    public static boolean interact(ICoordinate coordinate, ICoordinate otherCoordinate, double tolerance) {
        double abs = MathWrapper.abs((double)CoordinateUtilities.calculateDistance(coordinate, otherCoordinate));
        if (Double.isNaN(tolerance) || tolerance == 0.0) {
            double log10;
            double cLog10 = MathWrapper.max((double)MathWrapper.log10((double)MathWrapper.abs((double)coordinate.getXValue())), (double)MathWrapper.log10((double)MathWrapper.abs((double)coordinate.getYValue())));
            return cLog10 - (log10 = MathWrapper.log10((double)abs)) > 12.0;
        }
        return tolerance > abs || tolerance == 0.0 && abs == 0.0;
    }

    public static boolean isCrossing(ICoordinate c0, ICoordinate c1, ICoordinate c2, ICoordinate c3) {
        ICoordinate crossPoint;
        block3: {
            try {
                crossPoint = CoordinateUtilities.calculateIntersection(c0, c1, c2, c3);
                if (!CoordinateUtilities.isInsideRectangle(c0, c1, crossPoint) || !CoordinateUtilities.isInsideRectangle(c2, c3, crossPoint)) break block3;
                return true;
            }
            catch (CoordinateCalculationException coordinateCalculationException) {
                return false;
            }
        }
        return !(!c0.touch(crossPoint) && !c1.touch(crossPoint) || !c2.touch(crossPoint) && !c3.touch(crossPoint));
    }

    public static boolean isInsideRectangle(ICoordinate c0, ICoordinate c1, ICoordinate coordinate) {
        double xmin = MathWrapper.min((double)c0.getXValue(), (double)c1.getXValue());
        double xmax = MathWrapper.max((double)c0.getXValue(), (double)c1.getXValue());
        double xc = coordinate.getXValue();
        if (!(xmin <= xc) || !(xc <= xmax)) {
            return false;
        }
        double ymin = MathWrapper.min((double)c0.getYValue(), (double)c1.getYValue());
        double ymax = MathWrapper.max((double)c0.getYValue(), (double)c1.getYValue());
        double yc = coordinate.getYValue();
        return ymin <= yc && yc <= ymax;
    }

    public static boolean isBetween(ICoordinate c0, ICoordinate c1, ICoordinate coordinate, double tolerance) {
        if (!EnvelopeUtilities.createEnvelope(EnvelopeUtilities.createEnvelope(c0, c1), tolerance).interact(coordinate)) {
            return false;
        }
        if (CoordinateUtilities.interact(coordinate, c0, tolerance)) {
            return true;
        }
        if (CoordinateUtilities.interact(coordinate, c1, tolerance)) {
            return true;
        }
        ICoordinate base = CoordinateUtilities.calculateBasePoint(c0, c1, coordinate);
        return CoordinateUtilities.interact(coordinate, base, tolerance) && CoordinateUtilities.isInterior(c0, c1, base);
    }

    public static ICoordinate calculatePolarCoordinate(ICoordinate coordinate, double angel, double distance) {
        return new Coordinate(coordinate.getXValue() + distance * MathWrapper.sin((double)angel), coordinate.getYValue() + distance * MathWrapper.cos((double)angel));
    }

    public static double calculateAngle(ICoordinate c0, ICoordinate c1) {
        double a = c1.getXValue() - c0.getXValue();
        double b = c1.getYValue() - c0.getYValue();
        if (a == 0.0) {
            if (b > 0.0) {
                return 0.0;
            }
            return Math.PI;
        }
        if (b == 0.0) {
            if (a > 0.0) {
                return 1.5707963267948966;
            }
            return 4.71238898038469;
        }
        double alpha = MathWrapper.atan((double)(a / b));
        if (b < 0.0) {
            return Math.PI + alpha;
        }
        if (a < 0.0) {
            return Math.PI * 2 + alpha;
        }
        return alpha;
    }

    public static ICoordinate getMinimum(ICoordinate coordinate, ICoordinate other) {
        if (coordinate == null) {
            return other;
        }
        if (other == null) {
            return coordinate;
        }
        double x = MathWrapper.min((double)coordinate.getXValue(), (double)other.getXValue());
        double y = MathWrapper.min((double)coordinate.getYValue(), (double)other.getYValue());
        if (MathWrapper.min((int)coordinate.getDimension(), (int)other.getDimension()) == 2) {
            if (coordinate.isMeasured() && other.isMeasured()) {
                return new Coordinate(x, y, MathWrapper.min((double)coordinate.getMeasuredValue(), (double)other.getMeasuredValue()), true);
            }
            return new Coordinate(x, y);
        }
        if (coordinate.isMeasured() && other.isMeasured()) {
            return new Coordinate(x, y, MathWrapper.min((double)coordinate.getZValue(), (double)other.getZValue()), MathWrapper.min((double)coordinate.getMeasuredValue(), (double)other.getMeasuredValue()));
        }
        return new Coordinate(x, y, MathWrapper.min((double)coordinate.getZValue(), (double)other.getZValue()), false);
    }

    public static ICoordinate getMaximum(ICoordinate coordinate, ICoordinate other) {
        if (coordinate == null) {
            return other;
        }
        if (other == null) {
            return coordinate;
        }
        double x = MathWrapper.max((double)coordinate.getXValue(), (double)other.getXValue());
        double y = MathWrapper.max((double)coordinate.getYValue(), (double)other.getYValue());
        if (MathWrapper.min((int)coordinate.getDimension(), (int)other.getDimension()) == 2) {
            if (coordinate.isMeasured() && other.isMeasured()) {
                return new Coordinate(x, y, MathWrapper.max((double)coordinate.getMeasuredValue(), (double)other.getMeasuredValue()), true);
            }
            return new Coordinate(x, y);
        }
        if (coordinate.isMeasured() && other.isMeasured()) {
            return new Coordinate(x, y, MathWrapper.max((double)coordinate.getZValue(), (double)other.getZValue()), MathWrapper.max((double)coordinate.getMeasuredValue(), (double)other.getMeasuredValue()));
        }
        return new Coordinate(x, y, MathWrapper.max((double)coordinate.getZValue(), (double)other.getZValue()), false);
    }

    public static ICoordinate createAdapted(ICoordinate coordinate, int coordinateValueIndex, double value) {
        double[] values = coordinate.getValues();
        values[coordinateValueIndex] = value;
        return new Coordinate(values, coordinate.isMeasured());
    }

    public static ICoordinate getMaximum(ICoordinate ... coordinates) {
        ICoordinate result = null;
        ICoordinate[] iCoordinateArray = coordinates;
        int n = coordinates.length;
        int n2 = 0;
        while (n2 < n) {
            ICoordinate coordinate = iCoordinateArray[n2];
            result = result == null ? coordinate : CoordinateUtilities.getMaximum(result, coordinate);
            ++n2;
        }
        return result;
    }

    public static ICoordinate getMinimum(ICoordinate ... coordinates) {
        ICoordinate result = null;
        ICoordinate[] iCoordinateArray = coordinates;
        int n = coordinates.length;
        int n2 = 0;
        while (n2 < n) {
            ICoordinate coordinate = iCoordinateArray[n2];
            result = result == null ? coordinate : CoordinateUtilities.getMinimum(result, coordinate);
            ++n2;
        }
        return result;
    }
}

