/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.coordinate.calculator;

public class RobustDeterminantCalculator {
    public static int signOfDet(double x0, double y0, double x1, double y1) {
        return RobustDeterminantCalculator.signOfDet(new double[][]{{x0, y0}, {x1, y1}});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int signOfDet(double[][] m) {
        int sign = 1;
        if (m[0][0] == 0.0 || m[1][1] == 0.0) {
            if (m[0][1] != 0.0 && m[1][0] != 0.0) return RobustDeterminantCalculator.signFor(m[0][1], m[1][0], sign);
            return 0;
        }
        if (m[0][1] == 0.0 || m[1][0] == 0.0) {
            return RobustDeterminantCalculator.signFor(m[1][1], m[0][0], -sign);
        }
        sign = RobustDeterminantCalculator.swap(m, sign);
        if (0.0 < m[0][0]) {
            if (!(0.0 < m[1][0])) return sign;
            if (m[0][0] > m[1][0]) {
                return sign;
            }
        } else {
            if (0.0 < m[1][0]) {
                return -sign;
            }
            if (!(m[0][0] >= m[1][0])) return -sign;
            sign = -sign;
            m[0][0] = -m[0][0];
            m[1][0] = -m[1][0];
        }
        do {
            double k = Math.floor(m[1][0] / m[0][0]);
            m[1][0] = m[1][0] - k * m[0][0];
            m[1][1] = m[1][1] - k * m[0][1];
            if (m[1][1] < 0.0) {
                return -sign;
            }
            if (m[1][1] > m[0][1]) {
                return sign;
            }
            if (m[0][0] > m[1][0] + m[1][0]) {
                if (m[0][1] < m[1][1] + m[1][1]) {
                    return sign;
                }
            } else {
                if (m[0][1] > m[1][1] + m[1][1]) {
                    return -sign;
                }
                m[1][0] = m[0][0] - m[1][0];
                m[1][1] = m[0][1] - m[1][1];
                sign = -sign;
            }
            if (m[1][1] == 0.0) {
                if (m[1][0] != 0.0) return -sign;
                return 0;
            }
            if (m[1][0] == 0.0) {
                return sign;
            }
            k = Math.floor(m[0][0] / m[1][0]);
            m[0][0] = m[0][0] - k * m[1][0];
            m[0][1] = m[0][1] - k * m[1][1];
            if (m[0][1] < 0.0) {
                return sign;
            }
            if (m[0][1] > m[1][1]) {
                return -sign;
            }
            if (m[1][0] > m[0][0] + m[0][0]) {
                if (m[1][1] < m[0][1] + m[0][1]) {
                    return -sign;
                }
            } else {
                if (m[1][1] > m[0][1] + m[0][1]) {
                    return sign;
                }
                m[0][0] = m[1][0] - m[0][0];
                m[0][1] = m[1][1] - m[0][1];
                sign = -sign;
            }
            if (m[0][1] != 0.0) continue;
            if (m[0][0] != 0.0) return sign;
            return 0;
        } while (m[0][0] != 0.0);
        return -sign;
    }

    private static int swap(double[][] m, int sign) {
        if (0.0 < m[0][1]) {
            if (0.0 < m[1][1]) {
                if (m[0][1] > m[1][1]) {
                    RobustDeterminantCalculator.swap(m, 1, 1);
                    return -sign;
                }
            } else {
                if (m[0][1] <= -m[1][1]) {
                    RobustDeterminantCalculator.invert(m[1]);
                    return -sign;
                }
                RobustDeterminantCalculator.swap(m, 1, -1);
                return sign;
            }
            return sign;
        }
        if (0.0 < m[1][1]) {
            if (-m[0][1] <= m[1][1]) {
                RobustDeterminantCalculator.invert(m[0]);
                return -sign;
            }
            RobustDeterminantCalculator.swap(m, -1, 1);
            return sign;
        }
        if (m[0][1] >= m[1][1]) {
            RobustDeterminantCalculator.invert(m[0]);
            RobustDeterminantCalculator.invert(m[1]);
            return sign;
        }
        RobustDeterminantCalculator.swap(m, -1, -1);
        return -sign;
    }

    private static void swap(double[][] m, int sign0, int sign1) {
        double swap = (double)sign0 * m[0][0];
        m[0][0] = (double)sign1 * m[1][0];
        m[1][0] = swap;
        swap = (double)sign0 * m[0][1];
        m[0][1] = (double)sign1 * m[1][1];
        m[1][1] = swap;
    }

    private static void invert(double[] m) {
        m[0] = -m[0];
        m[1] = -m[1];
    }

    private static int signFor(double a, double b, int sign) {
        if (a > 0.0) {
            return RobustDeterminantCalculator.signFor(b, sign);
        }
        return RobustDeterminantCalculator.signFor(b, -sign);
    }

    private static int signFor(double b, int sign) {
        if (b > 0.0) {
            return -sign;
        }
        return sign;
    }
}

