/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.coordinate.test;

import net.anwiba.spatial.coordinate.Coordinate;
import net.anwiba.spatial.coordinate.CoordinateSequenceFactory;
import net.anwiba.spatial.coordinate.Envelope;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinate.ICoordinateSequenceFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class EnvelopeTest {
    ICoordinateSequenceFactory coordinateSequenceFactory = new CoordinateSequenceFactory();

    @Test
    public void testGetCoordinateSequenceForNullEnvelope() {
        ICoordinateSequence sequence = Envelope.NULL_ENVELOPE.getCoordinateSequence();
        MatcherAssert.assertThat((Object)sequence.getDimension(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)sequence.getNumberOfCoordinates(), (Matcher)Matchers.equalTo((Object)0));
    }

    @Test
    public void testGetCoordinateSequence() {
        ICoordinateSequence sequence = new Envelope(new double[]{5.0, 5.0}, new double[]{10.0, 10.0}, false).getCoordinateSequence(1);
        MatcherAssert.assertThat((Object)sequence.getDimension(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)sequence.getNumberOfCoordinates(), (Matcher)Matchers.equalTo((Object)9));
        MatcherAssert.assertThat((Object)sequence.getCoordinateN(0), (Matcher)Matchers.equalTo((Object)new Coordinate(5.0, 5.0)));
        MatcherAssert.assertThat((Object)sequence.getCoordinateN(1), (Matcher)Matchers.equalTo((Object)new Coordinate(5.0, 7.5)));
        MatcherAssert.assertThat((Object)sequence.getCoordinateN(2), (Matcher)Matchers.equalTo((Object)new Coordinate(5.0, 10.0)));
        MatcherAssert.assertThat((Object)sequence.getCoordinateN(3), (Matcher)Matchers.equalTo((Object)new Coordinate(7.5, 10.0)));
        MatcherAssert.assertThat((Object)sequence.getCoordinateN(4), (Matcher)Matchers.equalTo((Object)new Coordinate(10.0, 10.0)));
        MatcherAssert.assertThat((Object)sequence.getCoordinateN(5), (Matcher)Matchers.equalTo((Object)new Coordinate(10.0, 7.5)));
        MatcherAssert.assertThat((Object)sequence.getCoordinateN(6), (Matcher)Matchers.equalTo((Object)new Coordinate(10.0, 5.0)));
        MatcherAssert.assertThat((Object)sequence.getCoordinateN(7), (Matcher)Matchers.equalTo((Object)new Coordinate(7.5, 5.0)));
        MatcherAssert.assertThat((Object)sequence.getCoordinateN(8), (Matcher)Matchers.equalTo((Object)new Coordinate(5.0, 5.0)));
    }

    @Test
    public void testGetCenterCoordinate() {
        Envelope envelope = new Envelope(new double[]{5.0, 5.0}, new double[]{10.0, 10.0}, false);
        MatcherAssert.assertThat((Object)envelope.getCenterCoordinate(), (Matcher)Matchers.equalTo((Object)new Coordinate(7.5, 7.5)));
    }

    @Test
    public void testGetX() {
        Envelope envelope = new Envelope(new double[]{5.0, 5.0}, new double[]{10.0, 10.0}, false);
        MatcherAssert.assertThat((Object)envelope.getX(), (Matcher)Matchers.equalTo((Object)5.0));
    }

    @Test
    public void testGetY() {
        Envelope envelope = new Envelope(new double[]{5.0, 5.0}, new double[]{10.0, 10.0}, false);
        MatcherAssert.assertThat((Object)envelope.getY(), (Matcher)Matchers.equalTo((Object)5.0));
    }

    @Test
    public void testGetWidth() {
        Envelope envelope = new Envelope(new double[]{5.0, 5.0}, new double[]{10.0, 10.0}, false);
        MatcherAssert.assertThat((Object)envelope.getWidth(), (Matcher)Matchers.equalTo((Object)5.0));
    }

    @Test
    public void testGetHeight() {
        Envelope envelope = new Envelope(new double[]{5.0, 5.0}, new double[]{10.0, 10.0}, false);
        MatcherAssert.assertThat((Object)envelope.getHeight(), (Matcher)Matchers.equalTo((Object)5.0));
    }
}

