/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.coordinate;

import java.util.Arrays;
import java.util.Objects;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinate.ICoordinateSequenceSegment;
import net.anwiba.spatial.coordinate.IEnvelope;

public class CoordinateSequence
implements ICoordinateSequence {
    private static final long serialVersionUID = 1L;
    private final ICoordinateSequenceSegment segment;
    private int hashcode = -1;

    CoordinateSequence(ICoordinateSequenceSegment coordinateSequenceSegment) {
        this.segment = coordinateSequenceSegment;
    }

    @Override
    public double getXValue(int index) {
        return this.segment.getXValue(index);
    }

    @Override
    public double getYValue(int index) {
        return this.segment.getYValue(index);
    }

    @Override
    public double getZValue(int index) {
        return this.segment.getZValue(index);
    }

    @Override
    public double[] getXValues() {
        return this.segment.getXValues();
    }

    @Override
    public double[] getYValues() {
        return this.segment.getYValues();
    }

    @Override
    public double[] getZValues() {
        return this.segment.getZValues();
    }

    @Override
    public int getDimension() {
        return this.segment.getDimension();
    }

    @Override
    public boolean isMeasured() {
        return this.segment.isMeasured();
    }

    @Override
    public double getMeasuredValue(int index) {
        return this.segment.getMeasuredValue(index);
    }

    @Override
    public double[] getMeasuredValues() {
        return this.segment.getMeasuredValues();
    }

    @Override
    public ICoordinate getCoordinateN(int index) {
        return this.segment.getCoordinateN(index);
    }

    @Override
    public int getNumberOfCoordinates() {
        return this.segment.getNumberOfCoordinates();
    }

    @Override
    public double[][] getValues() {
        return this.segment.getValues();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        boolean cordinateFlag = false;
        boolean ordinateFlag = false;
        for (ICoordinate coordinate : this.getCoordinates()) {
            if (cordinateFlag) {
                buffer.append("; ");
            }
            cordinateFlag = true;
            double[] values = coordinate.getValues();
            ordinateFlag = false;
            for (double value : values) {
                if (ordinateFlag) {
                    buffer.append(", ");
                }
                ordinateFlag = true;
                buffer.append(value);
            }
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public Iterable<ICoordinate> getCoordinates() {
        return this.segment.getCoordinates();
    }

    @Override
    public boolean isClosed() {
        if (this.getNumberOfCoordinates() < 3) {
            return false;
        }
        return this.getCoordinateN(0).equals(this.getCoordinateN(this.getNumberOfCoordinates() - 1));
    }

    @Override
    public Iterable<ICoordinateSequenceSegment> getCoordinateSequenceSegments() {
        return Arrays.asList(this.segment);
    }

    @Override
    public IEnvelope getEnvelope() {
        return this.segment.getEnvelope();
    }

    @Override
    public boolean isEmpty() {
        return this.segment.isEmpty();
    }

    @Override
    public boolean isCompouned() {
        return false;
    }

    public int hashCode() {
        if (this.hashcode == -1) {
            this.hashcode = Objects.hash(this.segment);
        }
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CoordinateSequence other = (CoordinateSequence)obj;
        return Objects.equals(this.segment, other.segment);
    }
}

