/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.coordinate;

import java.util.ArrayList;
import java.util.Collection;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.lang.object.ObjectUtilities;
import net.anwiba.commons.lang.visitor.EnumSwitches;
import net.anwiba.commons.utilities.ArrayUtilities;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.spatial.coordinate.Coordinate;
import net.anwiba.spatial.coordinate.CoordinateSequenceFactory;
import net.anwiba.spatial.coordinate.CoordinateUtilities;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinate.IEnvelope;

public class Envelope
implements IEnvelope {
    private static final long serialVersionUID = -5809619183596261579L;
    private final boolean isMeasured;
    private final ICoordinate maximum;
    private final ICoordinate minimum;
    private final int dimension;
    public static final IEnvelope NULL_ENVELOPE = new Envelope(new double[]{Double.NaN, Double.NaN}, new double[]{Double.NaN, Double.NaN}, false);

    public static IEnvelope create(ICoordinate minimum, ICoordinate maximum) {
        return new Envelope(new double[]{minimum.getXValue(), minimum.getYValue()}, new double[]{maximum.getXValue(), maximum.getYValue()}, false);
    }

    public static IEnvelope create(double minX, double minY, double maxX, double maxY) {
        return new Envelope(new double[]{minX, minY}, new double[]{maxX, maxY}, false);
    }

    public static IEnvelope create(String string) {
        Object[] values = StringUtilities.tokens((String)string, (char)',');
        Double[] doubles = (Double[])ArrayUtilities.convert((IConverter)new IConverter<String, Double, RuntimeException>(){

            public Double convert(String input) throws RuntimeException {
                return Double.valueOf(input);
            }
        }, (Object[])values, Double.class);
        return Envelope.create(doubles[0], doubles[1], doubles[2], doubles[3]);
    }

    public Envelope(double[] min, double[] max, boolean isMeasured) {
        this.minimum = new Coordinate(min, isMeasured);
        this.maximum = new Coordinate(max, isMeasured);
        this.isMeasured = isMeasured;
        this.dimension = Math.min(this.minimum.getDimension(), this.maximum.getDimension());
    }

    @Override
    public boolean isMeasured() {
        return this.isMeasured;
    }

    @Override
    public double getX() {
        return this.minimum.getXValue();
    }

    @Override
    public double getY() {
        return this.minimum.getYValue();
    }

    @Override
    public double getWidth() {
        return this.maximum.getXValue() - this.minimum.getXValue();
    }

    @Override
    public double getHeight() {
        return this.maximum.getYValue() - this.minimum.getYValue();
    }

    @Override
    public ICoordinate getMaximum() {
        return this.maximum;
    }

    @Override
    public ICoordinate getMinimum() {
        return this.minimum;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof IEnvelope)) {
            return false;
        }
        IEnvelope other = (IEnvelope)obj;
        return this.isMeasured == other.isMeasured() && this.dimension == other.getDimension() && ObjectUtilities.equals((Object)this.minimum, (Object)other.getMinimum()) && ObjectUtilities.equals((Object)this.maximum, (Object)other.getMaximum());
    }

    public int hashCode() {
        long bits = 0L;
        bits ^= (long)this.minimum.hashCode();
        return (int)((bits ^= (long)this.maximum.hashCode()) ^ bits >> 32);
    }

    public String toString() {
        return this.minimum.getXValue() + " " + this.minimum.getYValue() + " " + this.maximum.getXValue() + " " + this.maximum.getYValue();
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public ICoordinate getCenterCoordinate() {
        return CoordinateUtilities.getAvarageCoordinate(this.minimum, this.maximum);
    }

    @Override
    public boolean interact(ICoordinate coordinate) {
        int minimumDimension = Math.min(coordinate.getDimension(), this.getDimension());
        for (int i = 0; i < minimumDimension; ++i) {
            double value = coordinate.getValue(i);
            if (!(value < this.minimum.getValue(i)) && !(value > this.maximum.getValue(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean interact(double x, double y) {
        if (x < this.minimum.getXValue() || x > this.maximum.getXValue()) {
            return false;
        }
        return !(y < this.minimum.getYValue()) && !(y > this.maximum.getYValue());
    }

    @Override
    public boolean interact(IEnvelope other) {
        if (other == null) {
            return false;
        }
        for (int i = 0; i < Math.min(this.getDimension(), other.getDimension()); ++i) {
            if (!(other.getMinimum().getValue(i) > this.maximum.getValue(i)) && !(other.getMaximum().getValue(i) < this.minimum.getValue(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(IEnvelope other) {
        if (other == null) {
            return false;
        }
        for (int i = 0; i < Math.min(this.getDimension(), other.getDimension()); ++i) {
            if (other.getMinimum().getValue(i) < this.minimum.getValue(i) || other.getMinimum().getValue(i) > this.maximum.getValue(i)) {
                return false;
            }
            if (!(other.getMaximum().getValue(i) < this.minimum.getValue(i)) && !(other.getMaximum().getValue(i) > this.maximum.getValue(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean cross(ICoordinate c0, ICoordinate c1) {
        if (this.minimum.touch(this.maximum)) {
            return CoordinateUtilities.isInterior(c0, c1, this.minimum);
        }
        Iterable<ICoordinate> coordinates = this.getCoordinateSequence().getCoordinates();
        ICoordinate prior = null;
        for (ICoordinate next : coordinates) {
            if (prior == null) {
                prior = next;
                continue;
            }
            if (CoordinateUtilities.isCrossing(prior, next, c0, c1)) {
                return true;
            }
            prior = next;
        }
        return false;
    }

    @Override
    public ICoordinateSequence getCoordinateSequence() {
        return this.getCoordinateSequence(0);
    }

    @Override
    public ICoordinateSequence getCoordinateSequence(int steps) {
        if (this.equals(NULL_ENVELOPE)) {
            return new CoordinateSequenceFactory().createEmptyCoordinateSequence(2, false);
        }
        if (steps <= 0) {
            ArrayList<ICoordinate> coordinates = new ArrayList<ICoordinate>(5);
            coordinates.add(this.minimum);
            coordinates.add(new Coordinate(this.minimum.getXValue(), this.maximum.getYValue()));
            coordinates.add(this.maximum);
            coordinates.add(new Coordinate(this.maximum.getXValue(), this.minimum.getYValue()));
            coordinates.add(this.minimum);
            return new CoordinateSequenceFactory().create(coordinates);
        }
        ArrayList<ICoordinate> coordinates = new ArrayList<ICoordinate>(5 + 4 * steps);
        coordinates.add(this.minimum);
        coordinates.addAll(this.steps(this.minimum.getXValue(), Axis.X, this.minimum.getYValue(), this.maximum.getYValue(), steps));
        coordinates.add(new Coordinate(this.minimum.getXValue(), this.maximum.getYValue()));
        coordinates.addAll(this.steps(this.maximum.getYValue(), Axis.Y, this.minimum.getXValue(), this.maximum.getXValue(), steps));
        coordinates.add(this.maximum);
        coordinates.addAll(this.steps(this.maximum.getXValue(), Axis.X, this.maximum.getYValue(), this.minimum.getYValue(), steps));
        coordinates.add(new Coordinate(this.maximum.getXValue(), this.minimum.getYValue()));
        coordinates.addAll(this.steps(this.minimum.getYValue(), Axis.Y, this.maximum.getXValue(), this.minimum.getXValue(), steps));
        coordinates.add(this.minimum);
        return new CoordinateSequenceFactory().create(coordinates);
    }

    private Collection<? extends ICoordinate> steps(double value, Axis axis, double min, double max, int steps) {
        ArrayList<ICoordinate> coordinates = new ArrayList<ICoordinate>(steps);
        for (int i = 0; i < steps; ++i) {
            double other = min > max ? max + (min - max) / (double)(steps + 1) * (double)(steps - i) : min + (max - min) / (double)(steps + 1) * (double)(i + 1);
            coordinates.add((ICoordinate)EnumSwitches.of().ifCase(() -> new Coordinate(value, other), (Object[])new Axis[]{Axis.X}).ifCase(() -> new Coordinate(other, value), (Object[])new Axis[]{Axis.Y}).switchTo((Object)axis));
        }
        return coordinates;
    }

    @Override
    public IEnvelope concat(IEnvelope other) {
        if (other == null || NULL_ENVELOPE.equals(other)) {
            return this;
        }
        if (NULL_ENVELOPE.equals(this)) {
            return other;
        }
        int length = Math.min(this.isMeasured ? this.dimension + 1 : this.dimension, other.isMeasured() ? other.getDimension() + 1 : other.getDimension());
        double[] min = this.min(this.minimum.getValues(), other.getMinimum().getValues(), length);
        double[] max = this.max(this.maximum.getValues(), other.getMaximum().getValues(), length);
        return new Envelope(min, max, this.isMeasured && other.isMeasured());
    }

    private double[] max(double[] values, double[] others, int length) {
        double[] result = new double[length];
        for (int i = 0; i < length; ++i) {
            result[i] = Math.max(values[i], others[i]);
        }
        return result;
    }

    private double[] min(double[] values, double[] others, int length) {
        double[] result = new double[length];
        for (int i = 0; i < length; ++i) {
            result[i] = Math.min(values[i], others[i]);
        }
        return result;
    }

    @Override
    public IEnvelope intersection(IEnvelope other) {
        if (other == null || NULL_ENVELOPE.equals(other)) {
            return NULL_ENVELOPE;
        }
        if (NULL_ENVELOPE.equals(this)) {
            return NULL_ENVELOPE;
        }
        if (!this.interact(other)) {
            return NULL_ENVELOPE;
        }
        int length = Math.min(this.isMeasured ? this.dimension + 1 : this.dimension, other.isMeasured() ? other.getDimension() + 1 : other.getDimension());
        double[] min = this.max(this.minimum.getValues(), other.getMinimum().getValues(), length);
        double[] max = this.min(this.maximum.getValues(), other.getMaximum().getValues(), length);
        return new Envelope(min, max, this.isMeasured && other.isMeasured());
    }

    private static enum Axis {
        X,
        Y;

    }
}

