/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.coordinate;

import java.util.Arrays;
import net.anwiba.commons.utilities.ArrayUtilities;
import net.anwiba.spatial.coordinate.Coordinate;
import net.anwiba.spatial.coordinate.Envelope;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinate.IEnvelope;
import net.anwiba.spatial.coordinate.TargetEnvelopeCalculator;

public class EnvelopeUtilities {
    public static IEnvelope concat(IEnvelope envelope, IEnvelope other) {
        if (EnvelopeUtilities.isNullEnvelope(envelope)) {
            return other == null ? Envelope.NULL_ENVELOPE : other;
        }
        return envelope.concat(other);
    }

    public static boolean isNullEnvelope(IEnvelope envelope) {
        return envelope == null || envelope.equals(Envelope.NULL_ENVELOPE);
    }

    public static IEnvelope createEnvelope(Coordinate coordinate, double boundery) {
        double[] minValues = EnvelopeUtilities.getMovedValues(coordinate.getValues(), -boundery);
        double[] maxValues = EnvelopeUtilities.getMovedValues(coordinate.getValues(), boundery);
        return new Envelope(minValues, maxValues, coordinate.isMeasured());
    }

    public static IEnvelope createEnvelope(ICoordinateSequence coordinateSequence) {
        assert (coordinateSequence != null);
        if (coordinateSequence.getNumberOfCoordinates() == 0) {
            return Envelope.NULL_ENVELOPE;
        }
        double[][] coordinates = coordinateSequence.getValues();
        double[] min = new double[coordinates.length];
        double[] max = new double[coordinates.length];
        for (int i = 0; i < coordinates.length; ++i) {
            min[i] = ArrayUtilities.getMin((double[])coordinates[i]);
            max[i] = ArrayUtilities.getMax((double[])coordinates[i]);
        }
        return new Envelope(min, max, coordinateSequence.isMeasured());
    }

    public static IEnvelope createEnvelope(ICoordinate c0, ICoordinate c1) {
        assert (c0 != null);
        assert (c1 != null);
        int length = Math.min(c0.getDimension(), c1.getDimension());
        double[] min = new double[length];
        double[] max = new double[length];
        for (int i = 0; i < length; ++i) {
            min[i] = Math.min(c0.getValue(i), c1.getValue(i));
            max[i] = Math.max(c0.getValue(i), c1.getValue(i));
        }
        return new Envelope(min, max, false);
    }

    public static IEnvelope createEnvelope(IEnvelope envelope, double boundery) {
        if (boundery == 0.0) {
            return envelope;
        }
        double[] minValues = EnvelopeUtilities.getMovedValues(envelope.getMinimum().getValues(), -boundery);
        double[] maxValues = EnvelopeUtilities.getMovedValues(envelope.getMaximum().getValues(), boundery);
        return new Envelope(minValues, maxValues, envelope.isMeasured());
    }

    public static IEnvelope createEnvelope(ICoordinate[] boundingBox) {
        int length = Math.min(boundingBox[0].isMeasured() ? boundingBox[0].getDimension() + 1 : boundingBox[0].getDimension(), boundingBox[1].isMeasured() ? boundingBox[1].getDimension() + 1 : boundingBox[1].getDimension());
        return new Envelope(Arrays.copyOf(boundingBox[0].getValues(), length), Arrays.copyOf(boundingBox[1].getValues(), length), boundingBox[0].isMeasured() && boundingBox[1].isMeasured());
    }

    private static double[] getMovedValues(double[] values, double distance) {
        double[] newValues = new double[values.length];
        for (int i = 0; i < newValues.length; ++i) {
            newValues[i] = values[i] + distance;
        }
        return newValues;
    }

    public static IEnvelope scale(IEnvelope envelope, double scaleFactor) {
        if (scaleFactor == 1.0) {
            return envelope;
        }
        double[] oldMin = envelope.getMinimum().getValues();
        double[] oldMax = envelope.getMaximum().getValues();
        double[] min = new double[oldMin.length];
        double[] max = new double[oldMax.length];
        for (int i = 0; i < oldMin.length; ++i) {
            double oldDist = oldMax[i] - oldMin[i];
            double avg = oldMin[i] + oldDist * 0.5;
            double dist = oldDist * scaleFactor * 0.5;
            min[i] = avg - dist;
            max[i] = avg + dist;
        }
        return new Envelope(min, max, envelope.isMeasured());
    }

    public static IEnvelope moveCenterTo(IEnvelope envelope, ICoordinate coordinate) {
        return new TargetEnvelopeCalculator(3.0, 0.05).moveCenterTo(envelope, coordinate);
    }

    public static IEnvelope calculateTargetEnvelope(IEnvelope currentEnvelope, IEnvelope maximalEnvelope, IEnvelope objectEnvelope, boolean isMoveEnabled) {
        return new TargetEnvelopeCalculator(3.0, 0.05).calculate(currentEnvelope, maximalEnvelope, objectEnvelope, isMoveEnabled);
    }

    public static boolean isInfinity(IEnvelope envelope) {
        return Double.isInfinite(envelope.getMinimum().getXValue()) || Double.isInfinite(envelope.getMinimum().getYValue()) || Double.isInfinite(envelope.getMaximum().getXValue()) || Double.isInfinite(envelope.getMaximum().getYValue());
    }
}

