/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.coordinate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import net.anwiba.commons.lang.object.ObjectPair;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.lang.stream.Streams;
import net.anwiba.commons.utilities.interval.IntegerInterval;
import net.anwiba.spatial.coordinate.Envelope;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinate.ICoordinateSequenceSegment;
import net.anwiba.spatial.coordinate.IEnvelope;

public class MulitSegmentCoordinateSequence
implements ICoordinateSequence {
    private static final long serialVersionUID = 1L;
    private final List<ICoordinateSequenceSegment> segments;
    private final List<ObjectPair<IntegerInterval, ICoordinateSequenceSegment>> indexIntervalsAndSegments = new ArrayList<ObjectPair<IntegerInterval, ICoordinateSequenceSegment>>();
    private IEnvelope envelope;
    boolean isEmpty;
    int numberOfCoordinates;
    private final boolean isMeasured;
    private final int dimension;
    private int hashcode = -1;

    public MulitSegmentCoordinateSequence(List<ICoordinateSequenceSegment> segments) {
        this.segments = segments;
        boolean isEmpty = true;
        int numberOfCoordinates = 0;
        boolean isMeasured = !segments.isEmpty();
        int dimension = segments.isEmpty() ? 2 : Integer.MAX_VALUE;
        for (ICoordinateSequenceSegment segment : this.segments) {
            isMeasured = isMeasured && segment.isMeasured();
            isEmpty = isEmpty && segment.isEmpty();
            IntegerInterval interval = new IntegerInterval(numberOfCoordinates, numberOfCoordinates + segment.getNumberOfCoordinates());
            this.indexIntervalsAndSegments.add((ObjectPair<IntegerInterval, ICoordinateSequenceSegment>)new ObjectPair((Object)interval, (Object)segment));
            numberOfCoordinates = interval.getMaxValue();
            dimension = Math.min(dimension, segment.getDimension());
        }
        this.isEmpty = isEmpty;
        this.numberOfCoordinates = numberOfCoordinates;
        this.isMeasured = isMeasured;
        this.dimension = dimension;
    }

    @Override
    public double getXValue(int index) {
        return this.getCoordinateN(index).getXValue();
    }

    @Override
    public double getYValue(int index) {
        return this.getCoordinateN(index).getYValue();
    }

    @Override
    public double getZValue(int index) {
        return this.getCoordinateN(index).getZValue();
    }

    @Override
    public double[] getXValues() {
        return this.getOrdinates(0);
    }

    private double[] getOrdinates(int index) {
        double[] result = new double[this.numberOfCoordinates];
        for (ObjectPair<IntegerInterval, ICoordinateSequenceSegment> objectPair : this.indexIntervalsAndSegments) {
            double[] values = ((ICoordinateSequenceSegment)objectPair.getSecondObject()).getValues()[index];
            System.arraycopy(values, 0, result, ((IntegerInterval)objectPair.getFirstObject()).getMinValue(), values.length);
        }
        return result;
    }

    @Override
    public double[] getYValues() {
        return this.getOrdinates(1);
    }

    @Override
    public double[] getZValues() {
        return this.getOrdinates(2);
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public boolean isMeasured() {
        return this.isMeasured;
    }

    @Override
    public double getMeasuredValue(int index) {
        return this.getCoordinateN(index).getMeasuredValue();
    }

    @Override
    public double[] getMeasuredValues() {
        if (!this.isMeasured) {
            throw new IllegalArgumentException("Coordinatesequence has no measured values");
        }
        return this.getOrdinates(this.dimension);
    }

    @Override
    public ICoordinate getCoordinateN(int index) {
        for (ObjectPair<IntegerInterval, ICoordinateSequenceSegment> objectPair : this.indexIntervalsAndSegments) {
            if (!((IntegerInterval)objectPair.getFirstObject()).interact(index)) continue;
            return ((ICoordinateSequenceSegment)objectPair.getSecondObject()).getCoordinateN(index - ((IntegerInterval)objectPair.getFirstObject()).getMinValue());
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    @Override
    public int getNumberOfCoordinates() {
        return this.numberOfCoordinates;
    }

    @Override
    public double[][] getValues() {
        double[][] result = new double[this.segments.iterator().next().getValues().length][this.numberOfCoordinates];
        for (ObjectPair<IntegerInterval, ICoordinateSequenceSegment> objectPair : this.indexIntervalsAndSegments) {
            double[][] values = ((ICoordinateSequenceSegment)objectPair.getSecondObject()).getValues();
            for (int i = 0; i < values.length; ++i) {
                System.arraycopy(values[i], 0, result[i], ((IntegerInterval)objectPair.getFirstObject()).getMinValue(), values[0].length);
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        boolean cordinateFlag = false;
        boolean ordinateFlag = false;
        for (ICoordinate coordinate : this.getCoordinates()) {
            if (cordinateFlag) {
                buffer.append("; ");
            }
            cordinateFlag = true;
            double[] values = coordinate.getValues();
            ordinateFlag = false;
            for (double value : values) {
                if (ordinateFlag) {
                    buffer.append(", ");
                }
                ordinateFlag = true;
                buffer.append(value);
            }
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public Iterable<ICoordinate> getCoordinates() {
        return new Iterable<ICoordinate>(){

            @Override
            public Iterator<ICoordinate> iterator() {
                return new Iterator<ICoordinate>(){
                    ICoordinate coordinate = null;
                    Iterator<ICoordinate> coordinateIterator;
                    Iterator<ICoordinateSequenceSegment> segmentsIterator;
                    {
                        this.segmentsIterator = MulitSegmentCoordinateSequence.this.segments.iterator();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public ICoordinate next() {
                        try {
                            if (this.hasNext()) {
                                ICoordinate iCoordinate = this.coordinate;
                                return iCoordinate;
                            }
                            throw new NoSuchElementException();
                        }
                        finally {
                            this.coordinate = null;
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.coordinate != null) {
                            return true;
                        }
                        if (this.coordinateIterator == null || !this.coordinateIterator.hasNext()) {
                            if (!this.segmentsIterator.hasNext()) {
                                return false;
                            }
                            this.coordinateIterator = this.segmentsIterator.next().getCoordinates().iterator();
                            if (!this.coordinateIterator.hasNext()) {
                                return false;
                            }
                        }
                        this.coordinate = this.coordinateIterator.next();
                        return true;
                    }
                };
            }
        };
    }

    @Override
    public boolean isClosed() {
        if (this.getNumberOfCoordinates() < 3) {
            return false;
        }
        return this.getCoordinateN(0).equals(this.getCoordinateN(this.getNumberOfCoordinates() - 1));
    }

    @Override
    public Iterable<ICoordinateSequenceSegment> getCoordinateSequenceSegments() {
        return this.segments;
    }

    @Override
    public IEnvelope getEnvelope() {
        this.envelope = (IEnvelope)Optional.of((Object)this.envelope).getOr(() -> (IEnvelope)Streams.of(this.segments).convert(s -> s.getEnvelope()).aggregate((Object)Envelope.NULL_ENVELOPE, (i, e) -> i.concat((IEnvelope)e)).getOr(() -> Envelope.NULL_ENVELOPE));
        return this.envelope;
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    public boolean isCompouned() {
        return this.segments.size() > 1;
    }

    public int hashCode() {
        if (this.hashcode == -1) {
            this.hashcode = Objects.hash(this.dimension, this.envelope, this.isEmpty, this.isMeasured, this.numberOfCoordinates, this.segments);
        }
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MulitSegmentCoordinateSequence other = (MulitSegmentCoordinateSequence)obj;
        return this.dimension == other.dimension && Objects.equals(this.envelope, other.envelope) && this.isEmpty == other.isEmpty && this.isMeasured == other.isMeasured && this.numberOfCoordinates == other.numberOfCoordinates && Objects.equals(this.segments, other.segments);
    }
}

