/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.coordinate.calculator;

import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinate.Orientation;

public class CoordinateSequenceOrientationCalculator {
    private static int getUpperLeftCoordinateIndex(ICoordinateSequence coordinateSequence) {
        int index = 0;
        int i = 0;
        double minX = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (int j = 0; j < coordinateSequence.getNumberOfCoordinates(); ++j) {
            if (coordinateSequence.getXValue(j) < minX) {
                index = i;
                minX = coordinateSequence.getXValue(j);
                maxY = coordinateSequence.getYValue(j);
            } else if (coordinateSequence.getXValue(j) == minX && maxY > coordinateSequence.getYValue(j)) {
                index = i;
                minX = coordinateSequence.getXValue(j);
                maxY = coordinateSequence.getYValue(j);
            }
            ++i;
        }
        return index;
    }

    public static Orientation getOrientation(ICoordinateSequence coordinateSequence) {
        return CoordinateSequenceOrientationCalculator.isOrientationPositive(coordinateSequence) ? Orientation.POSITIVE : Orientation.NEGATIVE;
    }

    public static boolean isOrientationPositive(ICoordinateSequence coordinateSequence) {
        double b;
        if (coordinateSequence.getNumberOfCoordinates() < 3) {
            throw new IllegalArgumentException("Number of Coordinates must be 3 or more");
        }
        int upperLeftCoordinateIndex = CoordinateSequenceOrientationCalculator.getUpperLeftCoordinateIndex(coordinateSequence);
        ICoordinate upperLeftCoordinate = coordinateSequence.getCoordinateN(upperLeftCoordinateIndex);
        ICoordinate successor = CoordinateSequenceOrientationCalculator.getSuccessor(coordinateSequence, upperLeftCoordinateIndex, upperLeftCoordinate);
        if (upperLeftCoordinate.getXValue() == successor.getXValue()) {
            return false;
        }
        ICoordinate predecessor = CoordinateSequenceOrientationCalculator.getPredecessor(coordinateSequence, upperLeftCoordinateIndex, upperLeftCoordinate);
        if (predecessor.getXValue() == upperLeftCoordinate.getXValue()) {
            return true;
        }
        double a = CoordinateSequenceOrientationCalculator.nullSaveDividing(successor.getYValue() - upperLeftCoordinate.getYValue(), successor.getXValue() - upperLeftCoordinate.getXValue());
        return a <= (b = CoordinateSequenceOrientationCalculator.nullSaveDividing(upperLeftCoordinate.getYValue() - predecessor.getYValue(), upperLeftCoordinate.getXValue() - predecessor.getXValue()));
    }

    private static double nullSaveDividing(double dividend, double divisor) {
        return divisor == 0.0 ? Double.POSITIVE_INFINITY : dividend / divisor;
    }

    private static ICoordinate getPredecessor(ICoordinateSequence coordinateSequence, int upperLeftCoordinateIndex, ICoordinate upperLeftCoordinate) {
        int predecessorIndex;
        int numberOfCoordinates = coordinateSequence.getNumberOfCoordinates();
        int n = predecessorIndex = upperLeftCoordinateIndex == 0 ? numberOfCoordinates - 1 : upperLeftCoordinateIndex - 1;
        while (coordinateSequence.getXValue(predecessorIndex) == upperLeftCoordinate.getXValue() && coordinateSequence.getYValue(predecessorIndex) == upperLeftCoordinate.getYValue()) {
            if (--predecessorIndex == upperLeftCoordinateIndex) {
                return coordinateSequence.getCoordinateN(predecessorIndex);
            }
            if (predecessorIndex >= 0) continue;
            predecessorIndex = numberOfCoordinates - 1;
        }
        return coordinateSequence.getCoordinateN(predecessorIndex);
    }

    private static ICoordinate getSuccessor(ICoordinateSequence coordinateSequence, int upperLeftCoordinateIndex, ICoordinate upperLeftCoordinate) {
        int numberOfCoordinates = coordinateSequence.getNumberOfCoordinates();
        int successorIndex = (upperLeftCoordinateIndex + 1) % numberOfCoordinates;
        while (upperLeftCoordinate.getXValue() == coordinateSequence.getXValue(successorIndex) && upperLeftCoordinate.getYValue() == coordinateSequence.getYValue(successorIndex)) {
            ++successorIndex;
            if ((successorIndex %= numberOfCoordinates) != upperLeftCoordinateIndex) continue;
            return coordinateSequence.getCoordinateN(successorIndex);
        }
        return coordinateSequence.getCoordinateN(successorIndex);
    }
}

