/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.coordinate.calculator;

import net.anwiba.commons.utilities.math.Angle;
import net.anwiba.commons.utilities.math.DirectionAngle;
import net.anwiba.commons.utilities.math.MathWrapper;
import net.anwiba.spatial.coordinate.Coordinate;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.calculator.DefaultCoordinateDirectionCalculator;
import net.anwiba.spatial.coordinate.calculator.IFromPolarCoordinateCalculator;

public class DefaultFromPolarCoordinateCalculator
implements IFromPolarCoordinateCalculator {
    private final DefaultCoordinateDirectionCalculator directionCalculator = new DefaultCoordinateDirectionCalculator();

    @Override
    public ICoordinate calculate(ICoordinate coordinate, double radius, DirectionAngle direction) {
        return new Coordinate(coordinate.getXValue() + radius * MathWrapper.sin((double)direction.getAngle().radian()), coordinate.getYValue() + radius * MathWrapper.cos((double)direction.getAngle().radian()));
    }

    @Override
    public ICoordinate calculate(ICoordinate prior, ICoordinate coordinate, double radius, Angle angle) {
        DirectionAngle direction = this.directionCalculator.calculate(coordinate, prior);
        return this.calculate(coordinate, radius, direction.add(angle));
    }
}

