/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.coordinate.calculator;

import net.anwiba.spatial.coordinate.Coordinate;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.calculator.DefaultCoordinateDistanceCalculator;
import net.anwiba.spatial.coordinate.calculator.ICoordinateDistanceCalculator;

public class SmallPointCalculator {
    public static final double TOLERANCE = 0.005;
    private final ICoordinateDistanceCalculator coordinateDistanceCalculator = new DefaultCoordinateDistanceCalculator();
    private final double x1;
    private final double y1;
    private final double x0;
    private final double y0;
    private final double a;
    private final double o;

    public SmallPointCalculator(ICoordinate c0, ICoordinate c1) {
        this(0.005, c0, c1);
    }

    public SmallPointCalculator(double tolerance, ICoordinate c0, ICoordinate c1) {
        this.x0 = c0.getXValue();
        this.y0 = c0.getYValue();
        this.x1 = c1.getXValue();
        this.y1 = c1.getYValue();
        double d = this.coordinateDistanceCalculator.calculate(this.x0, this.y0, this.x1, this.y1);
        if (Math.abs(d) <= tolerance) {
            throw new IllegalArgumentException("base points are equal");
        }
        this.a = (this.x1 - this.x0) / d;
        this.o = (this.y1 - this.y0) / d;
    }

    public ICoordinate calculate(double s, double r) {
        double xs = this.x0 + this.a * s + this.o * r;
        double ys = this.y0 + this.o * s - this.a * r;
        return new Coordinate(xs, ys);
    }
}

