/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.coordinate.junit;

import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import org.junit.jupiter.api.Assertions;

public class CoordinateSequenceAssert {
    public static void assertEquals(ICoordinateSequence expected, ICoordinateSequence actual) {
        CoordinateSequenceAssert.assertEquals("", expected, actual);
    }

    public static void assertEquals(String message, ICoordinateSequence expected, ICoordinateSequence actual) {
        if (expected.getNumberOfCoordinates() != actual.getNumberOfCoordinates()) {
            Assertions.fail((String)(message + "number of coordinates differed, expected.numberOfCoordinates=" + expected.getNumberOfCoordinates() + " actual.numberOfCoordinates=" + actual.getNumberOfCoordinates()));
            return;
        }
        if (expected.getDimension() != actual.getDimension()) {
            Assertions.fail((String)(message + "coordinate dimension differed, expected.dimension=" + expected.getDimension() + " actual.dimension=" + actual.getDimension()));
            return;
        }
        if (expected.isMeasured() != actual.isMeasured()) {
            Assertions.fail((String)(message + "value of is measured differed, expected.isMeasured=" + expected.isMeasured() + " actual.isMeasured=" + actual.isMeasured()));
            return;
        }
        for (int i = 0; i < expected.getNumberOfCoordinates(); ++i) {
            ICoordinate expectedCoordinate = expected.getCoordinateN(i);
            ICoordinate actualCoordinate = actual.getCoordinateN(i);
            Assertions.assertEquals((Object)expectedCoordinate, (Object)actualCoordinate, (String)(message + "coordinate " + i + ", "));
        }
    }
}

