/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.coordinate.test;

import net.anwiba.commons.lang.functional.IStrategy;
import net.anwiba.spatial.coordinate.Coordinate;
import net.anwiba.spatial.coordinate.CoordinateSequenceFactory;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinate.ICoordinateSequenceFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CoordinateSequenceTest {
    final ICoordinateSequenceFactory coordinateSequenceFactory = new CoordinateSequenceFactory();

    @Test
    public void testDimensionLowerTwo() {
        IStrategy<Exception, RuntimeException> strategie = new IStrategy<Exception, RuntimeException>(){

            public Exception execute() {
                try {
                    CoordinateSequenceTest.this.coordinateSequenceFactory.createEmptyCoordinateSequence(1, false);
                }
                catch (Exception e) {
                    return e;
                }
                return null;
            }
        };
        Exception exception = (Exception)strategie.execute();
        Assertions.assertEquals(IllegalArgumentException.class, exception.getClass());
        Assertions.assertEquals((Object)"Coordinatesequence dimension is lower than 2", (Object)exception.getMessage());
    }

    @Test
    public void testWithMValuedDimensionLowerTwo() {
        IStrategy<Exception, RuntimeException> strategie = new IStrategy<Exception, RuntimeException>(){

            public Exception execute() {
                try {
                    double[][] coordinates = new double[][]{new double[0], new double[0]};
                    CoordinateSequenceTest.this.coordinateSequenceFactory.create((double[][])coordinates, true);
                }
                catch (Exception e) {
                    return e;
                }
                return null;
            }
        };
        Exception exception = (Exception)strategie.execute();
        Assertions.assertEquals(IllegalArgumentException.class, exception.getClass());
        Assertions.assertEquals((Object)"Coordinatesequence dimension is lower than 2", (Object)exception.getMessage());
    }

    @Test
    public void testOrdinateCountNotEqual() {
        IStrategy<Exception, RuntimeException> strategie = new IStrategy<Exception, RuntimeException>(){

            public Exception execute() {
                try {
                    double[][] coordinates = new double[][]{new double[0], new double[5]};
                    CoordinateSequenceTest.this.coordinateSequenceFactory.create((double[][])coordinates, false);
                }
                catch (Exception e) {
                    return e;
                }
                return null;
            }
        };
        Exception exception = (Exception)strategie.execute();
        Assertions.assertEquals(IllegalArgumentException.class, exception.getClass());
        Assertions.assertEquals((Object)"ordinates count are not equal", (Object)exception.getMessage());
    }

    @Test
    public void testNoMeasuredValues() {
        IStrategy<Exception, RuntimeException> strategie = new IStrategy<Exception, RuntimeException>(){

            public Exception execute() {
                try {
                    double[][] coordinates = new double[][]{new double[0], new double[0]};
                    CoordinateSequenceTest.this.coordinateSequenceFactory.create((double[][])coordinates, false).getMeasuredValues();
                }
                catch (Exception e) {
                    return e;
                }
                return null;
            }
        };
        Exception exception = (Exception)strategie.execute();
        Assertions.assertEquals(IllegalArgumentException.class, exception.getClass());
        Assertions.assertEquals((Object)"Coordinatesequence has no measured values", (Object)exception.getMessage());
    }

    @Test
    public void testHasMeasuredValues() {
        double[][] coordinates = new double[][]{new double[0], new double[0], new double[0]};
        double[] measuredValues = this.coordinateSequenceFactory.create((double[][])coordinates, true).getMeasuredValues();
        Assertions.assertNotNull((Object)measuredValues, (String)"has no measured values");
    }

    @Test
    public void testHasZValues() {
        double[][] coordinates = new double[][]{new double[0], new double[0], new double[0]};
        double[] zValues = this.coordinateSequenceFactory.create((double[][])coordinates, false).getZValues();
        Assertions.assertNotNull((Object)zValues, (String)"has no z values");
        coordinates = new double[][]{new double[0], new double[0], new double[0], new double[0]};
        zValues = this.coordinateSequenceFactory.create((double[][])coordinates, false).getZValues();
        Assertions.assertNotNull((Object)zValues, (String)"has no z values");
    }

    @Test
    public void testNoZValues() {
        IStrategy<Exception, RuntimeException> strategie = new IStrategy<Exception, RuntimeException>(){

            public Exception execute() {
                try {
                    double[][] coordinates = new double[][]{new double[0], new double[0]};
                    CoordinateSequenceTest.this.coordinateSequenceFactory.create((double[][])coordinates, false).getZValues();
                }
                catch (Exception e) {
                    return e;
                }
                return null;
            }
        };
        Exception exception = (Exception)strategie.execute();
        Assertions.assertEquals(IllegalArgumentException.class, exception.getClass());
        Assertions.assertEquals((Object)"Coordinatesequence has no z values", (Object)exception.getMessage());
    }

    @Test
    public void testWithMAndNoZValues() {
        IStrategy<Exception, RuntimeException> strategie = new IStrategy<Exception, RuntimeException>(){

            public Exception execute() {
                try {
                    double[][] coordinates = new double[][]{new double[0], new double[0], new double[0]};
                    CoordinateSequenceTest.this.coordinateSequenceFactory.create((double[][])coordinates, true).getZValues();
                }
                catch (Exception e) {
                    return e;
                }
                return null;
            }
        };
        Exception exception = (Exception)strategie.execute();
        Assertions.assertEquals(IllegalArgumentException.class, exception.getClass());
        Assertions.assertEquals((Object)"Coordinatesequence has no z values", (Object)exception.getMessage());
    }

    @Test
    public void testValues() {
        double[][] coordinates = new double[][]{{1.0, 2.0, 4.0}, {3.0, 4.0, 5.0}, {5.0, 6.0, 9.0}, {7.0, 8.0, Double.NaN}};
        ICoordinateSequence coordinateSequence = this.coordinateSequenceFactory.create((double[][])coordinates, true);
        Assertions.assertEquals((double)1.0, (double)coordinateSequence.getCoordinateN(0).getXValue(), (double)0.0);
        Assertions.assertEquals((double)2.0, (double)coordinateSequence.getCoordinateN(1).getXValue(), (double)0.0);
        Assertions.assertEquals((double)3.0, (double)coordinateSequence.getCoordinateN(0).getYValue(), (double)0.0);
        Assertions.assertEquals((double)4.0, (double)coordinateSequence.getCoordinateN(1).getYValue(), (double)0.0);
        Assertions.assertEquals((double)5.0, (double)coordinateSequence.getCoordinateN(0).getZValue(), (double)0.0);
        Assertions.assertEquals((double)6.0, (double)coordinateSequence.getCoordinateN(1).getZValue(), (double)0.0);
        Assertions.assertTrue((boolean)coordinateSequence.isMeasured());
        Assertions.assertEquals((double)7.0, (double)coordinateSequence.getCoordinateN(0).getMeasuredValue(), (double)0.0);
        Assertions.assertEquals((double)8.0, (double)coordinateSequence.getCoordinateN(1).getMeasuredValue(), (double)0.0);
        Assertions.assertEquals((int)3, (int)coordinateSequence.getNumberOfCoordinates());
        Assertions.assertEquals((Object)new Coordinate(1.0, 3.0, 5.0, 7.0), (Object)coordinateSequence.getCoordinateN(0));
        Assertions.assertTrue((boolean)coordinateSequence.getCoordinateN(0).isMeasured());
        Assertions.assertTrue((boolean)coordinateSequence.getCoordinateN(1).isMeasured());
        Assertions.assertTrue((boolean)coordinateSequence.getCoordinateN(2).isMeasured());
    }

    @Test
    public void testIsClosed() {
        Assertions.assertFalse((boolean)this.coordinateSequenceFactory.create(new double[0], new double[0]).isClosed());
        Assertions.assertFalse((boolean)this.coordinateSequenceFactory.create(new double[]{1.0, 1.0, 2.0}, new double[]{1.0, 2.0, 2.0}).isClosed());
        Assertions.assertTrue((boolean)this.coordinateSequenceFactory.create(new double[]{1.0, 1.0, 1.0}, new double[]{1.0, 2.0, 1.0}).isClosed());
    }
}

