/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.coordinate.test;

import net.anwiba.spatial.coordinate.Coordinate;
import net.anwiba.spatial.coordinate.CoordinateUtilities;
import net.anwiba.spatial.coordinate.ICoordinate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CoordinateUtilitiesTest {
    @Test
    public void testCalculateAngle() throws Exception {
        Assertions.assertEquals((double)0.0, (double)CoordinateUtilities.calculateAngle((ICoordinate)new Coordinate(0.0, 0.0), (ICoordinate)new Coordinate(0.0, 10.0)).radian(), (double)0.0);
        Assertions.assertEquals((double)Math.PI, (double)CoordinateUtilities.calculateAngle((ICoordinate)new Coordinate(0.0, 0.0), (ICoordinate)new Coordinate(0.0, -10.0)).radian(), (double)0.0);
        Assertions.assertEquals((double)1.5707963267948966, (double)CoordinateUtilities.calculateAngle((ICoordinate)new Coordinate(0.0, 0.0), (ICoordinate)new Coordinate(10.0, 0.0)).radian(), (double)0.0);
        Assertions.assertEquals((double)4.71238898038469, (double)CoordinateUtilities.calculateAngle((ICoordinate)new Coordinate(0.0, 0.0), (ICoordinate)new Coordinate(-10.0, 0.0)).radian(), (double)0.0);
        Assertions.assertEquals((double)0.7853981633974483, (double)CoordinateUtilities.calculateAngle((ICoordinate)new Coordinate(0.0, 0.0), (ICoordinate)new Coordinate(10.0, 10.0)).radian(), (double)0.0);
        Assertions.assertEquals((double)2.356194490192345, (double)CoordinateUtilities.calculateAngle((ICoordinate)new Coordinate(0.0, 0.0), (ICoordinate)new Coordinate(10.0, -10.0)).radian(), (double)0.0);
        Assertions.assertEquals((double)3.9269908169872414, (double)CoordinateUtilities.calculateAngle((ICoordinate)new Coordinate(0.0, 0.0), (ICoordinate)new Coordinate(-10.0, -10.0)).radian(), (double)0.0);
        Assertions.assertEquals((double)5.497787143782138, (double)CoordinateUtilities.calculateAngle((ICoordinate)new Coordinate(0.0, 0.0), (ICoordinate)new Coordinate(-10.0, 10.0)).radian(), (double)0.0);
    }

    @Test
    public void testCalculateLength() throws Exception {
        Assertions.assertEquals((double)0.0, (double)CoordinateUtilities.calculateDistance((ICoordinate)new Coordinate(0.0, 0.0, 0.0, 0.0), (ICoordinate)new Coordinate(0.0, 0.0, 10.0, 0.0)), (double)0.0);
        Assertions.assertEquals((double)5.0, (double)CoordinateUtilities.calculateDistance((ICoordinate)new Coordinate(0.0, 0.0), (ICoordinate)new Coordinate(3.0, 4.0)), (double)0.0);
        Assertions.assertEquals((double)3.0, (double)CoordinateUtilities.calculateDistance((ICoordinate)new Coordinate(0.0, 0.0, 0.0, false), (ICoordinate)new Coordinate(3.0, 0.0, 4.0, false)), (double)1.0E-13);
    }

    @Test
    public void testCalculatePolarCoordinate() throws Exception {
        ICoordinate coordinate = CoordinateUtilities.calculatePolarCoordinate((ICoordinate)new Coordinate(0.0, 0.0), (double)0.0, (double)10.0);
        Assertions.assertEquals((double)0.0, (double)coordinate.getXValue(), (double)1.0E-13);
        Assertions.assertEquals((double)10.0, (double)coordinate.getYValue(), (double)1.0E-13);
        coordinate = CoordinateUtilities.calculatePolarCoordinate((ICoordinate)new Coordinate(0.0, 0.0), (double)Math.PI, (double)10.0);
        Assertions.assertEquals((double)0.0, (double)coordinate.getXValue(), (double)1.0E-13);
        Assertions.assertEquals((double)-10.0, (double)coordinate.getYValue(), (double)1.0E-13);
        coordinate = CoordinateUtilities.calculatePolarCoordinate((ICoordinate)new Coordinate(0.0, 0.0), (double)1.5707963267948966, (double)10.0);
        Assertions.assertEquals((double)10.0, (double)coordinate.getXValue(), (double)1.0E-13);
        Assertions.assertEquals((double)0.0, (double)coordinate.getYValue(), (double)1.0E-13);
        coordinate = CoordinateUtilities.calculatePolarCoordinate((ICoordinate)new Coordinate(0.0, 0.0), (double)4.71238898038469, (double)10.0);
        Assertions.assertEquals((double)-10.0, (double)coordinate.getXValue(), (double)1.0E-13);
        Assertions.assertEquals((double)0.0, (double)coordinate.getYValue(), (double)1.0E-13);
        double distance = CoordinateUtilities.calculateDistance((ICoordinate)new Coordinate(0.0, 0.0, 0.0, 0.0), (ICoordinate)new Coordinate(10.0, 10.0));
        coordinate = CoordinateUtilities.calculatePolarCoordinate((ICoordinate)new Coordinate(0.0, 0.0), (double)0.7853981633974483, (double)distance);
        Assertions.assertEquals((double)10.0, (double)coordinate.getXValue(), (double)1.0E-13);
        Assertions.assertEquals((double)10.0, (double)coordinate.getYValue(), (double)1.0E-13);
        coordinate = CoordinateUtilities.calculatePolarCoordinate((ICoordinate)new Coordinate(0.0, 0.0), (double)2.356194490192345, (double)distance);
        Assertions.assertEquals((double)10.0, (double)coordinate.getXValue(), (double)1.0E-13);
        Assertions.assertEquals((double)-10.0, (double)coordinate.getYValue(), (double)1.0E-13);
        coordinate = CoordinateUtilities.calculatePolarCoordinate((ICoordinate)new Coordinate(0.0, 0.0), (double)3.9269908169872414, (double)distance);
        Assertions.assertEquals((double)-10.0, (double)coordinate.getXValue(), (double)1.0E-13);
        Assertions.assertEquals((double)-10.0, (double)coordinate.getYValue(), (double)1.0E-13);
        coordinate = CoordinateUtilities.calculatePolarCoordinate((ICoordinate)new Coordinate(0.0, 0.0), (double)5.497787143782138, (double)distance);
        Assertions.assertEquals((double)-10.0, (double)coordinate.getXValue(), (double)1.0E-13);
        Assertions.assertEquals((double)10.0, (double)coordinate.getYValue(), (double)1.0E-13);
    }

    @Test
    public void testCalculateBaseCoordinate() throws Exception {
        Coordinate expected = new Coordinate(0.0, 0.0);
        Coordinate c0 = new Coordinate(0.0, -10.0, 0.0, false);
        Coordinate c1 = new Coordinate(0.0, 10.0, 0.0, false);
        Coordinate c2 = new Coordinate(10.0, 0.0, 0.0, false);
        Assertions.assertEquals((Object)expected, (Object)CoordinateUtilities.calculateBasePoint((ICoordinate)c0, (ICoordinate)c1, (ICoordinate)c2));
    }

    @Test
    public void testIsBetween() throws Exception {
        Coordinate c0 = new Coordinate(0.0, 0.0, 0.0, false);
        Coordinate c1 = new Coordinate(0.0, 10.0, 0.0, false);
        Coordinate c2 = new Coordinate(0.0, 5.0, 0.0, false);
        Assertions.assertTrue((boolean)CoordinateUtilities.isInterior((ICoordinate)c0, (ICoordinate)c1, (ICoordinate)c2));
    }

    @Test
    public void testCrossCoordinate() throws Exception {
        Coordinate expected = new Coordinate(5.0, 5.0);
        Coordinate c0 = new Coordinate(0.0, 0.0, 0.0, false);
        Coordinate c1 = new Coordinate(10.0, 10.0, 0.0, false);
        Coordinate c2 = new Coordinate(0.0, 10.0, 0.0, false);
        Coordinate c3 = new Coordinate(10.0, 0.0, 0.0, false);
        ICoordinate result = CoordinateUtilities.calculateIntersection((ICoordinate)c0, (ICoordinate)c1, (ICoordinate)c2, (ICoordinate)c3);
        Assertions.assertEquals((Object)expected, (Object)result);
        expected = new Coordinate(5.0, 0.0);
        c0 = new Coordinate(0.0, 0.0, 0.0, false);
        c1 = new Coordinate(10.0, 0.0, 0.0, false);
        c2 = new Coordinate(5.0, 5.0, 0.0, false);
        c3 = new Coordinate(5.0, -5.0, 0.0, false);
        result = CoordinateUtilities.calculateIntersection((ICoordinate)c0, (ICoordinate)c1, (ICoordinate)c2, (ICoordinate)c3);
        Assertions.assertEquals((Object)expected, (Object)result);
        expected = new Coordinate(0.0, 5.0);
        c0 = new Coordinate(0.0, 0.0, 0.0, false);
        c1 = new Coordinate(0.0, 10.0, 0.0, false);
        c2 = new Coordinate(5.0, 5.0, 0.0, false);
        c3 = new Coordinate(-5.0, 5.0, 0.0, false);
        result = CoordinateUtilities.calculateIntersection((ICoordinate)c0, (ICoordinate)c1, (ICoordinate)c2, (ICoordinate)c3);
        Assertions.assertEquals((Object)expected, (Object)result);
    }
}

